/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import org.slf4j.Logger;

public class FMLConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static FMLConfig INSTANCE = new FMLConfig();
    private static ConfigSpec configSpec = new ConfigSpec();
    private CommentedFileConfig configData;

    private void loadFrom(Path configFile) {
        this.configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile).sync().onFileNotFound(FileNotFoundAction.copyData((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/META-INF/defaultfmlconfig.toml")))).autosave().autoreload().writingMode(WritingMode.REPLACE).build();
        try {
            this.configData.load();
        }
        catch (ParsingException e) {
            throw new RuntimeException("Failed to load FML config from " + configFile.toString(), e);
        }
        if (!configSpec.isCorrect((Config)this.configData)) {
            LOGGER.warn(LogMarkers.CORE, "Configuration file {} is not correct. Correcting", (Object)configFile);
            configSpec.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> LOGGER.debug(LogMarkers.CORE, "Incorrect key {} was corrected from {} to {}", new Object[]{path, incorrectValue, correctedValue}));
        }
        this.configData.save();
    }

    public static void load() {
        Path configFile = FMLPaths.FMLCONFIG.get();
        INSTANCE.loadFrom(configFile);
        if (LOGGER.isTraceEnabled(LogMarkers.CORE)) {
            LOGGER.trace(LogMarkers.CORE, "Loaded FML config from {}", (Object)FMLPaths.FMLCONFIG.get());
            LOGGER.trace(LogMarkers.CORE, "Splash screen is {}", (Object)FMLConfig.splashScreenEnabled());
            LOGGER.trace(LogMarkers.CORE, "Max threads for mod loading computed at {}", (Object)FMLConfig.loadingThreadCount());
            LOGGER.trace(LogMarkers.CORE, "Version check is {}", (Object)FMLConfig.runVersionCheck());
            LOGGER.trace(LogMarkers.CORE, "Default config paths at {}", (Object)FMLConfig.defaultConfigPath());
        }
        FMLPaths.getOrCreateGameRelativePath(Paths.get(FMLConfig.defaultConfigPath(), new String[0]));
    }

    public static boolean splashScreenEnabled() {
        return FMLConfig.INSTANCE.configData.getOptional("splashscreen").orElse(Boolean.FALSE);
    }

    public static int loadingThreadCount() {
        int val = FMLConfig.INSTANCE.configData.getOptional("maxThreads").orElse(-1);
        if (val <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return val;
    }

    public static boolean runVersionCheck() {
        return FMLConfig.INSTANCE.configData.getOptional("versionCheck").orElse(Boolean.FALSE);
    }

    public static String defaultConfigPath() {
        return FMLConfig.INSTANCE.configData.getOptional("defaultConfigPath").orElse("defaultconfigs");
    }

    public static boolean isOptimizedDFUDisabled() {
        return FMLConfig.INSTANCE.configData.getOptional("disableOptimizedDFU").orElse(Boolean.TRUE);
    }

    static {
        configSpec.define("splashscreen", (Object)Boolean.TRUE);
        configSpec.define("maxThreads", (Object)-1);
        configSpec.define("versionCheck", (Object)Boolean.TRUE);
        configSpec.define("defaultConfigPath", (Object)"defaultconfigs");
        configSpec.define("disableOptimizedDFU", (Object)Boolean.TRUE);
    }
}

