/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.MohistMCStart;
import com.mohistmc.tools.MD5Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mjson.Json;

public class UpdateUtils {
    private static int percentage = 0;

    public static void versionCheck() {
        System.out.println(MohistMCStart.i18n.as("update.check"));
        System.out.println(MohistMCStart.i18n.as("update.stopcheck"));
        try {
            Json json = Json.read(new URL("https://mohistmc.com/api/1.19.4/latest"));
            String jar_sha = MohistMCStart.getVersion();
            String build_number = "1.19.4-" + json.at("number").asInteger();
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(json.at("timeinmillis").asLong()));
            if (jar_sha.equals(build_number)) {
                System.out.println(MohistMCStart.i18n.as("update.latest", jar_sha, build_number));
            } else {
                System.out.println(MohistMCStart.i18n.as("update.detect", build_number, jar_sha, time));
            }
        }
        catch (Throwable e) {
            System.out.println(MohistMCStart.i18n.as("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, File f) throws Exception {
        UpdateUtils.downloadFile(URL2, f, null);
    }

    public static void downloadFile(String URL2, File f, String md5) throws Exception {
        URLConnection conn = UpdateUtils.getConn(URL2);
        System.out.println(MohistMCStart.i18n.as("download.file", f.getName(), UpdateUtils.getSize(conn.getContentLength())));
        ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        int fS = conn.getContentLength();
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(2);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            if (rbc.isOpen()) {
                if (percentage != Math.round((float)f.length() / (float)fS * 100.0f) && percentage < 100) {
                    System.out.println(MohistMCStart.i18n.as("file.download.percentage", f.getName(), percentage));
                }
                percentage = Math.round((float)f.length() / (float)fS * 100.0f);
            }
        }, 3000L, 1000L, TimeUnit.SECONDS);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        percentage = 0;
        String MD5 = MD5Util.get(f);
        if (f.getName().endsWith(".jar") && md5 != null && MD5 != null && !MD5.equals(md5.toLowerCase())) {
            f.delete();
            System.out.println(MohistMCStart.i18n.as("file.download.nook.md5", URL2, MD5, md5.toLowerCase()));
            throw new Exception("md5");
        }
        System.out.println(MohistMCStart.i18n.as("download.file.ok", f.getName()));
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }

    public static URLConnection getConn(String URL2) {
        URLConnection conn = null;
        try {
            conn = new URL(URL2).openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:31.0) Gecko/20100101 Firefox/31.0");
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        return conn;
    }
}

