/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.config;

import com.mohistmc.MohistMCStart;
import com.mohistmc.i18n.i18n;
import com.mohistmc.network.download.DownloadSource;
import com.mohistmc.yaml.file.YamlConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class MohistConfigUtil {
    public static final File mohistyml = new File("mohist-config", "mohist.yml");
    public static final YamlConfiguration yml = YamlConfiguration.loadConfiguration(mohistyml);

    public static void copyMohistConfig() {
        try {
            if (!mohistyml.exists()) {
                mohistyml.createNewFile();
            }
        }
        catch (Exception e) {
            System.out.println("File init exception!");
        }
    }

    public static boolean INSTALLATIONFINISHED() {
        return yml.getBoolean("mohist.installation-finished", false);
    }

    public static boolean CHECK_UPDATE_AUTO_DOWNLOAD() {
        String key = "mohist.check_update_auto_download";
        if (yml.get(key) == null) {
            yml.set(key, false);
            MohistConfigUtil.save();
        }
        return yml.getBoolean(key, false);
    }

    public static boolean CHECK_LIBRARIES() {
        String key = "mohist.libraries.check";
        if (System.getProperty("libraries.check") != null) {
            return Boolean.parseBoolean(System.getProperty("libraries.check"));
        }
        if (yml.get(key) == null) {
            yml.set(key, true);
            MohistConfigUtil.save();
        }
        return yml.getBoolean(key, true);
    }

    public static String LIBRARIES_DOWNLOADSOURCE() {
        String key = "mohist.libraries.downloadsource";
        if (yml.get(key) == null) {
            yml.set(key, DownloadSource.defaultSource.name());
            MohistConfigUtil.save();
        }
        return yml.getString(key, DownloadSource.defaultSource.name());
    }

    public static boolean CHECK_UPDATE() {
        String key = "mohist.check_update";
        if (yml.get(key) == null) {
            yml.set(key, true);
            MohistConfigUtil.save();
        }
        return yml.getBoolean(key, true);
    }

    public static boolean CHECK_CLIENT_MODS() {
        String key = "mohist.check_client_mods";
        if (yml.get(key) == null) {
            yml.set(key, false);
            MohistConfigUtil.save();
        }
        return yml.getBoolean(key, false);
    }

    public static boolean aBoolean(String key, boolean defaultReturn) {
        return yml.getBoolean(key, defaultReturn);
    }

    public static void save() {
        try {
            yml.save(mohistyml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String MOHISTLANG() {
        String key = "mohist.lang";
        if (yml.get(key) == null) {
            yml.set(key, Locale.getDefault().toString());
            MohistConfigUtil.save();
        }
        return yml.getString(key, Locale.getDefault().toString());
    }

    public static void i18n() {
        MohistMCStart.i18n = new i18n(MohistMCStart.class.getClassLoader(), MohistConfigUtil.MOHISTLANG());
    }
}

