/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class RepoRemapper
extends CustomRemapper {
    private final CustomRemapper remapper;
    private final ClassRepo classRepo;

    public RepoRemapper(CustomRemapper remapper, ClassRepo classRepo) {
        this.remapper = remapper;
        this.classRepo = classRepo;
    }

    public String map(String typeName) {
        return this.remapper.map(typeName);
    }

    @Override
    public String mapMethodName(String owner, String name, String desc) {
        return this.mapMethodName(owner, name, desc, this.findAccess(NodeType.METHOD, owner, name, desc));
    }

    @Override
    public String mapMethodName(String owner, String name, String desc, int access) {
        return this.remapper.mapMethodName(owner, name, desc, access);
    }

    @Override
    public String mapFieldName(String owner, String name, String desc) {
        return this.mapFieldName(owner, name, desc, this.findAccess(NodeType.FIELD, owner, name, desc));
    }

    @Override
    public String mapFieldName(String owner, String name, String desc, int access) {
        return this.remapper.mapFieldName(owner, name, desc, access);
    }

    private int findAccess(NodeType type, String owner, String name, String desc, ClassRepo repo) {
        ClassNode clazz;
        int access = -1;
        if (repo != null && (clazz = this.classRepo.findClass(owner)) != null) {
            block0 : switch (type) {
                case FIELD: {
                    for (FieldNode f : clazz.fields) {
                        if (!f.name.equals(name) || !f.desc.equals(desc)) continue;
                        access = f.access;
                        break block0;
                    }
                    break;
                }
                case METHOD: {
                    for (MethodNode m : this.classRepo.findClass((String)owner).methods) {
                        if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
                        access = m.access;
                        break block0;
                    }
                    break;
                }
            }
        }
        return access;
    }

    public int findAccess(NodeType type, String owner, String name, String desc) {
        int access = this.findAccess(type, owner, name, desc, this.classRepo);
        if (access == -1) {
            access = this.findAccess(type, owner, name, desc, RuntimeRepo.getInstance());
        }
        return access;
    }
}

