/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.asm;

import com.mohistmc.asm.EnumDefinalizer;
import com.mohistmc.asm.Implementer;
import com.mohistmc.asm.SwitchTableFixer;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class MohistImplementer
implements ILaunchPluginService {
    private static final EnumSet<ILaunchPluginService.Phase> OH_YES_SIR = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NOT_TODAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private final Map<String, Implementer> implementers = new HashMap<String, Implementer>();
    private volatile Consumer<String[]> auditAcceptor;
    private ILaunchPluginService.ITransformerLoader transformerLoader;

    public String name() {
        return "mohist_implementer";
    }

    public void initializeLaunch(ILaunchPluginService.ITransformerLoader transformerLoader, NamedPath[] specialPaths) {
        this.transformerLoader = transformerLoader;
        this.implementers.put("switch", SwitchTableFixer.INSTANCE);
        this.implementers.put("enum", new EnumDefinalizer());
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty, String reason) {
        if ("mixin".equals(reason)) {
            return NOT_TODAY;
        }
        return isEmpty ? NOT_TODAY : OH_YES_SIR;
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        throw new IllegalStateException("Outdated ModLauncher");
    }

    public void customAuditConsumer(String className, Consumer<String[]> auditDataAcceptor) {
        this.auditAcceptor = auditDataAcceptor;
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if ("mixin".equals(reason)) {
            return false;
        }
        ArrayList<String> trails = new ArrayList<String>();
        for (Map.Entry<String, Implementer> entry : this.implementers.entrySet()) {
            String key = entry.getKey();
            Implementer implementer = entry.getValue();
            if (!implementer.processClass(classNode, this.transformerLoader)) continue;
            trails.add(key);
        }
        if (this.auditAcceptor != null && !trails.isEmpty()) {
            this.auditAcceptor.accept(new String[]{String.join((CharSequence)",", trails)});
        }
        return !trails.isEmpty();
    }
}

