/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public class ArrayListDeque<T>
extends AbstractList<T>
implements Serializable,
Cloneable,
Deque<T>,
RandomAccess {
    private static final int f_291793_ = 1;
    private Object[] f_291627_;
    private int f_290855_;
    private int f_291128_;

    public ArrayListDeque() {
        this(1);
    }

    public ArrayListDeque(int p_299918_) {
        this.f_291627_ = new Object[p_299918_];
        this.f_290855_ = 0;
        this.f_291128_ = 0;
    }

    @Override
    public int size() {
        return this.f_291128_;
    }

    @VisibleForTesting
    public int m_296007_() {
        return this.f_291627_.length;
    }

    private int m_294983_(int p_299728_) {
        return (p_299728_ + this.f_290855_) % this.f_291627_.length;
    }

    @Override
    public T get(int p_300499_) {
        this.m_295904_(p_300499_);
        return this.m_294419_(this.m_294983_(p_300499_));
    }

    private static void m_292853_(int p_299791_, int p_299333_) {
        if (p_299791_ < 0 || p_299791_ >= p_299333_) {
            throw new IndexOutOfBoundsException(p_299791_);
        }
    }

    private void m_295904_(int p_298701_) {
        ArrayListDeque.m_292853_(p_298701_, this.f_291128_);
    }

    private T m_294419_(int p_299306_) {
        return (T)this.f_291627_[p_299306_];
    }

    @Override
    public T set(int p_300259_, T p_298094_) {
        this.m_295904_(p_300259_);
        Objects.requireNonNull(p_298094_);
        int $$2 = this.m_294983_(p_300259_);
        T $$3 = this.m_294419_($$2);
        this.f_291627_[$$2] = p_298094_;
        return $$3;
    }

    @Override
    public void add(int p_301285_, T p_300734_) {
        ArrayListDeque.m_292853_(p_301285_, this.f_291128_ + 1);
        Objects.requireNonNull(p_300734_);
        if (this.f_291128_ == this.f_291627_.length) {
            this.m_295184_();
        }
        int $$2 = this.m_294983_(p_301285_);
        if (p_301285_ == this.f_291128_) {
            this.f_291627_[$$2] = p_300734_;
        } else if (p_301285_ == 0) {
            --this.f_290855_;
            if (this.f_290855_ < 0) {
                this.f_290855_ += this.f_291627_.length;
            }
            this.f_291627_[this.m_294983_((int)0)] = p_300734_;
        } else {
            for (int $$3 = this.f_291128_ - 1; $$3 >= p_301285_; --$$3) {
                this.f_291627_[this.m_294983_((int)($$3 + 1))] = this.f_291627_[this.m_294983_($$3)];
            }
            this.f_291627_[$$2] = p_300734_;
        }
        ++this.modCount;
        ++this.f_291128_;
    }

    private void m_295184_() {
        int $$0 = this.f_291627_.length + Math.max(this.f_291627_.length >> 1, 1);
        Object[] $$1 = new Object[$$0];
        this.m_294976_($$1, this.f_291128_);
        this.f_290855_ = 0;
        this.f_291627_ = $$1;
    }

    @Override
    public T remove(int p_297670_) {
        this.m_295904_(p_297670_);
        int $$1 = this.m_294983_(p_297670_);
        T $$2 = this.m_294419_($$1);
        if (p_297670_ == 0) {
            this.f_291627_[$$1] = null;
            ++this.f_290855_;
        } else if (p_297670_ == this.f_291128_ - 1) {
            this.f_291627_[$$1] = null;
        } else {
            for (int $$3 = p_297670_ + 1; $$3 < this.f_291128_; ++$$3) {
                this.f_291627_[this.m_294983_((int)($$3 - 1))] = this.get($$3);
            }
            this.f_291627_[this.m_294983_((int)(this.f_291128_ - 1))] = null;
        }
        ++this.modCount;
        --this.f_291128_;
        return $$2;
    }

    @Override
    public boolean removeIf(Predicate<? super T> p_300785_) {
        int $$1 = 0;
        for (int $$2 = 0; $$2 < this.f_291128_; ++$$2) {
            T $$3 = this.get($$2);
            if (p_300785_.test($$3)) {
                ++$$1;
                continue;
            }
            if ($$1 == 0) continue;
            this.f_291627_[this.m_294983_((int)($$2 - $$1))] = $$3;
            this.f_291627_[this.m_294983_((int)$$2)] = null;
        }
        this.modCount += $$1;
        this.f_291128_ -= $$1;
        return $$1 != 0;
    }

    private void m_294976_(Object[] p_300471_, int p_298513_) {
        for (int $$2 = 0; $$2 < p_298513_; ++$$2) {
            p_300471_[$$2] = this.get($$2);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<T> p_299491_) {
        for (int $$1 = 0; $$1 < this.f_291128_; ++$$1) {
            int $$2 = this.m_294983_($$1);
            this.f_291627_[$$2] = Objects.requireNonNull(p_299491_.apply(this.m_294419_($$1)));
        }
    }

    @Override
    public void forEach(Consumer<? super T> p_297273_) {
        for (int $$1 = 0; $$1 < this.f_291128_; ++$$1) {
            p_297273_.accept(this.get($$1));
        }
    }

    @Override
    public void addFirst(T p_300853_) {
        this.add(0, p_300853_);
    }

    @Override
    public void addLast(T p_301090_) {
        this.add(this.f_291128_, p_301090_);
    }

    @Override
    public boolean offerFirst(T p_300075_) {
        this.addFirst(p_300075_);
        return true;
    }

    @Override
    public boolean offerLast(T p_300597_) {
        this.addLast(p_300597_);
        return true;
    }

    @Override
    public T removeFirst() {
        if (this.f_291128_ == 0) {
            throw new NoSuchElementException();
        }
        return this.remove(0);
    }

    @Override
    public T removeLast() {
        if (this.f_291128_ == 0) {
            throw new NoSuchElementException();
        }
        return this.remove(this.f_291128_ - 1);
    }

    @Override
    @Nullable
    public T pollFirst() {
        if (this.f_291128_ == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    @Nullable
    public T pollLast() {
        if (this.f_291128_ == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public T getFirst() {
        if (this.f_291128_ == 0) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    public T getLast() {
        if (this.f_291128_ == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this.f_291128_ - 1);
    }

    @Override
    @Nullable
    public T peekFirst() {
        if (this.f_291128_ == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    @Nullable
    public T peekLast() {
        if (this.f_291128_ == 0) {
            return null;
        }
        return this.getLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object p_300960_) {
        for (int $$1 = 0; $$1 < this.f_291128_; ++$$1) {
            T $$2 = this.get($$1);
            if (!Objects.equals(p_300960_, $$2)) continue;
            this.remove($$1);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object p_297293_) {
        for (int $$1 = this.f_291128_ - 1; $$1 >= 0; --$$1) {
            T $$2 = this.get($$1);
            if (!Objects.equals(p_297293_, $$2)) continue;
            this.remove($$1);
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(T p_299376_) {
        return this.offerLast(p_299376_);
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    @Override
    @Nullable
    public T poll() {
        return this.pollFirst();
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    @Nullable
    public T peek() {
        return this.peekFirst();
    }

    @Override
    public void push(T p_298076_) {
        this.addFirst(p_298076_);
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new DescendingIterator();
    }

    class DescendingIterator
    implements Iterator<T> {
        private int f_291243_;

        public DescendingIterator() {
            this.f_291243_ = ArrayListDeque.this.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.f_291243_ >= 0;
        }

        @Override
        public T next() {
            return ArrayListDeque.this.get(this.f_291243_--);
        }

        @Override
        public void remove() {
            ArrayListDeque.this.remove(this.f_291243_ + 1);
        }
    }
}

