/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class EventLogDirectory {
    static final Logger f_260444_ = LogUtils.getLogger();
    private static final int f_260477_ = 4096;
    private static final String f_260455_ = ".gz";
    private final Path f_260592_;
    private final String f_260512_;

    private EventLogDirectory(Path p_261546_, String p_261467_) {
        this.f_260592_ = p_261546_;
        this.f_260512_ = p_261467_;
    }

    public static EventLogDirectory m_260952_(Path p_261743_, String p_261659_) throws IOException {
        Files.createDirectories(p_261743_, new FileAttribute[0]);
        return new EventLogDirectory(p_261743_, p_261659_);
    }

    public FileList m_261134_() throws IOException {
        try (Stream<Path> $$0 = Files.list(this.f_260592_);){
            FileList fileList = new FileList($$0.filter(p_262170_ -> Files.isRegularFile(p_262170_, new LinkOption[0])).map(this::m_260829_).filter(Objects::nonNull).toList());
            return fileList;
        }
    }

    @Nullable
    private File m_260829_(Path p_261985_) {
        String $$1 = p_261985_.getFileName().toString();
        int $$2 = $$1.indexOf(46);
        if ($$2 == -1) {
            return null;
        }
        FileId $$3 = FileId.m_260977_($$1.substring(0, $$2));
        if ($$3 != null) {
            String $$4 = $$1.substring($$2);
            if ($$4.equals(this.f_260512_)) {
                return new RawFile(p_261985_, $$3);
            }
            if ($$4.equals(this.f_260512_ + f_260455_)) {
                return new CompressedFile(p_261985_, $$3);
            }
        }
        return null;
    }

    static void m_260828_(Path p_261741_, Path p_262101_) throws IOException {
        if (Files.exists(p_262101_, new LinkOption[0])) {
            throw new IOException("Compressed target file already exists: " + p_262101_);
        }
        try (FileChannel $$2 = FileChannel.open(p_261741_, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            FileLock $$3 = $$2.tryLock();
            if ($$3 == null) {
                throw new IOException("Raw log file is already locked, cannot compress: " + p_261741_);
            }
            EventLogDirectory.m_261201_($$2, p_262101_);
            $$2.truncate(0L);
        }
        Files.delete(p_261741_);
    }

    private static void m_261201_(ReadableByteChannel p_262066_, Path p_262054_) throws IOException {
        try (GZIPOutputStream $$2 = new GZIPOutputStream(Files.newOutputStream(p_262054_, new OpenOption[0]));){
            byte[] $$3 = new byte[4096];
            ByteBuffer $$4 = ByteBuffer.wrap($$3);
            while (p_262066_.read($$4) >= 0) {
                $$4.flip();
                ((OutputStream)$$2).write($$3, 0, $$4.limit());
                $$4.clear();
            }
        }
    }

    public RawFile m_261046_(LocalDate p_261865_) throws IOException {
        FileId $$3;
        int $$1 = 1;
        Set<FileId> $$2 = this.m_261134_().m_261047_();
        while ($$2.contains($$3 = new FileId(p_261865_, $$1++))) {
        }
        RawFile $$4 = new RawFile(this.f_260592_.resolve($$3.m_261263_(this.f_260512_)), $$3);
        Files.createFile($$4.m_261161_(), new FileAttribute[0]);
        return $$4;
    }

    public static class FileList
    implements Iterable<File> {
        private final List<File> f_260732_;

        FileList(List<File> p_261941_) {
            this.f_260732_ = new ArrayList<File>(p_261941_);
        }

        public FileList m_261245_(LocalDate p_261825_, int p_261918_) {
            this.f_260732_.removeIf(p_261494_ -> {
                FileId $$3 = p_261494_.m_260796_();
                LocalDate $$4 = $$3.f_260711_().plusDays(p_261918_);
                if (!p_261825_.isBefore($$4)) {
                    try {
                        Files.delete(p_261494_.m_261161_());
                        return true;
                    }
                    catch (IOException $$5) {
                        f_260444_.warn("Failed to delete expired event log file: {}", (Object)p_261494_.m_261161_(), (Object)$$5);
                    }
                }
                return false;
            });
            return this;
        }

        public FileList m_261127_() {
            ListIterator<File> $$0 = this.f_260732_.listIterator();
            while ($$0.hasNext()) {
                File $$1 = $$0.next();
                try {
                    $$0.set($$1.m_260857_());
                }
                catch (IOException $$2) {
                    f_260444_.warn("Failed to compress event log file: {}", (Object)$$1.m_261161_(), (Object)$$2);
                }
            }
            return this;
        }

        @Override
        public Iterator<File> iterator() {
            return this.f_260732_.iterator();
        }

        public Stream<File> m_260849_() {
            return this.f_260732_.stream();
        }

        public Set<FileId> m_261047_() {
            return this.f_260732_.stream().map(File::m_260796_).collect(Collectors.toSet());
        }
    }

    public record FileId(LocalDate f_260711_, int f_260602_) {
        private static final DateTimeFormatter f_260524_ = DateTimeFormatter.BASIC_ISO_DATE;

        @Nullable
        public static FileId m_260977_(String p_261762_) {
            int $$1 = p_261762_.indexOf("-");
            if ($$1 == -1) {
                return null;
            }
            String $$2 = p_261762_.substring(0, $$1);
            String $$3 = p_261762_.substring($$1 + 1);
            try {
                return new FileId(LocalDate.parse($$2, f_260524_), Integer.parseInt($$3));
            }
            catch (NumberFormatException | DateTimeParseException $$4) {
                return null;
            }
        }

        @Override
        public String toString() {
            return f_260524_.format(this.f_260711_) + "-" + this.f_260602_;
        }

        public String m_261263_(String p_261982_) {
            return this + p_261982_;
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FileId.class, "date;index", "f_260711_", "f_260602_"}, this);
        }

        @Override
        public final boolean equals(Object p_261763_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FileId.class, "date;index", "f_260711_", "f_260602_"}, this, p_261763_);
        }
    }

    public static final class RawFile
    extends Record
    implements File {
        private final Path f_260693_;
        private final FileId f_260438_;

        public RawFile(Path f_260693_, FileId f_260438_) {
            this.f_260693_ = f_260693_;
            this.f_260438_ = f_260438_;
        }

        public FileChannel m_261200_() throws IOException {
            return FileChannel.open(this.f_260693_, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }

        @Override
        @Nullable
        public Reader m_261064_() throws IOException {
            return Files.exists(this.f_260693_, new LinkOption[0]) ? Files.newBufferedReader(this.f_260693_) : null;
        }

        @Override
        public CompressedFile m_260857_() throws IOException {
            Path $$0 = this.f_260693_.resolveSibling(this.f_260693_.getFileName().toString() + EventLogDirectory.f_260455_);
            EventLogDirectory.m_260828_(this.f_260693_, $$0);
            return new CompressedFile($$0, this.f_260438_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RawFile.class, "path;id", "f_260693_", "f_260438_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RawFile.class, "path;id", "f_260693_", "f_260438_"}, this);
        }

        @Override
        public final boolean equals(Object p_261834_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RawFile.class, "path;id", "f_260693_", "f_260438_"}, this, p_261834_);
        }

        @Override
        public Path m_261161_() {
            return this.f_260693_;
        }

        @Override
        public FileId m_260796_() {
            return this.f_260438_;
        }
    }

    public static final class CompressedFile
    extends Record
    implements File {
        private final Path f_260707_;
        private final FileId f_260728_;

        public CompressedFile(Path f_260707_, FileId f_260728_) {
            this.f_260707_ = f_260707_;
            this.f_260728_ = f_260728_;
        }

        @Override
        @Nullable
        public Reader m_261064_() throws IOException {
            if (!Files.exists(this.f_260707_, new LinkOption[0])) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(this.f_260707_, new OpenOption[0]))));
        }

        @Override
        public CompressedFile m_260857_() {
            return this;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CompressedFile.class, "path;id", "f_260707_", "f_260728_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CompressedFile.class, "path;id", "f_260707_", "f_260728_"}, this);
        }

        @Override
        public final boolean equals(Object p_262017_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CompressedFile.class, "path;id", "f_260707_", "f_260728_"}, this, p_262017_);
        }

        @Override
        public Path m_261161_() {
            return this.f_260707_;
        }

        @Override
        public FileId m_260796_() {
            return this.f_260728_;
        }
    }

    public static interface File {
        public Path m_261161_();

        public FileId m_260796_();

        @Nullable
        public Reader m_261064_() throws IOException;

        public CompressedFile m_260857_() throws IOException;
    }
}

