/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class VersionChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static final int HTTP_TIMEOUT_SECS = Integer.getInteger("http.timeoutSecs", 15);
    private static Map<IModInfo, CheckResult> results = new ConcurrentHashMap<IModInfo, CheckResult>();
    private static final CheckResult PENDING_CHECK = new CheckResult(Status.PENDING, null, null, null);

    public static void startVersionCheck() {
        new Thread("Forge Version Check"){
            private HttpClient client;

            @Override
            public void run() {
                if (!FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.VERSION_CHECK)) {
                    LOGGER.info("Global Forge version check system disabled, no further processing.");
                    return;
                }
                this.client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(HTTP_TIMEOUT_SECS)).build();
                VersionChecker.gatherMods().forEach(this::process);
            }

            private String openUrlString(URL url, IModInfo mod) throws IOException, URISyntaxException, InterruptedException {
                URL currentUrl = url;
                StringBuilder sb = new StringBuilder();
                sb.append("Java-http-client/").append(System.getProperty("java.version")).append(' ');
                sb.append("MinecraftForge/").append(FMLLoader.versionInfo().mcAndForgeVersion()).append(' ');
                sb.append(mod.getModId()).append('/').append(mod.getVersion());
                String userAgent = sb.toString();
                for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
                    HttpRequest request = HttpRequest.newBuilder().uri(currentUrl.toURI()).timeout(Duration.ofSeconds(HTTP_TIMEOUT_SECS)).setHeader("Accept-Encoding", "gzip").setHeader("User-Agent", userAgent).GET().build();
                    HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    int responseCode = response.statusCode();
                    if (responseCode < 300 || responseCode > 399) {
                        String bodyStr;
                        boolean isGzipEncoded = response.headers().firstValue("Content-Encoding").orElse("").equals("gzip");
                        try (InputStream inStream = isGzipEncoded ? new GZIPInputStream(response.body()) : response.body();
                             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));){
                            bodyStr = bufferedReader.lines().collect(Collectors.joining("\n"));
                        }
                        return bodyStr;
                    }
                    String newLocation = response.headers().firstValue("Location").orElseThrow(() -> new IOException("Got a 3xx response code but Location header was null while trying to fetch " + String.valueOf(url)));
                    currentUrl = new URL(currentUrl, newLocation);
                }
                throw new IOException("Too many redirects while trying to fetch " + String.valueOf(url));
            }

            private void process(IModInfo mod) {
                Status status = Status.PENDING;
                ComparableVersion target = null;
                LinkedHashMap<ComparableVersion, String> changes = null;
                String display_url = null;
                try {
                    if (mod.getUpdateURL().isEmpty()) {
                        return;
                    }
                    URL url = (URL)mod.getUpdateURL().get();
                    LOGGER.info("[{}] Starting version check at {}", (Object)mod.getModId(), (Object)url.toString());
                    String data = this.openUrlString(url, mod);
                    LOGGER.debug("[{}] Received version check data:\n{}", (Object)mod.getModId(), (Object)data);
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    display_url = (String)json.get("homepage");
                    String mcVersion = FMLLoader.versionInfo().mcVersion();
                    String rec = (String)promos.get(mcVersion + "-recommended");
                    String lat = (String)promos.get(mcVersion + "-latest");
                    ComparableVersion current = new ComparableVersion(mod.getVersion().toString());
                    if (rec != null) {
                        ComparableVersion recommended = new ComparableVersion(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            ComparableVersion latest;
                            status = Status.AHEAD;
                            if (lat != null && current.compareTo(latest = new ComparableVersion(lat)) < 0) {
                                status = Status.OUTDATED;
                                target = latest;
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        ComparableVersion latest = new ComparableVersion(lat);
                        status = current.compareTo(latest) < 0 ? Status.BETA_OUTDATED : Status.BETA;
                        target = latest;
                    } else {
                        status = Status.BETA;
                    }
                    LOGGER.info("[{}] Found status: {} Current: {} Target: {}", (Object)mod.getModId(), (Object)status, (Object)current, target);
                    changes = new LinkedHashMap<ComparableVersion, String>();
                    Map tmp = (Map)json.get(mcVersion);
                    if (tmp != null) {
                        ArrayList<ComparableVersion> ordered = new ArrayList<ComparableVersion>();
                        for (String key : tmp.keySet()) {
                            ComparableVersion ver = new ComparableVersion(key);
                            if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                            ordered.add(ver);
                        }
                        Collections.sort(ordered);
                        for (ComparableVersion ver : ordered) {
                            changes.put(ver, (String)tmp.get(ver.toString()));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to process update information", (Throwable)e);
                    status = Status.FAILED;
                }
                results.put(mod, new CheckResult(status, target, changes, display_url));
            }
        }.start();
    }

    private static List<IModInfo> gatherMods() {
        LinkedList<IModInfo> ret = new LinkedList<IModInfo>();
        for (IModInfo info : ModList.get().getMods()) {
            if (!info.getUpdateURL().isPresent()) continue;
            ret.add(info);
        }
        return ret;
    }

    public static CheckResult getResult(IModInfo mod) {
        return results.getOrDefault(mod, PENDING_CHECK);
    }

    public record CheckResult(Status status, ComparableVersion target, Map<ComparableVersion, String> changes, String url) {
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED(3, true),
        AHEAD,
        BETA,
        BETA_OUTDATED(6, true);

        final int sheetOffset;
        final boolean draw;
        final boolean animated;

        private Status() {
            this(0, false, false);
        }

        private Status(int sheetOffset) {
            this(sheetOffset, true, false);
        }

        private Status(int sheetOffset, boolean animated) {
            this(sheetOffset, true, animated);
        }

        private Status(int sheetOffset, boolean draw, boolean animated) {
            this.sheetOffset = sheetOffset;
            this.draw = draw;
            this.animated = animated;
        }

        public int getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean shouldDraw() {
            return this.draw;
        }

        public boolean isAnimated() {
            return this.animated;
        }
    }
}

