/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.google.common.base.Throwables;
import com.mohistmc.MohistMC;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.api.color.ColorsAPI;
import com.mohistmc.commands.BackupWorldCommand;
import com.mohistmc.commands.BansCommand;
import com.mohistmc.commands.DumpCommand;
import com.mohistmc.commands.EntityCommand;
import com.mohistmc.commands.ItemsCommand;
import com.mohistmc.commands.MohistCommand;
import com.mohistmc.commands.PermissionCommand;
import com.mohistmc.commands.PingCommand;
import com.mohistmc.commands.PluginCommand;
import com.mohistmc.commands.ShowsCommand;
import com.mohistmc.plugins.warps.WarpsCommands;
import com.mohistmc.plugins.world.commands.WorldsCommands;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class MohistConfig {
    private static final List<String> HEADER = Arrays.asList("This is the main configuration file for Mohist.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\nFor a reference for any variable inside this file, check out the Mohist wiki at\nhttps://wiki.mohistmc.com/\n\nIf you need help with the configuration or have any questions related to Spigot,\njoin us at the Discord or drop by our forums and leave a post.\n\nDiscord: https://discord.gg/mohistmc\nForums: https://mohistmc.com/\nForums (CN): https://mohistmc.cn/\n\n".split("\\n"));
    public static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static File CONFIG_FILE;
    public static File mohistyml;
    public static YamlConfiguration yml;
    public static boolean show_logo;
    public static String mohist_lang;
    public static boolean check_update;
    public static int maximumRepairCost;
    public static boolean enchantment_fix;
    public static int max_enchantment_level;
    public static boolean modlist_check_blacklist_enable;
    public static List<String> modlist_check_blacklist;
    public static String modlist_check_blacklist_message;
    public static boolean modlist_check_whitelist_enable;
    public static String modlist_check_whitelist;
    public static String modlist_check_whitelist_message;
    public static int maxBees;
    public static boolean bookAnimationTick;
    public static boolean networkmanager_enable;
    public static boolean networkmanager_debug;
    public static List<String> networkmanager_intercept;
    public static boolean keepinventory_global;
    public static boolean keepinventory_inventory;
    public static boolean keepinventory_exp;
    public static int server_thread;
    public static boolean clear_item;
    public static List<String> clear_item__whitelist;
    public static String clear_item__msg;
    public static int clear_item__time;
    public static boolean ban_item_enable;
    public static List<String> ban_item_materials;
    public static boolean ban_entity_enable;
    public static List<String> ban_entity_types;
    public static boolean ban_enchantment_enable;
    public static List<String> ban_enchantment_list;
    public static String motdFirstLine;
    public static String motdSecondLine;
    public static String pingCommandOutput;
    public static boolean doFireTick;
    public static boolean worldmanage;
    public static boolean bukkitpermissionshandler;
    public static String serverbranding;
    public static boolean velocity_enabled;
    public static boolean velocity_onlineMode;
    public static String velocity_secret;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load mohist.yml, please correct your syntax errors", ex);
            Throwables.throwIfUnchecked((Throwable)ex);
        }
        config.options().setHeader((List)HEADER);
        config.options().copyDefaults(true);
        commands = new HashMap<String, Command>();
        commands.put("mohist", new MohistCommand("mohist"));
        commands.put("dump", new DumpCommand("dump"));
        commands.put("plugin", new PluginCommand("plugin"));
        commands.put("backupworld", new BackupWorldCommand("backupworld"));
        commands.put("items", new ItemsCommand("items"));
        commands.put("permission", new PermissionCommand("permission"));
        commands.put("bans", new BansCommand("bans"));
        commands.put("shows", new ShowsCommand("shows"));
        commands.put("ping", new PingCommand("ping"));
        commands.put("entity", new EntityCommand("entity"));
        if (MohistConfig.getBoolean("commands.worlds", true)) {
            commands.put("worlds", new WorldsCommands("worlds"));
        }
        if (MohistConfig.getBoolean("commands.warps", true)) {
            commands.put("warps", new WarpsCommands("warps"));
        }
        version = MohistConfig.getInt("config-version", 1);
        MohistConfig.set("config-version", 1);
        MohistConfig.set("keepinventory.world.inventory", false);
        MohistConfig.set("keepinventory.world.exp", false);
        MohistConfig.readConfig();
        try {
            Class.forName("org.sqlite.JDBC");
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (Throwable t) {
            throw new RuntimeException("Error initializing Mohist", t);
        }
    }

    public static void save() {
        MohistConfig.readConfig();
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.getServer().server.getCommandMap().register(entry.getKey(), "Mohist", entry.getValue());
        }
    }

    static void readConfig() {
        for (Method method : MohistConfig.class.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwables.throwIfUnchecked((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + String.valueOf(method), ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + String.valueOf(CONFIG_FILE), ex);
        }
    }

    public static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, def);
        return config.getDouble(path, config.getDouble(path));
    }

    public static String mohist_lang() {
        return yml.getString("mohist.lang", Locale.getDefault().toString());
    }

    public static String networkmanager_enable() {
        return yml.getString("networkmanager.enable", Locale.getDefault().toString());
    }

    private static void mohist() {
        show_logo = MohistConfig.getBoolean("mohist.show_logo", true);
        mohist_lang = MohistConfig.getString("mohist.lang", Locale.getDefault().toString());
        check_update = MohistConfig.getBoolean("mohist.check_update", true);
        maximumRepairCost = MohistConfig.getInt("anvilfix.maximumrepaircost", 40);
        enchantment_fix = MohistConfig.getBoolean("anvilfix.enchantment_fix", false);
        max_enchantment_level = MohistConfig.getInt("anvilfix.max_enchantment_level", Short.MAX_VALUE);
        modlist_check_blacklist_enable = MohistConfig.getBoolean("modlist_check.blacklist.enable", false);
        modlist_check_blacklist = MohistConfig.getList("modlist_check.blacklist.list", new ArrayList());
        modlist_check_blacklist_message = MohistConfig.getString("modlist_check.blacklist.message", "Connection closed - PlayerModsCheck blacklist");
        modlist_check_whitelist_enable = MohistConfig.getBoolean("modlist_check.whitelist.enable", false);
        modlist_check_whitelist = MohistConfig.getString("modlist_check.whitelist.list", ServerAPI.modlists_All.toString().replace(", mohist", ""));
        modlist_check_whitelist_message = MohistConfig.getString("modlist_check.whitelist.message", "Connection closed - PlayerModsCheck whitelist");
        maxBees = MohistConfig.getInt("max-bees-in-hive", 3);
        bookAnimationTick = MohistConfig.getBoolean("enchantment-table-book-animation-tick", false);
        networkmanager_debug = MohistConfig.getBoolean("networkmanager.enable", false);
        networkmanager_debug = MohistConfig.getBoolean("networkmanager.debug", false);
        networkmanager_intercept = MohistConfig.getList("networkmanager.intercept", new ArrayList());
        keepinventory_global = MohistConfig.getBoolean("keepinventory.global.enable", false);
        keepinventory_inventory = MohistConfig.getBoolean("keepinventory.global.inventory", true);
        keepinventory_exp = MohistConfig.getBoolean("keepinventory.global.exp", true);
        server_thread = MohistConfig.getInt("threadpriority.server_thread", 8);
        clear_item = MohistConfig.getBoolean("entity.clear.item.enable", false);
        clear_item__whitelist = MohistConfig.getList("entity.clear.item.whitelist", new ArrayList());
        clear_item__msg = MohistConfig.getString("entity.clear.item.msg", "[Server] Cleaned up %size% drops");
        clear_item__time = MohistConfig.getInt("entity.clear.item.time", 1800);
        ban_item_enable = MohistConfig.getBoolean("ban.item.enable", false);
        ban_item_materials = MohistConfig.getList("ban.item.list", new ArrayList());
        ban_entity_enable = MohistConfig.getBoolean("ban.entity.enable", false);
        ban_entity_types = MohistConfig.getList("ban.entity.list", new ArrayList());
        ban_enchantment_enable = MohistConfig.getBoolean("ban.enchantment.enable", false);
        ban_enchantment_list = MohistConfig.getList("ban.enchantment.list", new ArrayList());
        motdFirstLine = ColorsAPI.of(MohistConfig.getString("motd.firstline", "<RAINBOW1>A Minecraft Server</RAINBOW>"));
        motdSecondLine = ColorsAPI.of(MohistConfig.getString("motd.secondline", ""));
        pingCommandOutput = MohistConfig.getString("settings.messages.ping-command-output", "\u00a72%s's ping is %sms");
        doFireTick = MohistConfig.getBoolean("events.fire_tick", false);
        bukkitpermissionshandler = MohistConfig.getBoolean("forge.bukkitpermissionshandler", true);
        worldmanage = MohistConfig.getBoolean("worldmanage", true);
        serverbranding = ColorsAPI.of(MohistConfig.getString("server_branding", MohistMC.modid));
        velocity_enabled = MohistConfig.getBoolean("velocity.enabled", false);
        velocity_onlineMode = MohistConfig.getBoolean("velocity.onlineMode", false);
        velocity_secret = MohistConfig.getString("velocity.secret", "");
    }

    static {
        mohistyml = new File("mohist-config", "mohist.yml");
        yml = YamlConfiguration.loadConfiguration(mohistyml);
    }
}

