/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api;

import com.mohistmc.forge.ForgeInjectBukkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.bukkit.craftbukkit.v1_20_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class EnchantmentAPI {
    public static boolean has(ItemStack itemStack) {
        return itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants();
    }

    public static boolean has(net.minecraft.world.item.ItemStack itemStack) {
        return EnchantmentAPI.has(CraftItemStack.asBukkitCopy(itemStack));
    }

    public static List<Enchantment> getNMS(ItemStack itemStack) {
        if (EnchantmentAPI.has(itemStack)) {
            Map<org.bukkit.enchantments.Enchantment, Integer> map = itemStack.getEnchantments();
            return map.keySet().stream().map(CraftEnchantment::getRaw).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<org.bukkit.enchantments.Enchantment> get(ItemStack itemStack) {
        if (EnchantmentAPI.has(itemStack)) {
            return new ArrayList<org.bukkit.enchantments.Enchantment>(itemStack.getEnchantments().keySet());
        }
        return Collections.emptyList();
    }

    public static String getNameByNMS(Enchantment nms) {
        return ForgeInjectBukkit.normalizeName(EnchantmentHelper.m_182432_((Enchantment)nms).toString());
    }
}

