/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api;

import com.mohistmc.MohistConfig;
import com.mohistmc.MohistMC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemAPI {
    public static final Logger LOGGER = LogManager.getLogger((String)"ItemAPI");

    public static ItemStack doItem(Material material, int menge, String name, List<String> lore) {
        ItemStack item = new ItemStack(material, menge);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static net.minecraft.world.item.ItemStack toNMSItem(Material material) {
        ItemStack itemStack = new ItemStack(material);
        return CraftItemStack.asNMSCopy(itemStack);
    }

    public static net.minecraft.world.item.ItemStack toNMSItem(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy(itemStack);
    }

    public static ItemStack getBukkit(Material material) {
        return new ItemStack(material);
    }

    public static CompoundTag getNbt(ItemStack itemStack) {
        return ItemAPI.toNMSItem(itemStack).m_41783_() == null ? null : ItemAPI.toNMSItem(itemStack).m_41783_();
    }

    public static String getNBTAsString(ItemStack itemStack) {
        return ItemAPI.toNMSItem(itemStack).m_41783_() == null ? "null" : ItemAPI.toNMSItem(itemStack).m_41783_().m_7916_();
    }

    public static String getNbtAsString(CompoundTag compoundTag) {
        return compoundTag == null ? "null" : compoundTag.m_7916_();
    }

    public static ItemStack getBukkitByBase64(String base64) {
        ItemStack itemStack;
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(base64)));
        try {
            itemStack = (ItemStack)dataInput.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error("Unable to decode class type.");
                return ItemAPI.getBukkit(Material.AIR);
            }
        }
        dataInput.close();
        return itemStack;
    }

    public static String getBase64byBukkit(ItemStack stack) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream(outputStream);
            dataOutput.writeObject(stack);
            dataOutput.close();
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String serializeNBT(ItemStack itemStack) {
        return ItemAPI.getNbt(itemStack) == null ? null : ItemAPI.serializeNbt(ItemAPI.getNbt(itemStack));
    }

    public static ItemStack deserializeNBT(String serializeNBT) {
        if (serializeNBT != null && !serializeNBT.isEmpty()) {
            return CraftItemStack.asBukkitCopy(new net.minecraft.world.item.ItemStack(ItemAPI.deserializeNbt(serializeNBT)));
        }
        return new ItemStack(Material.AIR);
    }

    public static String serializeNbt(CompoundTag nbtTagCompound) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)nbtTagCompound, (OutputStream)buf);
            return Base64.getEncoder().encodeToString(buf.toByteArray());
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static CompoundTag deserializeNbt(String serializeNBT) {
        if (serializeNBT != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(serializeNBT));
            try {
                return NbtIo.m_128939_((InputStream)buf);
            }
            catch (IOException e) {
                MohistMC.LOGGER.error("Reading nbt ", (Throwable)e);
            }
        }
        return null;
    }

    public static void name(ItemStack itemStack, String name) {
        ItemMeta im = itemStack.getItemMeta();
        im.setDisplayName(name.replace("&", "\u00a7"));
        itemStack.setItemMeta(im);
    }

    public static void lore(ItemStack itemStack, List<String> lore) {
        ItemMeta im = itemStack.getItemMeta();
        im.setLore(lore);
        itemStack.setItemMeta(im);
    }

    @Deprecated
    public static TextComponent show(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        CompoundTag compound = new CompoundTag();
        nmsItemStack.m_41739_(compound);
        String json = compound.toString();
        BaseComponent[] hoverEventComponents = new BaseComponent[]{new TextComponent(json)};
        TextComponent component = new TextComponent(itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : itemStack.getTranslationKey());
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, hoverEventComponents));
        return component;
    }

    public static boolean isBan(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return MohistConfig.ban_item_materials.contains(itemStack.getType().name());
    }

    public static Material getEggMaterial(EntityType entitytype) {
        try {
            if (entitytype == EntityType.PLAYER) {
                return Material.PLAYER_HEAD;
            }
            String getMaterial = String.valueOf(entitytype) + "_SPAWN_EGG";
            return Material.valueOf((String)(entitytype.toString().equals("MUSHROOM_COW") ? "MOOSHROOM_SPAWN_EGG" : getMaterial));
        }
        catch (Exception e) {
            try {
                return Material.valueOf(entitytype.getName().toUpperCase());
            }
            catch (Exception e1) {
                return Material.SPAWNER;
            }
        }
    }

    public static Material getMaterial(String type) {
        try {
            return Material.valueOf(type);
        }
        catch (Exception e) {
            return Material.AIR;
        }
    }

    public static Enchantment getEnchantmentByName(String name) {
        try {
            return Enchantment.getByName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Enchantment getEnchantmentByKey(String key) {
        try {
            return Enchantment.getByKey(NamespacedKey.fromString(key));
        }
        catch (Exception e) {
            return ItemAPI.getEnchantmentByName(key);
        }
    }
}

