/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api;

import com.mohistmc.plugins.world.WorldDate;
import com.mohistmc.plugins.world.utils.ConfigByWorlds;
import java.util.Locale;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;

public class WorldAPI {
    public static String getDate(World world, WorldDate worldDate) {
        if (ConfigByWorlds.config.getString("worlds." + world.getName() + "." + worldDate.name().toLowerCase(Locale.ENGLISH)) == null) {
            switch (worldDate) {
                case NAME: {
                    return world.getName();
                }
                case INFO: {
                    return "-/-";
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)worldDate));
        }
        return ConfigByWorlds.config.getString("worlds." + world.getName() + "." + worldDate.name().toLowerCase(Locale.ENGLISH));
    }

    public static class VoidGenerator
    extends ChunkGenerator {
        @Override
        public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biome) {
            ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    biome.setBiome(x + i, z + j, Biome.THE_VOID);
                }
            }
            for (int y = 0; y < world.getMaxHeight(); ++y) {
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        chunkData.setBlock(i, y, j, Material.AIR);
                    }
                }
            }
            return chunkData;
        }
    }
}

