/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.commands;

import com.mohistmc.MohistMC;
import com.mohistmc.api.ChatComponentAPI;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.tools.HasteUtils;
import com.mohistmc.util.I18n;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class DumpCommand
extends Command {
    private final List<String> tab_cmd = Arrays.asList("potions", "effect", "particle", "enchants", "cbcmds", "modscmds", "entitytypes", "biomes", "pattern", "worldgen", "worldtype", "material", "channels", "advancements", "plugins", "mods");
    private final List<String> tab_mode = Arrays.asList("file", "web");

    public DumpCommand(String name) {
        super(name);
        this.description = I18n.as("dumpcmd.description");
        this.usageMessage = "/dump <file|web> [potions|enchants|cbcmds|modscmds|entitytypes|biomes|pattern|worldgen|worldtype|material|channels|advancements|plugins|mods]";
        this.setPermission("mohist.command.dump");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (sender.isOp() || this.testPermission(sender)) {
            switch (args.length) {
                case 2: {
                    for (String param : this.tab_cmd) {
                        if (!param.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        list.add(param);
                    }
                    break;
                }
                case 1: {
                    for (String param : this.tab_mode) {
                        if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                        list.add(param);
                    }
                    break;
                }
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if (args.length == 2) {
            String mode = args[0];
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "potions": {
                    this.dumpPotions(sender, mode);
                    break;
                }
                case "effect": {
                    this.dumpEffect(sender, mode);
                    break;
                }
                case "particle": {
                    this.dumpParticle(sender, mode);
                    break;
                }
                case "enchants": {
                    this.dumpEnchant(sender, mode);
                    break;
                }
                case "cbcmds": {
                    this.dumpCBCommands(sender, mode);
                    break;
                }
                case "modscmds": {
                    this.dumpModsCommands(sender, mode);
                    break;
                }
                case "entitytypes": {
                    this.dumpEntityTypes(sender, mode);
                    break;
                }
                case "biomes": {
                    this.dumpBiomes(sender, mode);
                    break;
                }
                case "pattern": {
                    this.dumpPattern(sender, mode);
                    break;
                }
                case "worldtype": {
                    this.dumpWorldType(sender, mode);
                    break;
                }
                case "material": {
                    this.dumpMaterial(sender, mode);
                    break;
                }
                case "channels": {
                    this.dumpChannels(sender, mode);
                    break;
                }
                case "advancements": {
                    this.dumpAdvancements(sender, mode);
                    break;
                }
                case "plugins": {
                    this.dumpPlugins(sender, mode);
                    break;
                }
                case "mods": {
                    this.dumpMods(sender, mode);
                    break;
                }
                default: {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                    return false;
                }
            }
        }
        return false;
    }

    private void dumpEffect(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (PotionEffectType pet : PotionEffectType.values()) {
            sb.append(pet).append("\n");
        }
        this.dump(sender, "effect", sb, mode);
    }

    private void dumpPotions(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (PotionType pet : PotionType.values()) {
            if (pet == null) continue;
            sb.append(pet).append("\n");
        }
        this.dump(sender, "potions", sb, mode);
    }

    private void dumpParticle(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Particle pet : Particle.values()) {
            if (pet == null) continue;
            sb.append(pet).append("\n");
        }
        this.dump(sender, "particle", sb, mode);
    }

    private void dumpEnchant(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Enchantment ench : Enchantment.values()) {
            sb.append(ench).append("\n");
        }
        this.dump(sender, "enchants", sb, mode);
    }

    private void dumpEntityTypes(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (EntityType ent : EntityType.values()) {
            sb.append(ent.toString()).append("\n");
        }
        this.dump(sender, "entitytypes", sb, mode);
    }

    private void dumpCBCommands(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Command per : MinecraftServer.getServer().server.getCommandMap().getCommands()) {
            if (per.getPermission() == null) continue;
            sb.append(per.getName()).append(": ").append(per.getPermission()).append("\n");
        }
        this.dump(sender, "cbcommands", sb, mode);
    }

    private void dumpModsCommands(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> m : ServerAPI.forgecmdper.entrySet()) {
            sb.append(m.getKey()).append(": ").append(m.getValue()).append("\n");
        }
        this.dump(sender, "modscommands", sb, mode);
    }

    private void dumpBiomes(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Biome biome : Biome.values()) {
            sb.append(biome.toString()).append("\n");
        }
        this.dump(sender, "biomes", sb, mode);
    }

    private void dumpPattern(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (PatternType patternType : PatternType.values()) {
            String key = patternType.getIdentifier();
            sb.append(key).append("_").append((Object)PatternType.getByIdentifier(key)).append("\n");
        }
        this.dump(sender, "pattern", sb, mode);
    }

    private void dumpWorldType(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (WorldType type : WorldType.values()) {
            String key = type.getName();
            sb.append((Object)type).append("-").append(key).append("\n");
        }
        this.dump(sender, "worldtype", sb, mode);
    }

    private void dumpMaterial(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            String key = material.getKey().toString();
            sb.append(material).append("-").append(key).append("\n");
        }
        this.dump(sender, "material", sb, mode);
    }

    private void dumpChannels(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (String channel : ServerAPI.channels_Outgoing()) {
            sb.append(channel).append("\n");
        }
        for (String channel : ServerAPI.channels_Incoming()) {
            sb.append(channel).append("\n");
        }
        this.dump(sender, "channels", sb, mode);
    }

    private void dumpAdvancements(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (AdvancementHolder channel : ServerAPI.getNMSServer().m_129889_().m_136028_()) {
            sb.append(channel.f_291758_()).append("\n");
        }
        this.dump(sender, "advancements", sb, mode);
    }

    private void dumpPlugins(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Plugin p : Bukkit.getServer().getPluginManager().getPlugins()) {
            sb.append("%s - %s".formatted(p.getName(), p.getDescription().getVersion())).append("\n");
        }
        this.dump(sender, "plugins", sb, mode);
    }

    private void dumpMods(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (IModInfo modInfo : ModLoader.getModList().getMods()) {
            sb.append("%s - %s".formatted(modInfo.getModId(), modInfo.getVersion().toString())).append("\n");
        }
        this.dump(sender, "mods", sb, mode);
    }

    private void dumpmsg(CommandSender sender, String path, String type) {
        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Successfully dump " + type + ", output path: " + path);
    }

    private void dump(CommandSender sender, String type, StringBuilder sb, String mode) {
        switch (mode) {
            case "file": {
                this.saveToF(type, sb, sender);
                break;
            }
            case "web": {
                try {
                    String url = HasteUtils.pasteMohist((String)sb.toString());
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        ChatComponentAPI.sendClickOpenURLChat(p, String.valueOf((Object)ChatColor.GREEN) + "Successfully dump " + type + ", output path: " + String.valueOf((Object)ChatColor.DARK_GRAY) + url, url, url);
                        break;
                    }
                    this.dumpmsg(sender, url, type);
                    break;
                }
                catch (IOException e) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Failed to upload to hastebin.");
                    this.saveToF(type, sb, sender);
                }
            }
        }
    }

    private void saveToF(String type, StringBuilder sb, CommandSender sender) {
        File file = new File("dump", type + ".txt");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file.getAbsolutePath(), type);
    }

    protected void writeByteArrayToFile(File file, StringBuilder sb) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            MohistMC.LOGGER.error((Object)e);
        }
    }
}

