/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.commands;

import com.mohistmc.api.ChatComponentAPI;
import com.mohistmc.api.ItemAPI;
import com.mohistmc.api.PlayerAPI;
import com.mohistmc.api.gui.GUIItem;
import com.mohistmc.api.gui.Warehouse;
import com.mohistmc.plugins.item.ItemsConfig;
import com.mohistmc.util.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemsCommand
extends Command {
    private final List<String> params = Arrays.asList("info", "name", "save", "remove", "list", "get");

    public ItemsCommand(String name) {
        super(name);
        this.description = I18n.as("itemscmd.description");
        this.usageMessage = "/items [info|name|save|list|get|remove]";
        this.setPermission("mohist.command.items");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("error.notplayer"));
            return false;
        }
        final Player player = (Player)sender;
        if (args.length == 0) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "info": {
                if (itemStack == null || itemStack.getType().isAir()) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("itemscmd.mainhandEmpty"));
                    return false;
                }
                ItemsCommand.info(player);
                return true;
            }
            case "name": {
                if (itemStack == null || itemStack.getType().isAir()) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("itemscmd.mainhandEmpty"));
                    return false;
                }
                if (args.length != 2) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /items name <string>");
                    return false;
                }
                ItemAPI.name(player.getInventory().getItemInMainHand(), args[1]);
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Item name set complete.");
                return true;
            }
            case "save": {
                if (itemStack == null || itemStack.getType().isAir()) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("itemscmd.mainhandEmpty"));
                    return false;
                }
                if (args.length != 2) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /items save <name>");
                    return false;
                }
                ItemsConfig.yaml.set("items." + args[1], itemStack);
                ItemsConfig.save();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("itemscmd.completeSet"));
                return true;
            }
            case "lore": {
                if (itemStack == null || itemStack.getType().isAir()) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("itemscmd.mainhandEmpty"));
                    return false;
                }
                ItemAPI.lore(itemStack, List.of("\u00a74test \u00a72LO\u00a73RE"));
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("itemscmd.completeLore"));
                return true;
            }
            case "get": {
                if (args.length != 2) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /items get <name>");
                    return false;
                }
                if (player.getInventory().firstEmpty() == -1) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("itemscmd.inventoryFull"));
                    return false;
                }
                player.getInventory().addItem(ItemsConfig.get(args[1]));
                return true;
            }
            case "remove": {
                if (args.length != 2) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /items remove <name>");
                    return false;
                }
                ItemsConfig.remove(args[1]);
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("itemscmd.removedItemp1") + args[1] + String.valueOf((Object)ChatColor.GREEN) + I18n.as("itemscmd.removedItemp2"));
                return true;
            }
            case "list": {
                Warehouse wh = new Warehouse("Items");
                for (ItemStack s : ItemsConfig.getItems()) {
                    wh.addItem(new GUIItem(s){

                        @Override
                        public void ClickAction(ClickType type, Player u, ItemStack itemStack1) {
                            if (player.getInventory().firstEmpty() != -1) {
                                player.getInventory().addItem(itemStack1);
                            }
                        }
                    });
                }
                wh.openGUI(player);
                return true;
            }
        }
        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    public static void info(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy(itemStack);
        ChatComponentAPI.sendMessageByCopy(player, String.valueOf((Object)ChatColor.GRAY) + "Type - ", itemStack.getType().name());
        player.sendMessage(String.valueOf((Object)ChatColor.GRAY) + "Name - %s".formatted(nmsItem.m_41786_().getString()));
        player.sendMessage(String.valueOf((Object)ChatColor.GRAY) + "ForgeItem - %s".formatted(itemStack.getType().isForgeItem));
        player.sendMessage(String.valueOf((Object)ChatColor.GRAY) + "ForgeBlock - %s".formatted(itemStack.getType().isForgeBlock));
        ChatComponentAPI.sendMessageByCopy(player, String.valueOf((Object)ChatColor.GRAY) + "NBT(CraftBukkit) - ", ItemAPI.getNBTAsString(itemStack));
        ChatComponentAPI.sendMessageByCopy(player, String.valueOf((Object)ChatColor.GRAY) + "NBT(Vanilla) - ", ItemAPI.getNbtAsString(PlayerAPI.getNMSPlayer(player).m_21205_().m_41783_()));
        ChatComponentAPI.sendMessageByCopy(player, String.valueOf((Object)ChatColor.GRAY) + "NBT(Forge) - ", ItemAPI.getNbtAsString(nmsItem.getForgeCaps()));
    }
}

