/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.commands;

import com.mohistmc.MohistConfig;
import com.mohistmc.MohistMC;
import com.mohistmc.api.PlayerAPI;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.util.I18n;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MohistCommand
extends Command {
    private final List<String> params = Arrays.asList("mods", "playermods", "lang", "reload", "version", "channels_incom", "channels_outgo", "speed");

    public MohistCommand(String name) {
        super(name);
        this.description = "Mohist related commands";
        this.usageMessage = "/mohist [mods|playermods|lang|reload|version|channels_incom|channels_outgo]";
        this.setPermission("mohist.command.mohist");
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (sender.isOp() || this.testPermission(sender)) {
            if (args.length == 1) {
                for (String param : this.params) {
                    if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    list.add(param);
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("playermods")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "mods": {
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("mohistcmd.insidemods") + ServerAPI.modlists_Inside.size() + ") -> " + String.valueOf(ServerAPI.modlists_Inside));
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("mohistcmd.clientOnlymods") + ServerAPI.modlists_Client.size() + ") -> " + String.valueOf(ServerAPI.modlists_Client));
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("mohistcmd.serverOnlymods") + ServerAPI.modlists_Server.size() + ") -> " + String.valueOf(ServerAPI.modlists_Server));
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + I18n.as("mohistcmd.allMods") + ServerAPI.modlists_All.size() + ") -> " + String.valueOf(ServerAPI.modlists_All));
                break;
            }
            case "playermods": {
                if (args.length == 1) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /mohist playermods <playername>");
                    return false;
                }
                Player player = Bukkit.getPlayer(args[1]);
                if (player != null) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "%s %s".formatted(PlayerAPI.modsize(player), PlayerAPI.modlist(player)));
                    break;
                }
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("mohistcmd.playermods.playernotonline", args[1]));
                break;
            }
            case "reload": {
                Command.broadcastCommandMessage(sender, String.valueOf((Object)ChatColor.RED) + I18n.as("mohistcmd.reload.line1"));
                Command.broadcastCommandMessage(sender, String.valueOf((Object)ChatColor.RED) + I18n.as("mohistcmd.reload.line2"));
                MohistConfig.init((File)MinecraftServer.options.valueOf("mohist-settings"));
                ++MinecraftServer.getServer().server.reloadCount;
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "mohist-config/mohist.yml directory reload complete.");
                break;
            }
            case "version": {
                String[] cbs = CraftServer.class.getPackage().getImplementationVersion().split("-");
                sender.sendMessage("Mohist: " + MohistMC.versionInfo.mohist());
                sender.sendMessage("Forge: " + MohistMC.versionInfo.forge());
                sender.sendMessage("Bukkit: " + MohistMC.versionInfo.bukkit());
                sender.sendMessage("CraftBukkit: " + MohistMC.versionInfo.craftbukkit());
                sender.sendMessage("Spigot: " + MohistMC.versionInfo.spigot());
                break;
            }
            case "channels_incom": {
                sender.sendMessage(ServerAPI.channels_Incoming().toString());
                break;
            }
            case "channels_outgo": {
                sender.sendMessage(ServerAPI.channels_Outgoing().toString());
                break;
            }
            case "speed": {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    if (args.length != 2 || !p.isOp()) break;
                    if (this.isFloat(args[1])) {
                        if (p.isFlying()) {
                            float speed = Float.parseFloat(args[1]);
                            if (speed >= 0.0f && speed < 11.0f) {
                                p.setFlySpeed(speed / 10.0f);
                                p.sendMessage(I18n.as("mohistcmd.playerflightspeedSet") + speed);
                            }
                        } else {
                            float speed = Float.parseFloat(args[1]);
                            if (speed >= 0.0f && speed < 11.0f) {
                                p.setWalkSpeed(speed / 10.0f);
                                p.sendMessage(I18n.as("mohistcmd.playerwalkspeedset") + speed);
                            }
                        }
                    }
                    if (!args[0].equalsIgnoreCase("reset")) break;
                    p.setFlySpeed(0.1f);
                    p.setWalkSpeed(0.2f);
                    p.sendMessage(I18n.as("mohistcmd.flightAndWalkspeedRestore"));
                    break;
                }
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("error.notplayer"));
                break;
            }
            default: {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private boolean isFloat(String input) {
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

