/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.commands;

import com.mohistmc.MohistConfig;
import com.mohistmc.util.I18n;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PingCommand
extends Command {
    public PingCommand(String name) {
        super(name);
        this.setPermission("mohist.command.ping");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().startsWith(args[0])) continue;
                list.add(player.getName());
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                String output = String.format(MohistConfig.pingCommandOutput, player.getName(), player.getPing());
                sender.sendMessage(output);
                return true;
            }
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("error.notplayer"));
            return false;
        }
        if (args.length == 1) {
            Player player = Bukkit.getPlayer(args[0]);
            if (player != null) {
                String output = String.format(MohistConfig.pingCommandOutput, player.getName(), player.getPing());
                sender.sendMessage(output);
                return true;
            }
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + I18n.as("mohistcmd.playermods.playernotonline", args[1]));
            return false;
        }
        return false;
    }
}

