/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.commands;

import com.mohistmc.plugins.pluginmanager.PluginManagers;
import com.mohistmc.util.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PluginCommand
extends Command {
    private final List<String> params = Arrays.asList("load", "unload", "reload");

    public PluginCommand(String name) {
        super(name);
        this.description = I18n.as("plugincmd.description");
        this.usageMessage = "/plugin [load|unload|reload] [name]";
        this.setPermission("mohist.command.plugin");
    }

    private boolean checkparam(String args) {
        for (String param : this.params) {
            if (!args.equalsIgnoreCase(param)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "load": {
                PluginManagers.loadPluginCommand(sender, commandLabel, args);
                break;
            }
            case "unload": {
                PluginManagers.unloadPluginCommand(sender, commandLabel, args);
                break;
            }
            case "reload": {
                PluginManagers.reloadPluginCommand(sender, commandLabel, args);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                tabs.add(param);
            }
        }
        if (args.length == 2 && (sender.isOp() || this.testPermission(sender)) && this.checkparam(args[0])) {
            for (Plugin pl : Bukkit.getServer().getPluginManager().getPlugins()) {
                String plname = pl.getDescription().getName();
                if (!plname.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                tabs.add(plname);
            }
        }
        return tabs;
    }
}

