/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.mohistmc.MohistMC;
import com.mohistmc.forge.PluginClassLoaderFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.IEventListenerFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MohistEventBus {
    public static void register(EventBus bus, Object target) {
        ConcurrentHashMap listeners = bus.listeners;
        if (!listeners.containsKey(target)) {
            if (target.getClass() == Class.class) {
                MohistEventBus.registerClass((Class)target, bus);
            } else {
                MohistEventBus.registerObject(target, bus);
            }
        }
    }

    private static void registerClass(Class<?> clazz, EventBus bus) {
        Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.isAnnotationPresent(SubscribeEvent.class)).forEach(m -> MohistEventBus.registerListener(clazz, m, m, bus));
    }

    private static void registerObject(Object obj, EventBus bus) {
        HashSet classes = new HashSet();
        bus.typesFor(obj.getClass(), classes);
        Arrays.stream(obj.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).forEach(m -> classes.stream().map(c -> bus.getDeclMethod(c, m)).filter(rm -> rm.isPresent() && ((Method)rm.get()).isAnnotationPresent(SubscribeEvent.class)).findFirst().ifPresent(rm -> MohistEventBus.registerListener(obj, m, (Method)rm.get(), bus)));
    }

    private static void registerListener(Object target, Method method, Method real, EventBus bus) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + String.valueOf(eventType));
        }
        MohistEventBus.register(eventType, target, real, bus);
    }

    private static void register(Class<?> eventType, Object target, Method method, EventBus bus) {
        try {
            ASMEventHandler asm = new ASMEventHandler((IEventListenerFactory)new PluginClassLoaderFactory(), target, method, IGenericEvent.class.isAssignableFrom(eventType));
            bus.addToListeners(target, eventType, (IEventListener)asm, asm.getPriority());
        }
        catch (Throwable e) {
            MohistMC.LOGGER.error("Error registering event handler: {} {}", eventType, (Object)method, (Object)e);
        }
    }
}

