/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.optimizations;

import com.mohistmc.optimizations.utils.ChunkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.chunk.ChunkAccess;

public class OptVillager {
    private boolean isLobotomized = false;
    private int notLobotomizedCount = 0;

    public static OptVillager getInstance() {
        return new OptVillager();
    }

    public boolean isLobotomized(Villager villager) {
        return !this.checkLobotomize(villager) || villager.f_19797_ % 20 == 0;
    }

    private boolean checkLobotomize(Villager villager) {
        if (villager.f_19797_ % (this.notLobotomizedCount > 3 ? 600 : 300) == 0) {
            boolean bl = this.isLobotomized = villager.m_20159_() || !this.canTravel(BlockPos.m_274561_((double)villager.m_20185_(), (double)(villager.m_20186_() + 0.0625), (double)villager.m_20189_()), villager);
            this.notLobotomizedCount = this.isLobotomized ? 0 : ++this.notLobotomizedCount;
        }
        return this.isLobotomized;
    }

    private boolean canTravel(BlockPos center, Villager villager) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)villager.m_9236_(), center);
        if (chunk == null) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = center.m_122032_();
        boolean canJump = !this.hasCollisionAt(chunk, (BlockPos)mutable.m_122175_(Direction.UP, 2));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.canTravelTo(mutable.m_122159_((Vec3i)center, direction), canJump, villager)) continue;
            return true;
        }
        return false;
    }

    private boolean canTravelTo(BlockPos.MutableBlockPos mutable, boolean canJump, Villager villager) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)villager.m_9236_(), (BlockPos)mutable);
        if (chunk == null) {
            return false;
        }
        Block bottom = chunk.m_8055_((BlockPos)mutable).m_60734_();
        if (bottom instanceof BedBlock) {
            return true;
        }
        if (this.hasCollisionAt(chunk, (BlockPos)mutable.m_122173_(Direction.UP))) {
            return false;
        }
        boolean isTallBlock = bottom instanceof FenceBlock || bottom instanceof FenceGateBlock || bottom instanceof WallBlock;
        return !bottom.f_60443_ || canJump && !isTallBlock && !this.hasCollisionAt(chunk, (BlockPos)mutable.m_122173_(Direction.UP));
    }

    private boolean hasCollisionAt(ChunkAccess chunk, BlockPos pos) {
        return chunk.m_8055_((BlockPos)pos).m_60734_().f_60443_;
    }
}

