/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.plugins;

import com.mohistmc.MohistConfig;
import com.mohistmc.api.PlayerAPI;
import com.mohistmc.api.event.PlayerModsCheckEvent;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;

public class PlayerModsCheck {
    private static final AtomicBoolean canLog = new AtomicBoolean(true);

    public static void init(GameProfile profile, String mods) {
        List<String> modlist = PlayerModsCheck.fixList(mods);
        PlayerAPI.modlist.put(profile.getId(), modlist);
        PlayerModsCheckEvent event = new PlayerModsCheckEvent(profile, modlist);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            throw new IllegalStateException(event.message());
        }
        ArrayList<String> whitelist_modlist_Map = new ArrayList<String>();
        ArrayList<String> blacklist_modlist_Map = new ArrayList<String>();
        if (MohistConfig.modlist_check_whitelist_enable) {
            for (String config : modlist) {
                if (PlayerModsCheck.server_modlist_whitelist().contains(config)) continue;
                whitelist_modlist_Map.add(config);
            }
            if (!whitelist_modlist_Map.isEmpty()) {
                canLog.set(false);
                throw new IllegalStateException(MohistConfig.modlist_check_whitelist_message.replace("%modlist%", ((Object)whitelist_modlist_Map).toString()));
            }
        }
        if (MohistConfig.modlist_check_blacklist_enable && MohistConfig.modlist_check_blacklist != null) {
            for (String config : MohistConfig.modlist_check_blacklist) {
                if (!modlist.contains(config)) continue;
                blacklist_modlist_Map.add(config);
            }
            if (!blacklist_modlist_Map.isEmpty()) {
                canLog.set(false);
                throw new IllegalStateException(MohistConfig.modlist_check_whitelist_message.replace("%modlist%", ((Object)blacklist_modlist_Map).toString()));
            }
        }
    }

    public static List<String> server_modlist_whitelist() {
        return PlayerModsCheck.fixList(MohistConfig.modlist_check_whitelist);
    }

    public static List<String> fixList(String string) {
        String s = string.replaceAll("\\[|null|]| +", "");
        return Pattern.compile("\\s*,\\s*").splitAsStream(s).collect(Collectors.toList());
    }
}

