/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.plugins.ban.bans;

import com.mohistmc.MohistConfig;
import com.mohistmc.api.EnchantmentAPI;
import com.mohistmc.plugins.ban.BanType;
import com.mohistmc.plugins.ban.BanUtils;
import com.mohistmc.tools.ListUtils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

public class BanEnchantment {
    public static boolean check(Enchantment enchantment) {
        return BanEnchantment.check(new CraftEnchantment(enchantment));
    }

    public static boolean check(org.bukkit.enchantments.Enchantment enchantment) {
        if (!MohistConfig.ban_enchantment_enable) {
            return false;
        }
        return MohistConfig.ban_enchantment_list.contains(enchantment.getName());
    }

    public static boolean check(ItemStack itemStack) {
        Iterator<org.bukkit.enchantments.Enchantment> iterator;
        if (!MohistConfig.ban_enchantment_enable) {
            return false;
        }
        if (EnchantmentAPI.has(itemStack) && (iterator = EnchantmentAPI.get(itemStack).iterator()).hasNext()) {
            org.bukkit.enchantments.Enchantment enchantment = iterator.next();
            return MohistConfig.ban_enchantment_list.contains(enchantment.getName());
        }
        return false;
    }

    public static boolean check(net.minecraft.world.item.ItemStack itemStack) {
        Iterator<org.bukkit.enchantments.Enchantment> iterator;
        if (!MohistConfig.ban_enchantment_enable) {
            return false;
        }
        if (EnchantmentAPI.has(itemStack) && (iterator = EnchantmentAPI.get(CraftItemStack.asBukkitCopy(itemStack)).iterator()).hasNext()) {
            org.bukkit.enchantments.Enchantment enchantment = iterator.next();
            return MohistConfig.ban_enchantment_list.contains(enchantment.getName());
        }
        return false;
    }

    public static void save(InventoryCloseEvent event) {
        if (event.getView().getTitle().equals("\u00a74Add bans enchantment")) {
            List<String> old = MohistConfig.ban_enchantment_list;
            for (ItemStack itemStack : event.getInventory().getContents()) {
                if (itemStack == null || itemStack.getType() == Material.AIR || !EnchantmentAPI.has(itemStack)) continue;
                for (org.bukkit.enchantments.Enchantment e : EnchantmentAPI.get(itemStack)) {
                    ListUtils.isDuplicate(old, (String)e.getKey().toString());
                }
            }
            BanUtils.saveToYaml(old, BanType.ENCHANTMENT);
        }
    }
}

