/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.plugins.pluginmanager;

import com.mohistmc.MohistMC;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.SimplePluginManager;

public class Control {
    public static PluginDescriptionFile getDescription(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry zip = jar.getEntry("plugin.yml");
            if (zip == null) {
                jar.close();
                return null;
            }
            PluginDescriptionFile pdf = new PluginDescriptionFile(jar.getInputStream(zip));
            jar.close();
            return pdf;
        }
        catch (IOException | InvalidDescriptionException ioe) {
            MohistMC.LOGGER.error((Object)ioe);
            return null;
        }
    }

    public static Plugin loadPlugin(File plugin) {
        try {
            Plugin p = Bukkit.getPluginManager().loadPlugin(plugin);
            p.onLoad();
            return p;
        }
        catch (Exception e) {
            MohistMC.LOGGER.error((Object)e);
            return null;
        }
    }

    public static boolean unloadPlugin(Plugin plugin) {
        SimplePluginManager manager = (SimplePluginManager)Bukkit.getServer().getPluginManager();
        List plugins = (List)ObfuscationReflectionHelper.getPrivateValue(SimplePluginManager.class, (Object)manager, (String)"plugins");
        Map lookupNames = (Map)ObfuscationReflectionHelper.getPrivateValue(SimplePluginManager.class, (Object)manager, (String)"lookupNames");
        SimpleCommandMap commandMap = (SimpleCommandMap)ObfuscationReflectionHelper.getPrivateValue(SimplePluginManager.class, (Object)manager, (String)"commandMap");
        Map knownCommands = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleCommandMap.class, (Object)commandMap, (String)"knownCommands");
        for (Plugin plugin1 : manager.getPlugins()) {
            if (!plugin1.equals(plugin)) continue;
            manager.disablePlugin(plugin);
            plugins.remove(plugin);
            lookupNames.remove(plugin.getDescription().getName());
            Iterator it = knownCommands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand command;
                Map.Entry entry = it.next();
                Object v = entry.getValue();
                if (!(v instanceof PluginCommand) || (command = (PluginCommand)v).getPlugin() != plugin) continue;
                command.unregister(commandMap);
                it.remove();
            }
            return true;
        }
        return false;
    }
}

