/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.plugins.pluginmanager;

import com.mohistmc.plugins.pluginmanager.Control;
import com.mohistmc.util.I18n;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginManagers {
    public static String permission = "mohist.command.plugin";

    public static boolean loadPluginCommand(CommandSender sender, String label, String[] split) {
        PluginDescriptionFile desc;
        String pluginName;
        if (split.length < 2) {
            sender.sendMessage(I18n.as("pluginscommand.load", label));
            return false;
        }
        String jarName = pluginName + ((pluginName = split[1]).endsWith(".jar") ? "" : ".jar");
        File toLoad = new File("plugins" + File.separator + jarName);
        if (!toLoad.exists()) {
            jarName = pluginName + (pluginName.endsWith(".jar") ? ".unloaded" : ".jar.unloaded");
            toLoad = new File("plugins" + File.separator + jarName);
            if (!toLoad.exists()) {
                sender.sendMessage(I18n.as("pluginscommand.nofile", pluginName));
                return false;
            }
            String fileName = jarName.substring(0, jarName.length() - ".unloaded".length());
            toLoad = new File("plugins" + File.separator + fileName);
            File unloaded = new File("plugins" + File.separator + jarName);
            unloaded.renameTo(toLoad);
        }
        if ((desc = Control.getDescription(toLoad)) == null) {
            sender.sendMessage(I18n.as("pluginscommand.noyml", pluginName));
            return false;
        }
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            if (!desc.getName().equals(p.getName())) continue;
            sender.sendMessage(I18n.as("pluginscommand.alreadyloaded", desc.getName()));
            return true;
        }
        Plugin p = Control.loadPlugin(toLoad);
        if (p == null) {
            sender.sendMessage(I18n.as("pluginscommand.notload", pluginName));
            return false;
        }
        Bukkit.getServer().getPluginManager().enablePlugin(p);
        sender.sendMessage(I18n.as("pluginscommand.loaded", p.getDescription().getName(), p.getDescription().getVersion()));
        return true;
    }

    public static boolean unloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (split.length < 2) {
            sender.sendMessage(I18n.as("pluginscommand.unload", label));
            return true;
        }
        String pluginName = split[1];
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        if (p == null) {
            sender.sendMessage(I18n.as("pluginscommand.noplugin", pluginName));
            return false;
        }
        if (!Control.unloadPlugin(p)) {
            sender.sendMessage(I18n.as("pluginscommand.notunload", pluginName));
            return false;
        }
        sender.sendMessage(I18n.as("pluginscommand.unloaded", p.getDescription().getName(), p.getDescription().getVersion()));
        return true;
    }

    public static boolean reloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (split.length < 2) {
            sender.sendMessage(I18n.as("pluginscommand.reload", label));
            return false;
        }
        String pluginName = split[1];
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        if (p == null) {
            sender.sendMessage(I18n.as("pluginscommand.noplugin", pluginName));
            return false;
        }
        File file = ((JavaPlugin)p).getFile();
        if (file == null) {
            sender.sendMessage(I18n.as("pluginscommand.nojar", p.getName()));
            return false;
        }
        File name = new File("plugins" + File.separator + file.getName());
        JavaPlugin loaded = null;
        if (!Control.unloadPlugin(p)) {
            sender.sendMessage(I18n.as("pluginscommand.unloaderror", pluginName));
            return false;
        }
        loaded = (JavaPlugin)Control.loadPlugin(name);
        if (loaded == null) {
            sender.sendMessage(I18n.as("pluginscommand.nojar", pluginName));
            return false;
        }
        Bukkit.getPluginManager().enablePlugin(loaded);
        sender.sendMessage(I18n.as("pluginscommand.reloaded", pluginName, loaded.getDescription().getVersion()));
        return true;
    }
}

