/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ConditionalRecipe {
    private static Codec<Recipe<?>> CODEC = new Codec<Recipe<?>>(){

        public <T> DataResult<T> encode(Recipe<?> input, DynamicOps<T> ops, T prefix) {
            throw new UnsupportedOperationException("ConditionRecipe.CODEC does not support encoding");
        }

        public <T> DataResult<Pair<Recipe<?>, T>> decode(DynamicOps<T> ops, T input) {
            ICondition.IContext context = ConditionCodec.getContext(ops);
            JsonElement json = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            try {
                JsonArray recipes = GsonHelper.m_13933_((JsonObject)GsonHelper.m_13918_((JsonElement)json.getAsJsonObject(), (String)"root"), (String)"recipes");
                int idx = 0;
                for (JsonElement entry : recipes) {
                    JsonObject object = GsonHelper.m_13918_((JsonElement)entry, (String)("recipe[" + idx++ + "]"));
                    JsonObject conditionjson = GsonHelper.m_13930_((JsonObject)object, (String)"forge:condition");
                    ICondition condition = (ICondition)Util.m_260975_((DataResult)ICondition.SAFE_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)conditionjson), JsonSyntaxException::new);
                    if (!condition.test(context)) continue;
                    ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
                    RecipeSerializer<?> serializer = ForgeRegistries.RECIPE_SERIALIZERS.getValue(type);
                    if (serializer == null) {
                        return DataResult.error(() -> "Invalid or unsupported recipe type '" + String.valueOf(type) + "' Conditions were successful, but unknown type");
                    }
                    DataResult parsed = serializer.m_292673_().parse((DynamicOps)JsonOps.INSTANCE, (Object)object);
                    if (parsed.error().isPresent()) {
                        return DataResult.error(() -> ((DataResult.PartialResult)((DataResult.PartialResult)parsed.error().get())).message());
                    }
                    if (!parsed.result().isPresent()) {
                        return DataResult.error(() -> "Recipe passed all conditions but did not parse a valid return");
                    }
                    return DataResult.success((Object)Pair.of((Object)((Recipe)parsed.result().get()), (Object)ops.empty()));
                }
                return DataResult.error(() -> "No recipe passed conditions, if this is the case, you should have an outer condition.");
            }
            catch (JsonSyntaxException e) {
                return DataResult.error(() -> e.getMessage());
            }
        }
    }.stable();
    public static final RecipeSerializer<Recipe<?>> SERIALZIER = new RecipeSerializer<Recipe<?>>(){

        public Codec<Recipe<?>> m_292673_() {
            return CODEC;
        }

        public Recipe<?> m_8005_(FriendlyByteBuf buffer) {
            throw new UnsupportedOperationException("ConditionaRecipe.SERIALIZER does not support decoding from network");
        }

        public void m_6178_(FriendlyByteBuf buffer, Recipe<?> recipe) {
            throw new UnsupportedOperationException("ConditionaRecipe.SERIALIZER does not support encoding to network");
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<RecipePair> recipes = new ArrayList<RecipePair>();
        private RecipeOutput bouncer = new RecipeOutput(){

            public void m_292927_(FinishedRecipe value) {
                this.recipe(value);
            }

            public Advancement.Builder m_293552_() {
                return Advancement.Builder.m_285878_().m_138396_(RecipeBuilder.f_236353_);
            }
        };
        @Nullable
        private ICondition condition;
        @Nullable
        private ICondition mainCondition;
        @Nullable
        private ResourceLocation advancementId;

        public Builder mainCondition(ICondition value) {
            if (this.mainCondition != null) {
                throw new IllegalStateException("Attempted to overrride the main condition, only one is allowed to be set");
            }
            this.mainCondition = value;
            return this;
        }

        public Builder condition(ICondition value) {
            if (this.condition != null) {
                throw new IllegalStateException("Attempted to override a previous set condition before adding a recipe");
            }
            this.condition = value;
            return this;
        }

        public Builder recipe(Consumer<RecipeOutput> callable) {
            callable.accept(this.bouncer);
            return this;
        }

        public Builder recipe(FinishedRecipe recipe) {
            if (this.condition == null) {
                throw new IllegalStateException("Can not add a recipe with no conditions.");
            }
            this.recipes.add(new RecipePair(this.condition, recipe));
            this.condition = null;
            return this;
        }

        public Builder advancement(ResourceLocation id) {
            this.advancementId = id;
            return this;
        }

        public void save(RecipeOutput out, String namespace, String path) {
            this.save(out, new ResourceLocation(namespace, path));
        }

        public void save(RecipeOutput out, ResourceLocation id) {
            if (this.condition != null) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.recipes.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipes");
            }
            ConditionalAdvancement.Builder adv = ConditionalAdvancement.builder();
            boolean hasAdvancement = false;
            for (RecipePair pair : this.recipes) {
                if (pair.recipe().m_126373_() == null) continue;
                adv.condition(pair.condition()).advancement(pair.recipe().m_126373_());
                hasAdvancement = true;
            }
            if (this.advancementId == null) {
                this.advancementId = id.m_246208_("recipes/");
            }
            out.m_292927_((FinishedRecipe)new Finished(id, this.mainCondition, this.recipes, this.advancementId, hasAdvancement ? adv.write() : null));
        }
    }

    private record RecipePair(ICondition condition, FinishedRecipe recipe) {
    }

    private static final class Finished
    extends Record
    implements FinishedRecipe {
        private final ResourceLocation id;
        @Nullable
        private final ICondition mainCondition;
        private final List<RecipePair> recipes;
        private final ResourceLocation advId;
        private final JsonObject advData;

        private Finished(ResourceLocation id, @Nullable ICondition mainCondition, List<RecipePair> recipes, ResourceLocation advId, JsonObject advData) {
            this.id = id;
            this.mainCondition = mainCondition;
            this.recipes = recipes;
            this.advId = advId;
            this.advData = advData;
        }

        public void m_7917_(JsonObject json) {
            JsonArray array = new JsonArray();
            ICondition main = this.mainCondition;
            if (main == null && this.recipes.size() == 1) {
                main = this.recipes.get(0).condition();
            }
            ForgeHooks.writeCondition(main, json);
            json.add("recipes", (JsonElement)array);
            for (RecipePair pair : this.recipes) {
                JsonObject holder = pair.recipe().m_125966_();
                if (holder.has("forge:condition")) {
                    throw new IllegalStateException("Recipe already serialized conditions!");
                }
                ForgeHooks.writeCondition(pair.condition(), holder);
                array.add((JsonElement)holder);
            }
        }

        public ResourceLocation m_126168_() {
            return this.id;
        }

        public RecipeSerializer<?> m_126169_() {
            return SERIALZIER;
        }

        @Nullable
        public AdvancementHolder m_126373_() {
            return null;
        }

        @Nullable
        public FinishedRecipe.AdvancementData advancementData() {
            return this.advData == null ? null : new FinishedRecipe.AdvancementData(this.advId, this.advData);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Finished.class, "id;mainCondition;recipes;advId;advData", "id", "mainCondition", "recipes", "advId", "advData"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Finished.class, "id;mainCondition;recipes;advId;advData", "id", "mainCondition", "recipes", "advId", "advData"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Finished.class, "id;mainCondition;recipes;advId;advData", "id", "mainCondition", "recipes", "advId", "advData"}, this, o);
        }

        @Nullable
        public ICondition mainCondition() {
            return this.mainCondition;
        }

        public List<RecipePair> recipes() {
            return this.recipes;
        }

        public ResourceLocation advId() {
            return this.advId;
        }

        public JsonObject advData() {
            return this.advData;
        }
    }
}

