/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2;

import com.google.common.base.Preconditions;
import com.mohistmc.forge.ForgeInjectBukkit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.joml.Vector3f;

public abstract class CraftParticle<D>
implements Keyed {
    private static final Registry<CraftParticle<?>> CRAFT_PARTICLE_REGISTRY = new CraftParticleRegistry(CraftRegistry.getMinecraftRegistry(Registries.f_256890_));
    private final NamespacedKey key;
    private final ParticleType<?> particle;
    private final Class<D> clazz;

    public static Particle minecraftToBukkit(ParticleType<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.f_256890_);
        NamespacedKey key = CraftNamespacedKey.fromMinecraft(((ResourceKey)registry.m_7854_(minecraft).orElseThrow()).m_135782_());
        Particle bukkit = Registry.PARTICLE_TYPE.get(key);
        if (bukkit == null) {
            bukkit = ForgeInjectBukkit.particleMap.get(key);
        }
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static ParticleType<?> bukkitToMinecraft(Particle bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (ParticleType)CraftRegistry.getMinecraftRegistry(Registries.f_256890_).m_6612_(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static <D> ParticleOptions createParticleParam(Particle particle, D data) {
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0);
        CraftParticle<?> craftParticle = CRAFT_PARTICLE_REGISTRY.get(particle.getKey());
        Preconditions.checkArgument((craftParticle != null ? 1 : 0) != 0);
        return craftParticle.createParticleParam(data);
    }

    public static <T> T convertLegacy(T object) {
        if (object instanceof MaterialData) {
            MaterialData mat = (MaterialData)object;
            return (T)CraftBlockData.fromData(CraftMagicNumbers.getBlock(mat));
        }
        return object;
    }

    public static Particle convertLegacy(Particle particle) {
        return switch (particle) {
            case Particle.LEGACY_BLOCK_DUST -> Particle.BLOCK_DUST;
            case Particle.LEGACY_FALLING_DUST -> Particle.FALLING_DUST;
            case Particle.LEGACY_BLOCK_CRACK -> Particle.BLOCK_CRACK;
            default -> particle;
        };
    }

    public CraftParticle(NamespacedKey key, ParticleType<?> particle, Class<D> clazz) {
        this.key = key;
        this.particle = particle;
        this.clazz = clazz;
    }

    public ParticleType<?> getHandle() {
        return this.particle;
    }

    public abstract ParticleOptions createParticleParam(D var1);

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    public static class CraftParticleRegistry
    extends CraftRegistry<CraftParticle<?>, ParticleType<?>> {
        private static final Map<NamespacedKey, BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>>> PARTICLE_MAP = new HashMap();
        private static final BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> VOID_FUNCTION = (name, particle) -> new CraftParticle<Void>(name, particle, Void.class){

            @Override
            public ParticleOptions createParticleParam(Void data) {
                return (SimpleParticleType)this.getHandle();
            }
        };

        private static void add(String name, BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> function) {
            PARTICLE_MAP.put(NamespacedKey.fromString(name), function);
        }

        public CraftParticleRegistry(net.minecraft.core.Registry<ParticleType<?>> minecraftRegistry) {
            super(CraftParticle.class, minecraftRegistry, null);
        }

        @Override
        public CraftParticle<?> createBukkit(NamespacedKey namespacedKey, ParticleType<?> particle) {
            if (particle == null) {
                return null;
            }
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> function = PARTICLE_MAP.getOrDefault(namespacedKey, VOID_FUNCTION);
            return function.apply(namespacedKey, particle);
        }

        static {
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> dustOptionsFunction = (name, particle) -> new CraftParticle<Particle.DustOptions>(name, particle, Particle.DustOptions.class){

                @Override
                public ParticleOptions createParticleParam(Particle.DustOptions data) {
                    Color color = data.getColor();
                    return new DustParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), data.getSize());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> itemStackFunction = (name, particle) -> new CraftParticle<ItemStack>(name, particle, ItemStack.class){

                @Override
                public ParticleOptions createParticleParam(ItemStack data) {
                    return new ItemParticleOption(this.getHandle(), CraftItemStack.asNMSCopy(data));
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> blockDataFunction = (name, particle) -> new CraftParticle<BlockData>(name, particle, BlockData.class){

                @Override
                public ParticleOptions createParticleParam(BlockData data) {
                    return new BlockParticleOption(this.getHandle(), ((CraftBlockData)data).getState());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> dustTransitionFunction = (name, particle) -> new CraftParticle<Particle.DustTransition>(name, particle, Particle.DustTransition.class){

                @Override
                public ParticleOptions createParticleParam(Particle.DustTransition data) {
                    Color from = data.getColor();
                    Color to = data.getToColor();
                    return new DustColorTransitionOptions(new Vector3f((float)from.getRed() / 255.0f, (float)from.getGreen() / 255.0f, (float)from.getBlue() / 255.0f), new Vector3f((float)to.getRed() / 255.0f, (float)to.getGreen() / 255.0f, (float)to.getBlue() / 255.0f), data.getSize());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> vibrationFunction = (name, particle) -> new CraftParticle<Vibration>(name, particle, Vibration.class){

                @Override
                public ParticleOptions createParticleParam(Vibration data) {
                    BlockPositionSource source;
                    if (data.getDestination() instanceof Vibration.Destination.BlockDestination) {
                        Location destination = ((Vibration.Destination.BlockDestination)data.getDestination()).getLocation();
                        source = new BlockPositionSource(CraftLocation.toBlockPosition(destination));
                    } else if (data.getDestination() instanceof Vibration.Destination.EntityDestination) {
                        Entity destination = ((CraftEntity)((Vibration.Destination.EntityDestination)data.getDestination()).getEntity()).getHandle();
                        source = new EntityPositionSource(destination, destination.m_20192_());
                    } else {
                        throw new IllegalArgumentException("Unknown vibration destination " + String.valueOf(data.getDestination()));
                    }
                    return new VibrationParticleOption((PositionSource)source, data.getArrivalTime());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> floatFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public ParticleOptions createParticleParam(Float data) {
                    return new SculkChargeParticleOptions(data.floatValue());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> integerFunction = (name, particle) -> new CraftParticle<Integer>(name, particle, Integer.class){

                @Override
                public ParticleOptions createParticleParam(Integer data) {
                    return new ShriekParticleOption(data.intValue());
                }
            };
            CraftParticleRegistry.add("dust", dustOptionsFunction);
            CraftParticleRegistry.add("item", itemStackFunction);
            CraftParticleRegistry.add("block", blockDataFunction);
            CraftParticleRegistry.add("falling_dust", blockDataFunction);
            CraftParticleRegistry.add("dust_color_transition", dustTransitionFunction);
            CraftParticleRegistry.add("vibration", vibrationFunction);
            CraftParticleRegistry.add("sculk_charge", floatFunction);
            CraftParticleRegistry.add("shriek", integerFunction);
            CraftParticleRegistry.add("block_marker", blockDataFunction);
        }
    }
}

