/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements org.bukkit.entity.Frog {
    public CraftFrog(CraftServer server, Frog entity) {
        super(server, (Animal)entity);
    }

    public Frog getHandle() {
        return (Frog)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    @Override
    public Entity getTongueTarget() {
        return this.getHandle().m_218538_().map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
    }

    @Override
    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().m_218536_();
        } else {
            this.getHandle().m_218481_(((CraftEntity)target).getHandle());
        }
    }

    @Override
    public Frog.Variant getVariant() {
        return CraftVariant.minecraftToBukkit(this.getHandle().m_28554_());
    }

    @Override
    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().m_28464_(CraftVariant.bukkitToMinecraft(variant));
    }

    public static class CraftVariant {
        public static Frog.Variant minecraftToBukkit(FrogVariant minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.f_256732_);
            Frog.Variant bukkit = Registry.FROG_VARIANT.get(CraftNamespacedKey.fromMinecraft(((ResourceKey)registry.m_7854_((Object)minecraft).orElseThrow()).m_135782_()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static FrogVariant bukkitToMinecraft(Frog.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (FrogVariant)CraftRegistry.getMinecraftRegistry(Registries.f_256732_).m_6612_(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }
}

