/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftAnimals;
import org.bukkit.entity.Rabbit;

public class CraftRabbit
extends CraftAnimals
implements org.bukkit.entity.Rabbit {
    public CraftRabbit(CraftServer server, Rabbit entity) {
        super(server, (Animal)entity);
    }

    public Rabbit getHandle() {
        return (Rabbit)this.entity;
    }

    @Override
    public String toString() {
        return "CraftRabbit{RabbitType=" + String.valueOf((Object)this.getRabbitType()) + "}";
    }

    @Override
    public Rabbit.Type getRabbitType() {
        return Rabbit.Type.values()[this.getHandle().m_28554_().ordinal()];
    }

    @Override
    public void setRabbitType(Rabbit.Type type) {
        this.getHandle().m_28464_(Rabbit.Variant.values()[type.ordinal()]);
    }

    private static class CraftMagicMapping {
        private static final int[] types = new int[Rabbit.Type.values().length];
        private static final Rabbit.Type[] reverse = new Rabbit.Type[Rabbit.Type.values().length];

        private CraftMagicMapping() {
        }

        private static void set(Rabbit.Type type, int value) {
            CraftMagicMapping.types[type.ordinal()] = value;
            if (value < reverse.length) {
                CraftMagicMapping.reverse[value] = type;
            }
        }

        public static Rabbit.Type fromMagic(int magic) {
            if (magic >= 0 && magic < reverse.length) {
                return reverse[magic];
            }
            if (magic == 99) {
                return Rabbit.Type.THE_KILLER_BUNNY;
            }
            return null;
        }

        public static int toMagic(Rabbit.Type type) {
            return types[type.ordinal()];
        }

        static {
            CraftMagicMapping.set(Rabbit.Type.BROWN, 0);
            CraftMagicMapping.set(Rabbit.Type.WHITE, 1);
            CraftMagicMapping.set(Rabbit.Type.BLACK, 2);
            CraftMagicMapping.set(Rabbit.Type.BLACK_AND_WHITE, 3);
            CraftMagicMapping.set(Rabbit.Type.GOLD, 4);
            CraftMagicMapping.set(Rabbit.Type.SALT_AND_PEPPER, 5);
            CraftMagicMapping.set(Rabbit.Type.THE_KILLER_BUNNY, 99);
        }
    }
}

