/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.securemodules;

import cpw.mods.cl.ModularURLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.securemodules.SecureModuleReference;

public class SecureModuleClassLoader
extends SecureClassLoader {
    private static boolean DEBUG = Boolean.getBoolean("sm.debug");
    protected final Configuration configuration;
    private final List<ModuleLayer> parents;
    private final Map<String, ModuleReference> ourModules = new HashMap<String, ModuleReference>();
    private final Map<String, SecureModuleReference> ourModulesSecure = new HashMap<String, SecureModuleReference>();
    private final Map<String, ResolvedModule> packageToOurModules = new HashMap<String, ResolvedModule>();
    private final Map<String, ClassLoader> packageToParentLoader = new HashMap<String, ClassLoader>();
    private final Map<ModuleReference, ModuleReader> moduleReaders = new ConcurrentHashMap<ModuleReference, ModuleReader>();
    private final List<ClassLoader> allParentLoaders;
    private final Map<String, CodeSource> packageToCodeSource = new ConcurrentHashMap<String, CodeSource>();
    private final boolean useCachedSignersForUnsignedCode;
    protected ClassLoader fallbackClassLoader = ClassLoader.getPlatformClassLoader();
    private List<ClassLoader> child = new ArrayList<ClassLoader>();
    private static ModuleReader NOOP_READER;
    private static final Certificate[] EMPTY_CERTS;

    private static void log(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    private static void setupModularURLHandler() {
        ModularURLHandler handler = ModularURLHandler.INSTANCE;
        URL.setURLStreamHandlerFactory(handler);
        handler.findProviders(SecureModuleClassLoader.class.getModule().getLayer());
    }

    public void addChild(ClassLoader child) {
        this.child.add(child);
    }

    public SecureModuleClassLoader(String name, Configuration config, List<ModuleLayer> parentLayers) {
        this(name, config, parentLayers, null);
    }

    public SecureModuleClassLoader(String name, Configuration config, List<ModuleLayer> parentLayers, ClassLoader parent) {
        this(name, config, parentLayers, parent, false);
    }

    public SecureModuleClassLoader(String name, Configuration config, List<ModuleLayer> parentLayers, ClassLoader parent, boolean useCachedSignersForUnsignedCode) {
        super(name, parent);
        if (parent != null) {
            this.fallbackClassLoader = null;
        }
        this.configuration = config;
        this.useCachedSignersForUnsignedCode = useCachedSignersForUnsignedCode;
        this.parents = Stream.concat(parentLayers.stream(), List.of(ModuleLayer.boot()).stream()).distinct().toList();
        this.allParentLoaders = this.parents.stream().flatMap(p -> p.modules().stream()).map(Module::getClassLoader).filter(cl -> cl != null).distinct().collect(Collectors.toCollection(ArrayList::new));
        ArrayList<ClassLoader> overlaping = new ArrayList<ClassLoader>();
        for (ClassLoader loader : this.allParentLoaders) {
            do {
                if ((loader = loader.getParent()) == null || !this.allParentLoaders.contains(loader)) continue;
                overlaping.add(loader);
            } while (loader != null);
        }
        this.allParentLoaders.removeAll(overlaping);
        for (ResolvedModule module : config.modules()) {
            ModuleReference ref = module.reference();
            this.ourModules.put(ref.descriptor().name(), ref);
            for (String string : ref.descriptor().packages()) {
                this.packageToOurModules.put(string, module);
            }
            ModuleReference moduleReference = ref;
            if (moduleReference instanceof SecureModuleReference) {
                SecureModuleReference smr = (SecureModuleReference)moduleReference;
                this.ourModulesSecure.put(smr.descriptor().name(), smr);
                continue;
            }
            SecureModuleClassLoader.log("[SecureModuleClassLoader] Insecure module: " + module);
        }
        if (DEBUG) {
            SecureModuleClassLoader.log("New ModuleClassLoader(" + name + ", @" + config.hashCode() + "[" + config + "])");
            for (ModuleLayer p2 : this.parents) {
                SecureModuleClassLoader.log("  Parent @" + p2.hashCode() + "[" + p2.configuration() + "]");
            }
        }
        for (ResolvedModule module : config.modules()) {
            for (ResolvedModule other : module.reads()) {
                ModuleDescriptor descriptor;
                ClassLoader cl2;
                if (other.configuration() == this.configuration) continue;
                ModuleLayer moduleLayer = this.parents.stream().filter(p -> p.configuration() == other.configuration()).findFirst().orElse(null);
                if (moduleLayer == null) {
                    throw new IllegalStateException("Could not find parent layer for module `" + other.name() + "` read by `" + module.name() + "`");
                }
                ClassLoader classLoader = cl2 = moduleLayer == null ? null : moduleLayer.findLoader(other.name());
                if (cl2 == null) {
                    cl2 = ClassLoader.getPlatformClassLoader();
                }
                if ((descriptor = other.reference().descriptor()).isAutomatic()) {
                    for (String pkg : descriptor.packages()) {
                        this.setLoader(pkg, cl2);
                    }
                    continue;
                }
                for (ModuleDescriptor.Exports export : descriptor.exports()) {
                    if (!export.isQualified()) {
                        this.setLoader(export.source(), cl2);
                        continue;
                    }
                    if (config != other.configuration() || export.targets().contains(module.name())) continue;
                    this.setLoader(export.source(), cl2);
                }
            }
        }
    }

    protected byte[] getClassBytes(ModuleReader reader, ModuleReference ref, String name) throws IOException {
        Optional<InputStream> read = reader.open(this.classToResource(name));
        if (!read.isPresent()) {
            return new byte[0];
        }
        try (InputStream is = read.get();){
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    protected byte[] maybeTransformClassBytes(byte[] bytes, String name, String context) {
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getMaybeTransformedClassBytes(String name, String context) throws ClassNotFoundException {
        IOException suppressed;
        byte[] bytes;
        block16: {
            Objects.requireNonNull(name);
            bytes = new byte[]{};
            suppressed = null;
            try {
                String pkg = SecureModuleClassLoader.classToPackage(name);
                ResolvedModule module = this.packageToOurModules.get(pkg);
                if (module != null) {
                    ModuleReference ref = module.reference();
                    try (ModuleReader reader = ref.open();){
                        byte[] byArray = this.getClassBytes(reader, ref, name);
                        return byArray;
                    }
                }
                ClassLoader parent = this.packageToParentLoader.get(pkg);
                if (parent == null) break block16;
                try (InputStream is = parent.getResourceAsStream(this.classToResource(name));){
                    if (is != null) {
                        bytes = is.readAllBytes();
                    }
                }
            }
            catch (IOException e) {
                suppressed = e;
            }
        }
        byte[] maybeTransformedBytes = this.maybeTransformClassBytes(bytes, name, context);
        if (maybeTransformedBytes.length != 0) return maybeTransformedBytes;
        ClassNotFoundException e = new ClassNotFoundException(name);
        if (suppressed == null) throw e;
        e.addSuppressed(suppressed);
        throw e;
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        for (ClassLoader parent : this.allParentLoaders) {
            url = parent.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        Objects.requireNonNull(name);
        String pkg = SecureModuleClassLoader.pathToPackage(name);
        ResolvedModule module = this.packageToOurModules.get(pkg);
        if (module != null) {
            try {
                URL url = this.findResource(module.name(), name);
                if (url != null && SecureModuleClassLoader.isOpenResource(name, url, module, pkg)) {
                    return url;
                }
            }
            catch (IOException iOException) {}
        } else {
            for (String moduleName : this.ourModules.keySet()) {
                try {
                    URL url = this.findResource(moduleName, name);
                    if (url == null) continue;
                    return url;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        ModuleReference module;
        Objects.requireNonNull(name);
        ModuleReference moduleReference = module = moduleName == null ? null : this.ourModules.get(moduleName);
        if (module == null) {
            return null;
        }
        ModuleReader reader = this.getModuleReader(module);
        Optional<URI> uri = reader.find(name);
        if (uri.isPresent()) {
            return uri.get().toURL();
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<Enumeration<URL>> results = new ArrayList<Enumeration<URL>>();
        results.add(this.findResources(name));
        for (ClassLoader parent : this.allParentLoaders) {
            results.add(parent.getResources(name));
        }
        return new Enumeration<URL>(){
            private Enumeration<Enumeration<URL>> itr;
            private Enumeration<URL> current;
            {
                this.itr = Collections.enumeration(results);
                this.current = this.itr.hasMoreElements() ? this.itr.nextElement() : null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.current != null && this.current.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                URL ret = this.current.nextElement();
                if (!this.current.hasMoreElements()) {
                    this.current = this.itr.hasMoreElements() ? this.itr.nextElement() : null;
                }
                return ret;
            }
        };
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        List<Object> ret;
        String pkg = SecureModuleClassLoader.pathToPackage(name);
        ResolvedModule module = this.packageToOurModules.get(pkg);
        if (module != null) {
            URL url = this.findResource(module.name(), name);
            ret = url != null && SecureModuleClassLoader.isOpenResource(name, url, module, pkg) ? List.of(url) : List.of();
        } else {
            ret = new ArrayList();
            for (String moduleName : this.ourModules.keySet()) {
                try {
                    URL url = this.findResource(moduleName, name);
                    if (url == null) continue;
                    ret.add(url);
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.enumeration(ret);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block9: {
            String pkg = SecureModuleClassLoader.classToPackage(name);
            ResolvedModule module = this.packageToOurModules.get(pkg);
            if (module == null) {
                throw new ClassNotFoundException(name);
            }
            ModuleReference ref = module.reference();
            ModuleReader reader = ref.open();
            try {
                clazz = this.readerToClass(reader, ref, name);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
            reader.close();
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        Class<?> clazz;
        block9: {
            String pkg = SecureModuleClassLoader.classToPackage(name);
            ResolvedModule module = this.packageToOurModules.get(pkg);
            if (module == null || !module.name().equals(moduleName)) {
                return null;
            }
            ModuleReference ref = module.reference();
            ModuleReader reader = ref.open();
            try {
                clazz = this.readerToClass(reader, ref, name);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            reader.close();
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c;
            block12: {
                c = this.findLoadedClass(name);
                try {
                    Class<?> classe;
                    String pkg;
                    if (c == null && !(pkg = SecureModuleClassLoader.classToPackage(name)).isEmpty()) {
                        ResolvedModule module = this.packageToOurModules.get(pkg);
                        if (module != null) {
                            c = this.findClass(module.name(), name);
                        } else {
                            ClassLoader parent = this.packageToParentLoader.get(pkg);
                            if (parent == null) {
                                parent = this.fallbackClassLoader;
                            }
                            c = parent == null ? super.loadClass(name, false) : parent.loadClass(name);
                        }
                    }
                    if ((classe = this.getaClass(name, c)) != null) {
                        return classe;
                    }
                }
                catch (Throwable e) {
                    Class<?> classe = this.getaClass(name, c);
                    if (classe == null) break block12;
                    return classe;
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private Class<?> getaClass(String name, Class<?> c) {
        if (c == null && !this.child.isEmpty()) {
            for (ClassLoader child : this.child) {
                try {
                    Method find = child.getClass().getDeclaredMethod("findClass", String.class);
                    find.setAccessible(true);
                    Class classe = (Class)find.invoke((Object)child, name);
                    if (classe == null) continue;
                    return classe;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private Class<?> readerToClass(ModuleReader reader, ModuleReference ref, String name) {
        byte[] bytes;
        try {
            bytes = this.getClassBytes(reader, ref, name);
        }
        catch (IOException e) {
            return (Class)SecureModuleClassLoader.sneak(e);
        }
        bytes = this.maybeTransformClassBytes(bytes, name, null);
        if (bytes.length == 0) {
            return null;
        }
        SecureModuleReference data = this.ourModulesSecure.get(ref.descriptor().name());
        URL url = ref.location().map(SecureModuleClassLoader::toURL).orElse(null);
        this.tryDefinePackage(name, data, url);
        CodeSigner[] signers = data == null ? null : data.getCodeSigners(this.classToResource(name), bytes);
        return this.defineClass(name, bytes, 0, bytes.length, this.getCodeSource(name, url, signers));
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        return perms;
    }

    private String classToResource(String name) {
        return name.replace('.', '/') + ".class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Package tryDefinePackage(String name, SecureModuleReference secure, URL base) throws IllegalArgumentException {
        String pkg = SecureModuleClassLoader.classToPackage(name);
        Package ret = this.getDefinedPackage(pkg);
        if (ret == null) {
            SecureModuleClassLoader secureModuleClassLoader = this;
            synchronized (secureModuleClassLoader) {
                ret = this.getDefinedPackage(pkg);
                if (ret == null) {
                    String path = pkg.replace('.', '/').concat("/");
                    String specTitle = null;
                    String specVersion = null;
                    String specVendor = null;
                    String implTitle = null;
                    String implVersion = null;
                    String implVendor = null;
                    Object sealBase = null;
                    if (secure != null) {
                        Attributes main = secure.getMainAttributes();
                        Attributes trusted = secure.getTrustedAttributes(path);
                        specTitle = SecureModuleClassLoader.read(main, trusted, Attributes.Name.SPECIFICATION_TITLE);
                        specVersion = SecureModuleClassLoader.read(main, trusted, Attributes.Name.SPECIFICATION_VERSION);
                        specVendor = SecureModuleClassLoader.read(main, trusted, Attributes.Name.SPECIFICATION_VENDOR);
                        implTitle = SecureModuleClassLoader.read(main, trusted, Attributes.Name.IMPLEMENTATION_TITLE);
                        implVersion = SecureModuleClassLoader.read(main, trusted, Attributes.Name.IMPLEMENTATION_VERSION);
                        implVendor = SecureModuleClassLoader.read(main, trusted, Attributes.Name.IMPLEMENTATION_VENDOR);
                        if ("true".equals(SecureModuleClassLoader.read(main, trusted, Attributes.Name.SEALED))) {
                            sealBase = null;
                        }
                    }
                    ret = this.definePackage(pkg, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                }
            }
        }
        return ret;
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String read(Attributes main, Attributes trusted, Attributes.Name name) {
        if (trusted != null && trusted.containsKey(name)) {
            return trusted.getValue(name);
        }
        return main == null ? null : main.getValue(name);
    }

    private static <E extends Throwable, R> R sneak(Exception exception) throws E {
        throw exception;
    }

    private static String pathToPackage(String name) {
        int idx = name.lastIndexOf(47);
        if (idx == -1 || idx == name.length() - 1) {
            return "";
        }
        return name.substring(0, idx).replace('/', '.');
    }

    private static String classToPackage(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1 || idx == name.length() - 1) {
            return "";
        }
        return name.substring(0, idx);
    }

    private boolean setLoader(String pkg, ClassLoader loader) {
        ClassLoader existing = this.packageToParentLoader.putIfAbsent(pkg, loader);
        if (existing != null && existing != loader) {
            throw new IllegalStateException("Package " + pkg + " cannot be imported from multiple loaders");
        }
        return existing == null;
    }

    private static boolean isOpenResource(String name, URL url, ResolvedModule module, String pkg) {
        if (name.endsWith(".class") || url.toString().endsWith("/")) {
            return true;
        }
        ModuleDescriptor desc = module.reference().descriptor();
        if (desc.isOpen() || desc.isAutomatic()) {
            return true;
        }
        for (ModuleDescriptor.Opens opens : desc.opens()) {
            if (!opens.source().equals(pkg)) continue;
            return !opens.isQualified();
        }
        return false;
    }

    private ModuleReader getModuleReader(ModuleReference reference) {
        return this.moduleReaders.computeIfAbsent(reference, k -> {
            try {
                return reference.open();
            }
            catch (IOException e) {
                return NOOP_READER;
            }
        });
    }

    protected String classNameToModuleName(String name) {
        ResolvedModule module = this.packageToOurModules.get(SecureModuleClassLoader.classToPackage(name));
        return module == null ? null : module.name();
    }

    private CodeSource getCodeSource(String name, URL url, CodeSigner[] signers) {
        CodeSource clsCS = new CodeSource(url, signers);
        if (!this.useCachedSignersForUnsignedCode) {
            return clsCS;
        }
        CodeSource pkgCS = this.packageToCodeSource.computeIfAbsent(SecureModuleClassLoader.classToPackage(name), pkg -> clsCS);
        if (DEBUG && pkgCS != clsCS) {
            Certificate[] pCerts = SecureModuleClassLoader.or(pkgCS.getCertificates(), EMPTY_CERTS);
            Certificate[] cCerts = SecureModuleClassLoader.or(clsCS.getCertificates(), EMPTY_CERTS);
            if (pCerts.length == 0 && cCerts.length == 0) {
                return pkgCS;
            }
            boolean found = false;
            for (Certificate cert : cCerts) {
                found = false;
                for (Certificate pcert : pCerts) {
                    if (!cert.equals(pcert)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                SecureModuleClassLoader.log("Class " + name + " has extra certificate: " + SecureModuleClassLoader.getFingerprint(cert));
            }
            for (Certificate pcert : pCerts) {
                found = false;
                for (Certificate cert : cCerts) {
                    if (!pcert.equals(cert)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                SecureModuleClassLoader.log("Class " + name + " has missing certificate: " + SecureModuleClassLoader.getFingerprint(pcert));
            }
        }
        return pkgCS;
    }

    private static <R> R or(R left, R right) {
        return left != null ? left : right;
    }

    private static String getFingerprint(Certificate cert) {
        if (cert == null) {
            return "NULL";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(cert.getEncoded());
            byte[] digest = md.digest();
            StringBuilder ret = new StringBuilder(2 * digest.length);
            for (byte c : digest) {
                int h = c & 0xF;
                ret.append(h < 10 ? 48 + h : 65 + h);
                h = (c & 0xF0) >> 4;
                ret.append(h < 10 ? 48 + h : 65 + h);
            }
            return ret.toString();
        }
        catch (Exception e) {
            return "Exception: " + e.getMessage();
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
        SecureModuleClassLoader.setupModularURLHandler();
        NOOP_READER = new ModuleReader(){

            @Override
            public Optional<URI> find(String name) throws IOException {
                return Optional.empty();
            }

            @Override
            public Stream<String> list() throws IOException {
                return Stream.empty();
            }

            @Override
            public void close() throws IOException {
            }
        };
        EMPTY_CERTS = new Certificate[0];
    }
}

