/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.util.PngInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ExtendedServerListData;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerData {
    private static final Logger f_271489_ = LogUtils.getLogger();
    private static final int f_301624_ = 1024;
    public String f_105362_;
    public String f_105363_;
    public Component f_105364_;
    public Component f_105365_;
    @Nullable
    public ServerStatus.Players f_263840_;
    public long f_105366_;
    public int f_105367_ = SharedConstants.m_183709_().m_132495_();
    public Component f_105368_ = Component.m_237113_(SharedConstants.m_183709_().m_132493_());
    public boolean f_105369_;
    public List<Component> f_105370_ = Collections.emptyList();
    private ServerPackStatus f_105371_ = ServerPackStatus.PROMPT;
    @Nullable
    private byte[] f_271511_;
    private Type f_291831_;
    private boolean f_242950_;
    public ExtendedServerListData forgeData = null;

    public ServerData(String p_105375_, String p_105376_, Type p_297678_) {
        this.f_105362_ = p_105375_;
        this.f_105363_ = p_105376_;
        this.f_291831_ = p_297678_;
    }

    public CompoundTag m_105378_() {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("name", this.f_105362_);
        compoundtag.m_128359_("ip", this.f_105363_);
        if (this.f_271511_ != null) {
            compoundtag.m_128359_("icon", Base64.getEncoder().encodeToString(this.f_271511_));
        }
        if (this.f_105371_ == ServerPackStatus.ENABLED) {
            compoundtag.m_128379_("acceptTextures", true);
        } else if (this.f_105371_ == ServerPackStatus.DISABLED) {
            compoundtag.m_128379_("acceptTextures", false);
        }
        return compoundtag;
    }

    public ServerPackStatus m_105387_() {
        return this.f_105371_;
    }

    public void m_105379_(ServerPackStatus p_105380_) {
        this.f_105371_ = p_105380_;
    }

    public static ServerData m_105385_(CompoundTag p_105386_) {
        ServerData serverdata = new ServerData(p_105386_.m_128461_("name"), p_105386_.m_128461_("ip"), Type.OTHER);
        if (p_105386_.m_128425_("icon", 8)) {
            try {
                byte[] abyte = Base64.getDecoder().decode(p_105386_.m_128461_("icon"));
                serverdata.m_271813_(ServerData.m_301662_(abyte));
            }
            catch (IllegalArgumentException illegalargumentexception) {
                f_271489_.warn("Malformed base64 server icon", (Throwable)illegalargumentexception);
            }
        }
        if (p_105386_.m_128425_("acceptTextures", 1)) {
            if (p_105386_.m_128471_("acceptTextures")) {
                serverdata.m_105379_(ServerPackStatus.ENABLED);
            } else {
                serverdata.m_105379_(ServerPackStatus.DISABLED);
            }
        } else {
            serverdata.m_105379_(ServerPackStatus.PROMPT);
        }
        return serverdata;
    }

    @Nullable
    public byte[] m_271916_() {
        return this.f_271511_;
    }

    public void m_271813_(@Nullable byte[] p_272760_) {
        this.f_271511_ = p_272760_;
    }

    public boolean m_105389_() {
        return this.f_291831_ == Type.LAN;
    }

    public boolean m_295074_() {
        return this.f_291831_ == Type.REALM;
    }

    public void m_242965_(boolean p_242972_) {
        this.f_242950_ = p_242972_;
    }

    public boolean m_242962_() {
        return this.f_242950_;
    }

    public void m_233803_(ServerData p_233804_) {
        this.f_105363_ = p_233804_.f_105363_;
        this.f_105362_ = p_233804_.f_105362_;
        this.f_271511_ = p_233804_.f_271511_;
    }

    public void m_105381_(ServerData p_105382_) {
        this.m_233803_(p_105382_);
        this.m_105379_(p_105382_.m_105387_());
        this.f_291831_ = p_105382_.f_291831_;
        this.f_242950_ = p_105382_.f_242950_;
    }

    @Nullable
    public static byte[] m_301662_(@Nullable byte[] p_301776_) {
        if (p_301776_ != null) {
            try {
                PngInfo pnginfo = PngInfo.m_301661_((byte[])p_301776_);
                if (pnginfo.f_301620_() <= 1024 && pnginfo.f_301618_() <= 1024) {
                    return p_301776_;
                }
            }
            catch (IOException ioexception) {
                f_271489_.warn("Failed to decode server icon", (Throwable)ioexception);
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class ServerPackStatus
    extends Enum<ServerPackStatus> {
        public static final /* enum */ ServerPackStatus ENABLED = new ServerPackStatus("enabled");
        public static final /* enum */ ServerPackStatus DISABLED = new ServerPackStatus("disabled");
        public static final /* enum */ ServerPackStatus PROMPT = new ServerPackStatus("prompt");
        private final Component f_105393_;
        private static final /* synthetic */ ServerPackStatus[] $VALUES;

        public static ServerPackStatus[] values() {
            return (ServerPackStatus[])$VALUES.clone();
        }

        public static ServerPackStatus valueOf(String p_105402_) {
            return Enum.valueOf(ServerPackStatus.class, p_105402_);
        }

        private ServerPackStatus(String p_105399_) {
            this.f_105393_ = Component.m_237115_("addServer.resourcePack." + p_105399_);
        }

        public Component m_105400_() {
            return this.f_105393_;
        }

        private static /* synthetic */ ServerPackStatus[] m_171809_() {
            return new ServerPackStatus[]{ENABLED, DISABLED, PROMPT};
        }

        static {
            $VALUES = ServerPackStatus.m_171809_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LAN = new Type();
        public static final /* enum */ Type REALM = new Type();
        public static final /* enum */ Type OTHER = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_298782_) {
            return Enum.valueOf(Type.class, p_298782_);
        }

        private static /* synthetic */ Type[] m_295677_() {
            return new Type[]{LAN, REALM, OTHER};
        }

        static {
            $VALUES = Type.m_295677_();
        }
    }
}

