/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SectionRenderDispatcher {
    private static final Logger f_291440_ = LogUtils.getLogger();
    private static final int f_290396_ = 4;
    private static final int f_291537_ = 2;
    private final PriorityBlockingQueue<RenderSection.CompileTask> f_290449_ = Queues.newPriorityBlockingQueue();
    private final Queue<RenderSection.CompileTask> f_291696_ = Queues.newLinkedBlockingDeque();
    private int f_291840_ = 2;
    private final Queue<SectionBufferBuilderPack> f_290858_;
    private final Queue<Runnable> f_290841_ = Queues.newConcurrentLinkedQueue();
    private volatile int f_290603_;
    private volatile int f_291113_;
    final SectionBufferBuilderPack f_290794_;
    private final ProcessorMailbox<Runnable> f_290713_;
    private final Executor f_291206_;
    ClientLevel f_291400_;
    final LevelRenderer f_290611_;
    private Vec3 f_290602_ = Vec3.f_82478_;

    public SectionRenderDispatcher(ClientLevel p_299878_, LevelRenderer p_299032_, Executor p_298480_, boolean p_298587_, SectionBufferBuilderPack p_299187_) {
        this(p_299878_, p_299032_, p_298480_, p_298587_, p_299187_, -1);
    }

    public SectionRenderDispatcher(ClientLevel p_299878_, LevelRenderer p_299032_, Executor p_298480_, boolean p_298587_, SectionBufferBuilderPack p_299187_, int countRenderBuilders) {
        this.f_291400_ = p_299878_;
        this.f_290611_ = p_299032_;
        int i = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.m_110506_().stream().mapToInt(RenderType::m_110507_).sum() * 4) - 1);
        int j = Runtime.getRuntime().availableProcessors();
        int k = p_298587_ ? j : Math.min(j, 4);
        int l = countRenderBuilders < 0 ? Math.max(1, Math.min(k, i)) : countRenderBuilders;
        this.f_290794_ = p_299187_;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l);
        try {
            for (int i1 = 0; i1 < l; ++i1) {
                list.add(new SectionBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError outofmemoryerror) {
            f_291440_.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l);
            int j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.f_290858_ = Queues.newArrayDeque((Iterable)list);
        this.f_291113_ = this.f_290858_.size();
        this.f_291206_ = p_298480_;
        this.f_290713_ = ProcessorMailbox.m_18751_((Executor)p_298480_, (String)"Section Renderer");
        this.f_290713_.m_6937_(this::m_293371_);
    }

    public void m_293166_(ClientLevel p_298968_) {
        this.f_291400_ = p_298968_;
    }

    private void m_293371_() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (!this.f_290858_.isEmpty() && (sectionrenderdispatcher$rendersection$compiletask = this.m_293164_()) != null) {
            SectionBufferBuilderPack sectionbufferbuilderpack = this.f_290858_.poll();
            this.f_290603_ = this.f_290449_.size() + this.f_291696_.size();
            this.f_291113_ = this.f_290858_.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_(sectionrenderdispatcher$rendersection$compiletask.m_294775_(), () -> sectionrenderdispatcher$rendersection$compiletask.m_294443_(sectionbufferbuilderpack)), this.f_291206_).thenCompose(p_298155_ -> p_298155_)).whenComplete((p_299295_, p_297995_) -> {
                if (p_297995_ != null) {
                    Minecraft.m_91087_().m_231412_(CrashReport.m_127521_(p_297995_, "Batching sections"));
                } else {
                    this.f_290713_.m_6937_(() -> {
                        if (p_299295_ == SectionTaskResult.SUCCESSFUL) {
                            sectionbufferbuilderpack.m_294577_();
                        } else {
                            sectionbufferbuilderpack.m_293358_();
                        }
                        this.f_290858_.add(sectionbufferbuilderpack);
                        this.f_291113_ = this.f_290858_.size();
                        this.m_293371_();
                    });
                }
            });
        }
    }

    @Nullable
    private RenderSection.CompileTask m_293164_() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (this.f_291840_ <= 0 && (sectionrenderdispatcher$rendersection$compiletask = this.f_291696_.poll()) != null) {
            this.f_291840_ = 2;
            return sectionrenderdispatcher$rendersection$compiletask;
        }
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask1 = this.f_290449_.poll();
        if (sectionrenderdispatcher$rendersection$compiletask1 != null) {
            --this.f_291840_;
            return sectionrenderdispatcher$rendersection$compiletask1;
        }
        this.f_291840_ = 2;
        return this.f_291696_.poll();
    }

    public String m_292950_() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.f_290603_, this.f_290841_.size(), this.f_291113_);
    }

    public int m_293066_() {
        return this.f_290603_;
    }

    public int m_294057_() {
        return this.f_290841_.size();
    }

    public int m_293327_() {
        return this.f_291113_;
    }

    public void m_294870_(Vec3 p_297762_) {
        this.f_290602_ = p_297762_;
    }

    public Vec3 m_293014_() {
        return this.f_290602_;
    }

    public void m_295287_() {
        Runnable runnable;
        while ((runnable = this.f_290841_.poll()) != null) {
            runnable.run();
        }
    }

    public void m_295202_(RenderSection p_299640_, RenderRegionCache p_297835_) {
        p_299640_.m_295370_(p_297835_);
    }

    public void m_295714_() {
        this.m_295487_();
    }

    public void m_294204_(RenderSection.CompileTask p_297747_) {
        this.f_290713_.m_6937_(() -> {
            if (p_298819_.f_290632_) {
                this.f_290449_.offer(p_297747_);
            } else {
                this.f_291696_.offer(p_297747_);
            }
            this.f_290603_ = this.f_290449_.size() + this.f_291696_.size();
            this.m_293371_();
        });
    }

    public CompletableFuture<Void> m_292947_(BufferBuilder.RenderedBuffer p_299767_, VertexBuffer p_298938_) {
        return CompletableFuture.runAsync(() -> {
            if (!p_298938_.m_231230_()) {
                p_298938_.m_85921_();
                p_298938_.m_231221_(p_299767_);
                VertexBuffer.m_85931_();
            }
        }, this.f_290841_::add);
    }

    private void m_295487_() {
        while (!this.f_290449_.isEmpty()) {
            RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask = this.f_290449_.poll();
            if (sectionrenderdispatcher$rendersection$compiletask == null) continue;
            sectionrenderdispatcher$rendersection$compiletask.m_292880_();
        }
        while (!this.f_291696_.isEmpty()) {
            RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask1 = this.f_291696_.poll();
            if (sectionrenderdispatcher$rendersection$compiletask1 == null) continue;
            sectionrenderdispatcher$rendersection$compiletask1.m_292880_();
        }
        this.f_290603_ = 0;
    }

    public boolean m_293214_() {
        return this.f_290603_ == 0 && this.f_290841_.isEmpty();
    }

    public void m_294449_() {
        this.m_295487_();
        this.f_290713_.close();
        this.f_290858_.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RenderSection {
        public static final int f_291071_ = 16;
        public final int f_290488_;
        public final AtomicReference<CompiledSection> f_290312_ = new AtomicReference<CompiledSection>(CompiledSection.f_290410_);
        final AtomicInteger f_291503_ = new AtomicInteger(0);
        @Nullable
        private RebuildTask f_291315_;
        @Nullable
        private ResortTransparencyTask f_291330_;
        private final Set<BlockEntity> f_291787_ = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> f_291754_ = RenderType.m_110506_().stream().collect(Collectors.toMap(p_298649_ -> p_298649_, p_299941_ -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
        private AABB f_290371_;
        private boolean f_291619_ = true;
        final BlockPos.MutableBlockPos f_291850_ = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] f_291827_ = Util.m_137469_(new BlockPos.MutableBlockPos[6], p_300613_ -> {
            for (int i = 0; i < ((BlockPos.MutableBlockPos[])p_300613_).length; ++i) {
                p_300613_[i] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean f_291709_;

        public RenderSection(int p_299358_, int p_299044_, int p_300810_, int p_299840_) {
            this.f_290488_ = p_299358_;
            this.m_292814_(p_299044_, p_300810_, p_299840_);
        }

        private boolean m_294104_(BlockPos p_297611_) {
            return SectionRenderDispatcher.this.f_291400_.m_6522_(SectionPos.m_123171_((int)p_297611_.m_123341_()), SectionPos.m_123171_((int)p_297611_.m_123343_()), ChunkStatus.f_62326_, false) != null;
        }

        public boolean m_294718_() {
            int i = 24;
            if (!(this.m_293828_() > 576.0)) {
                return true;
            }
            return this.m_294104_((BlockPos)this.f_291827_[Direction.WEST.ordinal()]) && this.m_294104_((BlockPos)this.f_291827_[Direction.NORTH.ordinal()]) && this.m_294104_((BlockPos)this.f_291827_[Direction.EAST.ordinal()]) && this.m_294104_((BlockPos)this.f_291827_[Direction.SOUTH.ordinal()]);
        }

        public AABB m_293301_() {
            return this.f_290371_;
        }

        public VertexBuffer m_294581_(RenderType p_298748_) {
            return this.f_291754_.get((Object)p_298748_);
        }

        public void m_292814_(int p_298099_, int p_299019_, int p_299020_) {
            this.m_293096_();
            this.f_291850_.m_122178_(p_298099_, p_299019_, p_299020_);
            this.f_290371_ = new AABB((double)p_298099_, (double)p_299019_, (double)p_299020_, (double)(p_298099_ + 16), (double)(p_299019_ + 16), (double)(p_299020_ + 16));
            for (Direction direction : Direction.values()) {
                this.f_291827_[direction.ordinal()].m_122190_((Vec3i)this.f_291850_).m_122175_(direction, 16);
            }
        }

        protected double m_293828_() {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            double d0 = this.f_290371_.f_82288_ + 8.0 - camera.m_90583_().f_82479_;
            double d1 = this.f_290371_.f_82289_ + 8.0 - camera.m_90583_().f_82480_;
            double d2 = this.f_290371_.f_82290_ + 8.0 - camera.m_90583_().f_82481_;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        void m_293308_(BufferBuilder p_300604_) {
            p_300604_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }

        public CompiledSection m_293175_() {
            return this.f_290312_.get();
        }

        private void m_293096_() {
            this.m_294642_();
            this.f_290312_.set(CompiledSection.f_290410_);
            this.f_291619_ = true;
        }

        public void m_294345_() {
            this.m_293096_();
            this.f_291754_.values().forEach(VertexBuffer::close);
        }

        public BlockPos m_295500_() {
            return this.f_291850_;
        }

        public void m_292780_(boolean p_298731_) {
            boolean flag = this.f_291619_;
            this.f_291619_ = true;
            this.f_291709_ = p_298731_ | (flag && this.f_291709_);
        }

        public void m_294599_() {
            this.f_291619_ = false;
            this.f_291709_ = false;
        }

        public boolean m_295586_() {
            return this.f_291619_;
        }

        public boolean m_295878_() {
            return this.f_291619_ && this.f_291709_;
        }

        public BlockPos m_292593_(Direction p_299060_) {
            return this.f_291827_[p_299060_.ordinal()];
        }

        public boolean m_294021_(RenderType p_301074_, SectionRenderDispatcher p_298196_) {
            CompiledSection sectionrenderdispatcher$compiledsection = this.m_293175_();
            if (this.f_291330_ != null) {
                this.f_291330_.m_292880_();
            }
            if (!sectionrenderdispatcher$compiledsection.f_290391_.contains((Object)p_301074_)) {
                return false;
            }
            this.f_291330_ = new ResortTransparencyTask(new ChunkPos(this.m_295500_()), this.m_293828_(), sectionrenderdispatcher$compiledsection);
            p_298196_.m_294204_(this.f_291330_);
            return true;
        }

        protected boolean m_294642_() {
            boolean flag = false;
            if (this.f_291315_ != null) {
                this.f_291315_.m_292880_();
                this.f_291315_ = null;
                flag = true;
            }
            if (this.f_291330_ != null) {
                this.f_291330_.m_292880_();
                this.f_291330_ = null;
            }
            return flag;
        }

        public CompileTask m_295128_(RenderRegionCache p_300037_) {
            boolean flag1;
            boolean flag = this.m_294642_();
            BlockPos blockpos = this.f_291850_.m_7949_();
            boolean i = true;
            RenderChunkRegion renderchunkregion = p_300037_.m_200465_((Level)SectionRenderDispatcher.this.f_291400_, blockpos.m_7918_(-1, -1, -1), blockpos.m_7918_(16, 16, 16), 1);
            boolean bl = flag1 = this.f_290312_.get() == CompiledSection.f_290410_;
            if (flag1 && flag) {
                this.f_291503_.incrementAndGet();
            }
            this.f_291315_ = new RebuildTask(new ChunkPos(this.m_295500_()), this.m_293828_(), renderchunkregion, !flag1 || this.f_291503_.get() > 2);
            return this.f_291315_;
        }

        public void m_294845_(SectionRenderDispatcher p_299090_, RenderRegionCache p_297331_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.m_295128_(p_297331_);
            p_299090_.m_294204_(sectionrenderdispatcher$rendersection$compiletask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void m_295492_(Collection<BlockEntity> p_300373_) {
            HashSet set1;
            HashSet set = Sets.newHashSet(p_300373_);
            Set<BlockEntity> set2 = this.f_291787_;
            synchronized (set2) {
                set1 = Sets.newHashSet(this.f_291787_);
                set.removeAll(this.f_291787_);
                set1.removeAll(p_300373_);
                this.f_291787_.clear();
                this.f_291787_.addAll(p_300373_);
            }
            SectionRenderDispatcher.this.f_290611_.m_109762_(set1, set);
        }

        public void m_295370_(RenderRegionCache p_298605_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.m_295128_(p_298605_);
            sectionrenderdispatcher$rendersection$compiletask.m_294443_(SectionRenderDispatcher.this.f_290794_);
        }

        public boolean m_292850_(int p_297900_, int p_299871_, int p_299328_) {
            BlockPos blockpos = this.m_295500_();
            return p_297900_ == SectionPos.m_123171_((int)blockpos.m_123341_()) || p_299328_ == SectionPos.m_123171_((int)blockpos.m_123343_()) || p_299871_ == SectionPos.m_123171_((int)blockpos.m_123342_());
        }

        @OnlyIn(value=Dist.CLIENT)
        class ResortTransparencyTask
        extends CompileTask {
            private final CompiledSection f_291899_;

            @Deprecated
            public ResortTransparencyTask(double p_300619_, CompiledSection p_297742_) {
                this(null, p_300619_, p_297742_);
            }

            public ResortTransparencyTask(ChunkPos pos, double p_300619_, CompiledSection p_297742_) {
                super(pos, p_300619_, true);
                this.f_291899_ = p_297742_;
            }

            @Override
            protected String m_294775_() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<SectionTaskResult> m_294443_(SectionBufferBuilderPack p_297366_) {
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.m_294718_()) {
                    this.f_291175_.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 vec3 = SectionRenderDispatcher.this.m_293014_();
                float f = (float)vec3.f_82479_;
                float f1 = (float)vec3.f_82480_;
                float f2 = (float)vec3.f_82481_;
                BufferBuilder.SortState bufferbuilder$sortstate = this.f_291899_.f_291674_;
                if (bufferbuilder$sortstate != null && !this.f_291899_.m_294492_(RenderType.m_110466_())) {
                    BufferBuilder bufferbuilder = p_297366_.m_294384_(RenderType.m_110466_());
                    RenderSection.this.m_293308_(bufferbuilder);
                    bufferbuilder.m_166775_(bufferbuilder$sortstate);
                    bufferbuilder.m_277127_(VertexSorting.m_277071_((float)(f - (float)RenderSection.this.f_291850_.m_123341_()), (float)(f1 - (float)RenderSection.this.f_291850_.m_123342_()), (float)(f2 - (float)RenderSection.this.f_291850_.m_123343_())));
                    this.f_291899_.f_291674_ = bufferbuilder.m_166770_();
                    BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = bufferbuilder.m_231175_();
                    if (this.f_291175_.get()) {
                        bufferbuilder$renderedbuffer.m_231200_();
                        return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = SectionRenderDispatcher.this.m_292947_(bufferbuilder$renderedbuffer, RenderSection.this.m_294581_(RenderType.m_110466_())).thenApply(p_297230_ -> SectionTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((p_301037_, p_300486_) -> {
                        if (p_300486_ != null && !(p_300486_ instanceof CancellationException) && !(p_300486_ instanceof InterruptedException)) {
                            Minecraft.m_91087_().m_231412_(CrashReport.m_127521_(p_300486_, "Rendering section"));
                        }
                        return this.f_291175_.get() ? SectionTaskResult.CANCELLED : SectionTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }

            @Override
            public void m_292880_() {
                this.f_291175_.set(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        abstract class CompileTask
        implements Comparable<CompileTask> {
            protected final double f_290350_;
            protected final AtomicBoolean f_291175_ = new AtomicBoolean(false);
            protected final boolean f_290632_;
            protected Map<BlockPos, ModelData> modelData;

            public CompileTask(double p_300617_, boolean p_299251_) {
                this(null, p_300617_, p_299251_);
            }

            public CompileTask(ChunkPos pos, double p_300617_, boolean p_299251_) {
                this.f_290350_ = p_300617_;
                this.f_290632_ = p_299251_;
                this.modelData = pos == null ? Collections.emptyMap() : Minecraft.m_91087_().f_91073_.getModelDataManager().getAt(pos);
            }

            public abstract CompletableFuture<SectionTaskResult> m_294443_(SectionBufferBuilderPack var1);

            public abstract void m_292880_();

            protected abstract String m_294775_();

            @Override
            public int compareTo(CompileTask p_298947_) {
                return Doubles.compare((double)this.f_290350_, (double)p_298947_.f_290350_);
            }

            public ModelData getModelData(BlockPos pos) {
                return this.modelData.getOrDefault(pos, ModelData.EMPTY);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class RebuildTask
        extends CompileTask {
            @Nullable
            protected RenderChunkRegion f_290484_;

            @Deprecated
            public RebuildTask(@Nullable double p_301300_, RenderChunkRegion p_300496_, boolean p_299891_) {
                this(null, p_301300_, p_300496_, p_299891_);
            }

            public RebuildTask(ChunkPos pos, @Nullable double p_301300_, RenderChunkRegion p_300496_, boolean p_299891_) {
                super(pos, p_301300_, p_299891_);
                this.f_290484_ = p_300496_;
            }

            @Override
            protected String m_294775_() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<SectionTaskResult> m_294443_(SectionBufferBuilderPack p_299595_) {
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.m_294718_()) {
                    this.f_290484_ = null;
                    RenderSection.this.m_292780_(false);
                    this.f_291175_.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 vec3 = SectionRenderDispatcher.this.m_293014_();
                float f = (float)vec3.f_82479_;
                float f1 = (float)vec3.f_82480_;
                float f2 = (float)vec3.f_82481_;
                CompileResults sectionrenderdispatcher$rendersection$rebuildtask$compileresults = this.m_293979_(f, f1, f2, p_299595_);
                RenderSection.this.m_295492_(sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291894_);
                if (this.f_291175_.get()) {
                    sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291255_.values().forEach(BufferBuilder.RenderedBuffer::m_231200_);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompiledSection sectionrenderdispatcher$compiledsection = new CompiledSection();
                sectionrenderdispatcher$compiledsection.f_290920_ = sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291589_;
                sectionrenderdispatcher$compiledsection.f_290409_.addAll(sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_290796_);
                sectionrenderdispatcher$compiledsection.f_291674_ = sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291842_;
                ArrayList list = Lists.newArrayList();
                sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291255_.forEach((p_301240_, p_299440_) -> {
                    list.add(SectionRenderDispatcher.this.m_292947_((BufferBuilder.RenderedBuffer)p_299440_, RenderSection.this.m_294581_((RenderType)((Object)p_301240_))));
                    p_297511_.f_290391_.add((RenderType)((Object)p_301240_));
                });
                return Util.m_143840_(list).handle((p_297447_, p_298622_) -> {
                    if (p_298622_ != null && !(p_298622_ instanceof CancellationException) && !(p_298622_ instanceof InterruptedException)) {
                        Minecraft.m_91087_().m_231412_(CrashReport.m_127521_(p_298622_, "Rendering section"));
                    }
                    if (this.f_291175_.get()) {
                        return SectionTaskResult.CANCELLED;
                    }
                    RenderSection.this.f_290312_.set(sectionrenderdispatcher$compiledsection);
                    RenderSection.this.f_291503_.set(0);
                    SectionRenderDispatcher.this.f_290611_.m_294499_(RenderSection.this);
                    return SectionTaskResult.SUCCESSFUL;
                });
            }

            private CompileResults m_293979_(float p_297372_, float p_300511_, float p_298415_, SectionBufferBuilderPack p_300020_) {
                CompileResults sectionrenderdispatcher$rendersection$rebuildtask$compileresults = new CompileResults();
                boolean i = true;
                BlockPos blockpos = RenderSection.this.f_291850_.m_7949_();
                BlockPos blockpos1 = blockpos.m_7918_(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                RenderChunkRegion renderchunkregion = this.f_290484_;
                this.f_290484_ = null;
                PoseStack posestack = new PoseStack();
                if (renderchunkregion != null) {
                    BufferBuilder bufferbuilder1;
                    ModelBlockRenderer.m_111000_();
                    ReferenceArraySet set = new ReferenceArraySet(RenderType.m_110506_().size());
                    RandomSource randomsource = RandomSource.m_216327_();
                    BlockRenderDispatcher blockrenderdispatcher = Minecraft.m_91087_().m_91289_();
                    for (BlockPos blockpos2 : BlockPos.m_121940_((BlockPos)blockpos, (BlockPos)blockpos1)) {
                        FluidState fluidstate;
                        BlockEntity blockentity;
                        BlockState blockstate = renderchunkregion.m_8055_(blockpos2);
                        if (blockstate.m_60804_(renderchunkregion, blockpos2)) {
                            visgraph.m_112971_(blockpos2);
                        }
                        if (blockstate.m_155947_() && (blockentity = renderchunkregion.m_7702_(blockpos2)) != null) {
                            this.m_293240_(sectionrenderdispatcher$rendersection$rebuildtask$compileresults, blockentity);
                        }
                        if (!(fluidstate = blockstate.m_60819_()).m_76178_()) {
                            RenderType rendertype = ItemBlockRenderTypes.m_109287_(fluidstate);
                            BufferBuilder bufferbuilder = p_300020_.m_294384_(rendertype);
                            if (set.add(rendertype)) {
                                RenderSection.this.m_293308_(bufferbuilder);
                            }
                            blockrenderdispatcher.m_234363_(blockpos2, renderchunkregion, (VertexConsumer)((Object)bufferbuilder), blockstate, fluidstate);
                        }
                        if (blockstate.m_60799_() == RenderShape.INVISIBLE) continue;
                        BakedModel model = blockrenderdispatcher.m_110910_(blockstate);
                        ModelData modelData = model.getModelData(renderchunkregion, blockpos2, blockstate, this.getModelData(blockpos2));
                        randomsource.m_188584_(blockstate.m_60726_(blockpos2));
                        for (RenderType rendertype2 : model.getRenderTypes(blockstate, randomsource, modelData)) {
                            BufferBuilder bufferbuilder2 = p_300020_.m_294384_(rendertype2);
                            if (set.add(rendertype2)) {
                                RenderSection.this.m_293308_(bufferbuilder2);
                            }
                            posestack.m_85836_();
                            posestack.m_252880_(blockpos2.m_123341_() & 0xF, blockpos2.m_123342_() & 0xF, blockpos2.m_123343_() & 0xF);
                            blockrenderdispatcher.renderBatched(blockstate, blockpos2, renderchunkregion, posestack, (VertexConsumer)((Object)bufferbuilder2), true, randomsource, modelData, rendertype2);
                            posestack.m_85849_();
                        }
                    }
                    if (set.contains((Object)RenderType.m_110466_()) && !(bufferbuilder1 = p_300020_.m_294384_(RenderType.m_110466_())).m_231164_()) {
                        bufferbuilder1.m_277127_(VertexSorting.m_277071_((float)(p_297372_ - (float)blockpos.m_123341_()), (float)(p_300511_ - (float)blockpos.m_123342_()), (float)(p_298415_ - (float)blockpos.m_123343_())));
                        sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291842_ = bufferbuilder1.m_166770_();
                    }
                    for (RenderType rendertype1 : set) {
                        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = p_300020_.m_294384_(rendertype1).m_231168_();
                        if (bufferbuilder$renderedbuffer == null) continue;
                        sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291255_.put(rendertype1, bufferbuilder$renderedbuffer);
                    }
                    ModelBlockRenderer.m_111077_();
                }
                sectionrenderdispatcher$rendersection$rebuildtask$compileresults.f_291589_ = visgraph.m_112958_();
                return sectionrenderdispatcher$rendersection$rebuildtask$compileresults;
            }

            private <E extends BlockEntity> void m_293240_(CompileResults p_297364_, E p_299361_) {
                BlockEntityRenderer blockentityrenderer = Minecraft.m_91087_().m_167982_().m_112265_(p_299361_);
                if (blockentityrenderer != null) {
                    if (blockentityrenderer.m_5932_(p_299361_)) {
                        p_297364_.f_291894_.add(p_299361_);
                    } else {
                        p_297364_.f_290796_.add(p_299361_);
                    }
                }
            }

            @Override
            public void m_292880_() {
                this.f_290484_ = null;
                if (this.f_291175_.compareAndSet(false, true)) {
                    RenderSection.this.m_292780_(false);
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            static final class CompileResults {
                public final List<BlockEntity> f_291894_ = new ArrayList<BlockEntity>();
                public final List<BlockEntity> f_290796_ = new ArrayList<BlockEntity>();
                public final Map<RenderType, BufferBuilder.RenderedBuffer> f_291255_ = new Reference2ObjectArrayMap();
                public VisibilitySet f_291589_ = new VisibilitySet();
                @Nullable
                public BufferBuilder.SortState f_291842_;

                CompileResults() {
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class SectionTaskResult
    extends Enum<SectionTaskResult> {
        public static final /* enum */ SectionTaskResult SUCCESSFUL = new SectionTaskResult();
        public static final /* enum */ SectionTaskResult CANCELLED = new SectionTaskResult();
        private static final /* synthetic */ SectionTaskResult[] $VALUES;

        public static SectionTaskResult[] values() {
            return (SectionTaskResult[])$VALUES.clone();
        }

        public static SectionTaskResult valueOf(String p_298276_) {
            return Enum.valueOf(SectionTaskResult.class, p_298276_);
        }

        private static /* synthetic */ SectionTaskResult[] m_294124_() {
            return new SectionTaskResult[]{SUCCESSFUL, CANCELLED};
        }

        static {
            $VALUES = SectionTaskResult.m_294124_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompiledSection {
        public static final CompiledSection f_290410_ = new CompiledSection(){

            @Override
            public boolean m_293115_(Direction p_301280_, Direction p_299155_) {
                return false;
            }
        };
        final Set<RenderType> f_290391_ = new ObjectArraySet(RenderType.m_110506_().size());
        final List<BlockEntity> f_290409_ = Lists.newArrayList();
        VisibilitySet f_290920_ = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState f_291674_;

        public boolean m_295467_() {
            return this.f_290391_.isEmpty();
        }

        public boolean m_294492_(RenderType p_300861_) {
            return !this.f_290391_.contains((Object)p_300861_);
        }

        public List<BlockEntity> m_293674_() {
            return this.f_290409_;
        }

        public boolean m_293115_(Direction p_301006_, Direction p_300193_) {
            return this.f_290920_.m_112983_(p_301006_, p_300193_);
        }
    }
}

