/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Stitcher<T extends Entry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<Holder<?>> f_118161_ = Comparator.comparing(p_118201_ -> -p_118201_.f_118204_).thenComparing(p_118199_ -> -p_118199_.f_118203_).thenComparing(p_247945_ -> p_247945_.f_244486_.m_246162_());
    private final int f_118162_;
    private final List<Holder<T>> f_118163_ = new ArrayList<Holder<T>>();
    private final List<Region<T>> f_118164_ = new ArrayList<Region<T>>();
    private int f_118165_;
    private int f_118166_;
    private final int f_118167_;
    private final int f_118168_;

    public Stitcher(int p_118171_, int p_118172_, int p_118173_) {
        this.f_118162_ = p_118173_;
        this.f_118167_ = p_118171_;
        this.f_118168_ = p_118172_;
    }

    public int m_118174_() {
        return this.f_118165_;
    }

    public int m_118187_() {
        return this.f_118166_;
    }

    public void m_246099_(T p_249253_) {
        Holder<T> holder = new Holder<T>(p_249253_, this.f_118162_);
        this.f_118163_.add(holder);
    }

    public void m_118193_() {
        ArrayList<Holder<Holder>> list = new ArrayList<Holder<Holder>>(this.f_118163_);
        list.sort(f_118161_);
        for (Holder holder : list) {
            if (this.m_118178_(holder)) continue;
            if (LOGGER.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to fit: ").append(holder.f_244486_().m_246162_());
                sb.append(" - size: ").append(holder.f_244486_.m_246492_()).append("x").append(holder.f_244486_.m_245330_());
                sb.append(" - Maybe try a lower resolution resourcepack?\n");
                list.forEach(h -> sb.append("\t").append(h).append("\n"));
                LOGGER.info(sb.toString());
            }
            throw new StitcherException(holder.f_244486_, (Collection)list.stream().map(p_247946_ -> p_247946_.f_244486_).collect(ImmutableList.toImmutableList()));
        }
    }

    public void m_118180_(SpriteLoader<T> p_118181_) {
        for (Region<T> region : this.f_118164_) {
            region.m_246763_(p_118181_);
        }
    }

    static int m_118188_(int p_118189_, int p_118190_) {
        return (p_118189_ >> p_118190_) + ((p_118189_ & (1 << p_118190_) - 1) == 0 ? 0 : 1) << p_118190_;
    }

    private boolean m_118178_(Holder<T> p_118179_) {
        for (Region<T> region : this.f_118164_) {
            if (!region.m_118221_(p_118179_)) continue;
            return true;
        }
        return this.m_118191_(p_118179_);
    }

    private boolean m_118191_(Holder<T> p_118192_) {
        Region<T> region;
        boolean flag;
        boolean flag4;
        boolean flag2;
        int i = Mth.m_14125_((int)this.f_118165_);
        int j = Mth.m_14125_((int)this.f_118166_);
        int k = Mth.m_14125_((int)(this.f_118165_ + p_118192_.f_118203_));
        int l = Mth.m_14125_((int)(this.f_118166_ + p_118192_.f_118204_));
        boolean flag1 = k <= this.f_118167_;
        boolean bl = flag2 = l <= this.f_118168_;
        if (!flag1 && !flag2) {
            return false;
        }
        boolean flag3 = flag1 && i != k;
        boolean bl2 = flag4 = flag2 && j != l;
        if (flag3 ^ flag4) {
            flag = !flag3 && flag1;
        } else {
            boolean bl3 = flag = flag1 && i <= j;
        }
        if (flag) {
            if (this.f_118166_ == 0) {
                this.f_118166_ = l;
            }
            region = new Region(this.f_118165_, 0, k - this.f_118165_, this.f_118166_);
            this.f_118165_ = k;
        } else {
            region = new Region<T>(0, this.f_118166_, this.f_118165_, l - this.f_118166_);
            this.f_118166_ = l;
        }
        region.m_118221_(p_118192_);
        this.f_118164_.add(region);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    record Holder<T extends Entry>(T f_244486_, int f_118203_, int f_118204_) {
        public Holder(T p_250261_, int p_250127_) {
            this(p_250261_, Stitcher.m_118188_(p_250261_.m_246492_(), p_250127_), Stitcher.m_118188_(p_250261_.m_245330_(), p_250127_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Holder.class, "entry;width;height", "f_244486_", "f_118203_", "f_118204_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Holder.class, "entry;width;height", "f_244486_", "f_118203_", "f_118204_"}, this);
        }

        @Override
        public final boolean equals(Object p_251865_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Holder.class, "entry;width;height", "f_244486_", "f_118203_", "f_118204_"}, this, p_251865_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Entry {
        public int m_246492_();

        public int m_245330_();

        public ResourceLocation m_246162_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Region<T extends Entry> {
        private final int f_118209_;
        private final int f_118210_;
        private final int f_118211_;
        private final int f_118212_;
        @Nullable
        private List<Region<T>> f_118213_;
        @Nullable
        private Holder<T> f_118214_;

        public Region(int p_118216_, int p_118217_, int p_118218_, int p_118219_) {
            this.f_118209_ = p_118216_;
            this.f_118210_ = p_118217_;
            this.f_118211_ = p_118218_;
            this.f_118212_ = p_118219_;
        }

        public int m_118225_() {
            return this.f_118209_;
        }

        public int m_118226_() {
            return this.f_118210_;
        }

        public boolean m_118221_(Holder<T> p_118222_) {
            if (this.f_118214_ != null) {
                return false;
            }
            int i = p_118222_.f_118203_;
            int j = p_118222_.f_118204_;
            if (i <= this.f_118211_ && j <= this.f_118212_) {
                if (i == this.f_118211_ && j == this.f_118212_) {
                    this.f_118214_ = p_118222_;
                    return true;
                }
                if (this.f_118213_ == null) {
                    this.f_118213_ = new ArrayList<Region<T>>(1);
                    this.f_118213_.add(new Region<T>(this.f_118209_, this.f_118210_, i, j));
                    int k = this.f_118211_ - i;
                    int l = this.f_118212_ - j;
                    if (l > 0 && k > 0) {
                        int j1;
                        int i1 = Math.max(this.f_118212_, k);
                        if (i1 >= (j1 = Math.max(this.f_118211_, l))) {
                            this.f_118213_.add(new Region<T>(this.f_118209_, this.f_118210_ + j, i, l));
                            this.f_118213_.add(new Region<T>(this.f_118209_ + i, this.f_118210_, k, this.f_118212_));
                        } else {
                            this.f_118213_.add(new Region<T>(this.f_118209_ + i, this.f_118210_, k, j));
                            this.f_118213_.add(new Region<T>(this.f_118209_, this.f_118210_ + j, this.f_118211_, l));
                        }
                    } else if (k == 0) {
                        this.f_118213_.add(new Region<T>(this.f_118209_, this.f_118210_ + j, i, l));
                    } else if (l == 0) {
                        this.f_118213_.add(new Region<T>(this.f_118209_ + i, this.f_118210_, k, j));
                    }
                }
                for (Region<T> region : this.f_118213_) {
                    if (!region.m_118221_(p_118222_)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void m_246763_(SpriteLoader<T> p_250195_) {
            if (this.f_118214_ != null) {
                p_250195_.m_118228_(this.f_118214_.f_244486_, this.m_118225_(), this.m_118226_());
            } else if (this.f_118213_ != null) {
                for (Region region : this.f_118213_) {
                    region.m_246763_(p_250195_);
                }
            }
        }

        public String toString() {
            return "Slot{originX=" + this.f_118209_ + ", originY=" + this.f_118210_ + ", width=" + this.f_118211_ + ", height=" + this.f_118212_ + ", texture=" + String.valueOf(this.f_118214_) + ", subSlots=" + String.valueOf(this.f_118213_) + "}";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface SpriteLoader<T extends Entry> {
        public void m_118228_(T var1, int var2, int var3);
    }
}

