/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DefaultDispenseItemBehavior
implements DispenseItemBehavior {
    private boolean dropper = true;

    public DefaultDispenseItemBehavior() {
        this(true);
    }

    public DefaultDispenseItemBehavior(boolean dropper) {
        this.dropper = dropper;
    }

    @Override
    public final net.minecraft.world.item.ItemStack m_6115_(BlockSource p_123391_, net.minecraft.world.item.ItemStack p_123392_) {
        net.minecraft.world.item.ItemStack itemstack = this.m_7498_(p_123391_, p_123392_);
        this.m_6823_(p_123391_);
        this.m_123387_(p_123391_, (Direction)p_123391_.f_301783_().m_61143_((Property)DispenserBlock.f_52659_));
        return itemstack;
    }

    protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_301824_, net.minecraft.world.item.ItemStack p_123386_) {
        Direction direction = (Direction)p_301824_.f_301783_().m_61143_((Property)DispenserBlock.f_52659_);
        Position position = DispenserBlock.m_52720_(p_301824_);
        net.minecraft.world.item.ItemStack itemstack = p_123386_.m_41620_(1);
        if (!DefaultDispenseItemBehavior.spawnItem(p_301824_.f_301782_(), itemstack, 6, direction, p_301824_, this.dropper)) {
            itemstack.m_41769_(1);
        }
        return p_123386_;
    }

    public static void m_123378_(Level p_123379_, net.minecraft.world.item.ItemStack p_123380_, int p_123381_, Direction p_123382_, Position p_123383_) {
        double d0 = p_123383_.m_7096_();
        double d1 = p_123383_.m_7098_();
        double d2 = p_123383_.m_7094_();
        d1 = p_123382_.m_122434_() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itementity = new ItemEntity(p_123379_, d0, d1, d2, p_123380_);
        double d3 = p_123379_.f_46441_.m_188500_() * 0.1 + 0.2;
        itementity.m_20334_(p_123379_.f_46441_.m_216328_((double)p_123382_.m_122429_() * d3, 0.0172275 * (double)p_123381_), p_123379_.f_46441_.m_216328_(0.2, 0.0172275 * (double)p_123381_), p_123379_.f_46441_.m_216328_((double)p_123382_.m_122431_() * d3, 0.0172275 * (double)p_123381_));
        p_123379_.m_7967_(itementity);
    }

    public static boolean spawnItem(Level pLevel, net.minecraft.world.item.ItemStack pStack, int pSpeed, Direction pFacing, BlockSource isourceblock, boolean dropper) {
        if (pStack.m_41619_()) {
            return true;
        }
        Position iposition = DispenserBlock.m_52720_(isourceblock);
        double d0 = iposition.m_7096_();
        double d1 = iposition.m_7098_();
        double d2 = iposition.m_7094_();
        d1 = pFacing.m_122434_() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itementity = new ItemEntity(pLevel, d0, d1, d2, pStack);
        double d3 = pLevel.f_46441_.m_188500_() * 0.1 + 0.2;
        itementity.m_20334_(pLevel.f_46441_.m_216328_((double)pFacing.m_122429_() * d3, 0.0172275 * (double)pSpeed), pLevel.f_46441_.m_216328_(0.2, 0.0172275 * (double)pSpeed), pLevel.f_46441_.m_216328_((double)pFacing.m_122431_() * d3, 0.0172275 * (double)pSpeed));
        CraftBlock block = CraftBlock.at((LevelAccessor)pLevel, (BlockPos)isourceblock.f_301784_());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)pStack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), CraftVector.toBukkit((Vec3)itementity.m_20184_()));
        if (!DispenserBlock.eventFired) {
            pLevel.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        itementity.m_32045_(CraftItemStack.asNMSCopy((ItemStack)event.getItem()));
        itementity.m_20256_(CraftVector.toNMS((Vector)event.getVelocity()));
        if (!dropper && !event.getItem().getType().equals((Object)craftItem.getType())) {
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get(eventStack.m_41720_());
            if (idispensebehavior != DispenseItemBehavior.f_123393_ && idispensebehavior.getClass() != DefaultDispenseItemBehavior.class) {
                idispensebehavior.m_6115_(isourceblock, eventStack);
            } else {
                pLevel.m_7967_(itementity);
            }
            return false;
        }
        pLevel.m_7967_(itementity);
        return true;
    }

    protected void m_6823_(BlockSource p_123384_) {
        p_123384_.f_301782_().m_46796_(1000, p_123384_.f_301784_(), 0);
    }

    protected void m_123387_(BlockSource p_123388_, Direction p_123389_) {
        p_123388_.f_301782_().m_46796_(2000, p_123388_.f_301784_(), p_123389_.m_122411_());
    }
}

