/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory f_243672_;
    private final Item f_126106_;
    private final int f_126107_;
    private final List<String> f_126108_ = Lists.newArrayList();
    private final Map<Character, Ingredient> f_126109_ = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> f_291506_ = new LinkedHashMap();
    @Nullable
    private String f_126111_;
    private boolean f_271093_ = true;
    @Nullable
    private ICondition condition;

    public ShapedRecipeBuilder(RecipeCategory p_249996_, ItemLike p_251475_, int p_248948_) {
        this.f_243672_ = p_249996_;
        this.f_126106_ = p_251475_.m_5456_();
        this.f_126107_ = p_248948_;
    }

    public static ShapedRecipeBuilder m_245327_(RecipeCategory p_250853_, ItemLike p_249747_) {
        return ShapedRecipeBuilder.m_246608_(p_250853_, p_249747_, 1);
    }

    public static ShapedRecipeBuilder m_246608_(RecipeCategory p_251325_, ItemLike p_250636_, int p_249081_) {
        return new ShapedRecipeBuilder(p_251325_, p_250636_, p_249081_);
    }

    public ShapedRecipeBuilder m_206416_(Character p_206417_, TagKey<Item> p_206418_) {
        return this.m_126124_(p_206417_, Ingredient.m_204132_(p_206418_));
    }

    public ShapedRecipeBuilder m_126127_(Character p_126128_, ItemLike p_126129_) {
        return this.m_126124_(p_126128_, Ingredient.m_43929_(p_126129_));
    }

    public ShapedRecipeBuilder m_126124_(Character p_126125_, Ingredient p_126126_) {
        if (this.f_126109_.containsKey(p_126125_)) {
            throw new IllegalArgumentException("Symbol '" + p_126125_ + "' is already defined!");
        }
        if (p_126125_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.f_126109_.put(p_126125_, p_126126_);
        return this;
    }

    public ShapedRecipeBuilder m_126130_(String p_126131_) {
        if (!this.f_126108_.isEmpty() && p_126131_.length() != this.f_126108_.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.f_126108_.add(p_126131_);
        return this;
    }

    public ShapedRecipeBuilder m_126132_(String p_176751_, Criterion<?> p_300780_) {
        this.f_291506_.put(p_176751_, p_300780_);
        return this;
    }

    public ShapedRecipeBuilder m_126145_(@Nullable String p_126146_) {
        this.f_126111_ = p_126146_;
        return this;
    }

    public ShapedRecipeBuilder m_271710_(boolean p_273326_) {
        this.f_271093_ = p_273326_;
        return this;
    }

    public Item m_142372_() {
        return this.f_126106_;
    }

    public void m_126140_(RecipeOutput p_298334_, ResourceLocation p_126142_) {
        this.m_126143_(p_126142_);
        Advancement.Builder advancement$builder = p_298334_.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126142_)).m_138354_(AdvancementRewards.Builder.m_10009_(p_126142_)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
        this.f_291506_.forEach(advancement$builder::m_138383_);
        p_298334_.m_292927_((FinishedRecipe)new Result(p_126142_, this.f_126106_, this.f_126107_, this.f_126111_ == null ? "" : this.f_126111_, ShapedRecipeBuilder.m_245179_(this.f_243672_), this.f_126108_, this.f_126109_, advancement$builder.m_138403_(p_126142_.m_246208_("recipes/" + this.f_243672_.m_247710_() + "/")), this.f_271093_).withCondition(this.condition));
    }

    public ShapedRecipeBuilder condition(ICondition condition) {
        this.condition = condition;
        return this;
    }

    private void m_126143_(ResourceLocation p_126144_) {
        if (this.f_126108_.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(p_126144_) + "!");
        }
        HashSet set = Sets.newHashSet(this.f_126109_.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.f_126108_) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.f_126109_.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(p_126144_) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(p_126144_));
        }
        if (this.f_126108_.size() == 1 && this.f_126108_.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + String.valueOf(p_126144_) + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.f_291506_.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(p_126144_));
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation f_126148_;
        private final Item f_126149_;
        private final int f_126150_;
        private final String f_126151_;
        private final List<String> f_126152_;
        private final Map<Character, Ingredient> f_126153_;
        private final AdvancementHolder f_126154_;
        private final boolean f_271297_;

        public Result(ResourceLocation p_273548_, Item p_273530_, int p_272738_, String p_273549_, CraftingBookCategory p_273500_, List<String> p_273744_, Map<Character, Ingredient> p_272991_, AdvancementHolder p_297223_, boolean p_272862_) {
            super(p_273500_);
            this.f_126148_ = p_273548_;
            this.f_126149_ = p_273530_;
            this.f_126150_ = p_272738_;
            this.f_126151_ = p_273549_;
            this.f_126152_ = p_273744_;
            this.f_126153_ = p_272991_;
            this.f_126154_ = p_297223_;
            this.f_271297_ = p_272862_;
        }

        @Override
        public void m_7917_(JsonObject p_126167_) {
            super.m_7917_(p_126167_);
            if (!this.f_126151_.isEmpty()) {
                p_126167_.addProperty("group", this.f_126151_);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.f_126152_) {
                jsonarray.add(string);
            }
            p_126167_.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.f_126153_.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_(false));
            }
            p_126167_.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.f_126149_).toString());
            if (this.f_126150_ > 1) {
                jsonObject.addProperty("count", (Number)this.f_126150_);
            }
            p_126167_.add("result", (JsonElement)jsonObject);
            p_126167_.addProperty("show_notification", Boolean.valueOf(this.f_271297_));
        }

        @Override
        public RecipeSerializer<?> m_126169_() {
            return RecipeSerializer.f_44076_;
        }

        @Override
        public ResourceLocation m_126168_() {
            return this.f_126148_;
        }

        @Override
        public AdvancementHolder m_126373_() {
            return this.f_126154_;
        }
    }
}

