/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger f_177585_ = LogUtils.getLogger();
    private static final int f_177586_ = 20;
    private static final Services f_236789_ = new Services((MinecraftSessionService)null, ServicesKeySet.EMPTY, (GameProfileRepository)null, (GameProfileCache)null);
    private final List<GameTestBatch> f_177587_;
    private final BlockPos f_177588_;
    private static final GameRules f_177589_ = Util.m_137469_(new GameRules(), p_177615_ -> {
        p_177615_.m_46170_(GameRules.f_46134_).m_46246_(false, null);
        p_177615_.m_46170_(GameRules.f_46150_).m_46246_(false, null);
    });
    private static final WorldOptions f_243964_ = new WorldOptions(0L, false, false);
    @Nullable
    private MultipleTestTracker f_177591_;

    public static GameTestServer m_206606_(Thread p_206607_, LevelStorageSource.LevelStorageAccess p_206608_, PackRepository p_206609_, Collection<GameTestBatch> p_206610_, BlockPos p_206611_) {
        if (p_206610_.isEmpty()) {
            throw new IllegalArgumentException("No test batches were given!");
        }
        p_206609_.m_10506_();
        WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(new DataPackConfig(new ArrayList<String>(p_206609_.m_10514_()), List.of()), FeatureFlags.f_244280_.m_247355_());
        LevelSettings levelsettings = new LevelSettings("Test Level", GameType.CREATIVE, false, Difficulty.NORMAL, true, f_177589_, worlddataconfiguration);
        WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(p_206609_, worlddataconfiguration, false, true);
        WorldLoader.InitConfig worldloader$initconfig = new WorldLoader.InitConfig(worldloader$packconfig, Commands.CommandSelection.DEDICATED, 4);
        try {
            f_177585_.debug("Starting resource loading");
            Stopwatch stopwatch = Stopwatch.createStarted();
            WorldStem worldstem = (WorldStem)Util.m_214679_(p_248045_ -> WorldLoader.m_214362_(worldloader$initconfig, p_258205_ -> {
                Registry registry = new MappedRegistry(Registries.f_256862_, Lifecycle.stable()).m_203521_();
                WorldDimensions.Complete worlddimensions$complete = ((WorldPreset)p_258205_.f_244104_().m_175515_(Registries.f_256729_).m_246971_(WorldPresets.f_226438_).m_203334_()).m_247748_().m_245300_(registry);
                return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData(levelsettings, f_243964_, worlddimensions$complete.f_244634_(), worlddimensions$complete.m_245945_()), worlddimensions$complete.m_245593_());
            }, WorldStem::new, Util.m_183991_(), p_248045_)).get();
            stopwatch.stop();
            f_177585_.debug("Finished resource loading after {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return new GameTestServer(p_206607_, p_206608_, p_206609_, worldstem, p_206610_, p_206611_);
        }
        catch (Exception exception) {
            f_177585_.warn("Failed to load vanilla datapack, bit oops", (Throwable)exception);
            System.exit(-1);
            throw new IllegalStateException();
        }
    }

    public GameTestServer(Thread p_206597_, LevelStorageSource.LevelStorageAccess p_206598_, PackRepository p_206599_, WorldStem p_206600_, Collection<GameTestBatch> p_206601_, BlockPos p_206602_) {
        super(p_206597_, p_206598_, p_206599_, p_206600_, Proxy.NO_PROXY, DataFixers.m_14512_(), f_236789_, LoggerChunkProgressListener::new);
        this.f_177587_ = Lists.newArrayList(p_206601_);
        this.f_177588_ = p_206602_;
    }

    @Override
    public boolean m_7038_() {
        this.m_129823_(new PlayerList(this, this.m_247573_(), this.f_129745_, 1){});
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        this.m_130006_();
        ServerLevel serverlevel = this.m_129783_();
        serverlevel.m_8733_(this.f_177588_, 0.0f);
        int i = 20000000;
        serverlevel.m_8606_(20000000, 20000000, false, false);
        f_177585_.info("Started game test server");
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public void m_5705_(BooleanSupplier p_177619_) {
        super.m_5705_(p_177619_);
        ServerLevel serverlevel = this.m_129783_();
        if (!this.m_177628_()) {
            this.m_177624_(serverlevel);
        }
        if (serverlevel.m_46467_() % 20L == 0L) {
            f_177585_.info(this.f_177591_.m_127822_());
        }
        if (this.f_177591_.m_127821_()) {
            this.m_7570_(false);
            f_177585_.info(this.f_177591_.m_127822_());
            GlobalTestReporter.m_177652_();
            f_177585_.info("========= {} GAME TESTS COMPLETE ======================", (Object)this.f_177591_.m_127820_());
            if (this.f_177591_.m_127818_()) {
                f_177585_.info("{} required tests failed :(", (Object)this.f_177591_.m_127803_());
                this.f_177591_.m_177682_().forEach(p_206615_ -> f_177585_.info("   - {}", (Object)p_206615_.m_127633_()));
            } else {
                f_177585_.info("All {} required tests passed :)", (Object)this.f_177591_.m_127820_());
            }
            if (this.f_177591_.m_127819_()) {
                f_177585_.info("{} optional tests failed", (Object)this.f_177591_.m_127816_());
                this.f_177591_.m_177683_().forEach(p_206613_ -> f_177585_.info("   - {}", (Object)p_206613_.m_127633_()));
            }
            f_177585_.info("====================================================");
        }
    }

    @Override
    public void m_130012_() {
        this.m_18699_();
    }

    @Override
    public SystemReport m_142424_(SystemReport p_177613_) {
        p_177613_.m_143519_("Type", "Game test server");
        return p_177613_;
    }

    @Override
    public void m_6988_() {
        super.m_6988_();
        f_177585_.info("Game test server shutting down");
        System.exit(this.f_177591_.m_127803_());
    }

    @Override
    public void m_7268_(CrashReport p_177623_) {
        super.m_7268_(p_177623_);
        f_177585_.error("Game test server crashed\n{}", (Object)p_177623_.m_127526_());
        System.exit(1);
    }

    private void m_177624_(ServerLevel p_177625_) {
        Collection collection = GameTestRunner.m_127726_(this.f_177587_, (BlockPos)new BlockPos(0, -60, 0), (Rotation)Rotation.NONE, (ServerLevel)p_177625_, (GameTestTicker)GameTestTicker.f_177648_, (int)8);
        this.f_177591_ = new MultipleTestTracker(collection);
        f_177585_.info("{} tests are now running!", (Object)this.f_177591_.m_127820_());
    }

    private boolean m_177628_() {
        return this.f_177591_ != null;
    }

    @Override
    public boolean m_7035_() {
        return false;
    }

    @Override
    public int m_7022_() {
        return 0;
    }

    @Override
    public int m_7034_() {
        return 4;
    }

    @Override
    public boolean m_6983_() {
        return false;
    }

    @Override
    public boolean m_6982_() {
        return false;
    }

    @Override
    public int m_7032_() {
        return 0;
    }

    @Override
    public boolean m_6994_() {
        return false;
    }

    @Override
    public boolean m_6993_() {
        return true;
    }

    @Override
    public boolean m_6992_() {
        return false;
    }

    @Override
    public boolean m_6102_() {
        return false;
    }

    @Override
    public boolean m_7779_(GameProfile p_177617_) {
        return false;
    }
}

