/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mohistmc.MohistConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.spigotmc.SpigotConfig;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    private static final byte f_178797_ = 3;
    private static final byte f_178798_ = 4;
    private static final byte f_178799_ = 8;
    private static final byte f_178800_ = 16;
    private static final byte f_178801_ = 0;
    private static final byte f_178802_ = 1;
    private static final byte f_178803_ = 2;
    private final int f_237619_;
    private final List<Entry> f_237620_;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> p_131861_) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> object2intmap = ClientboundCommandsPacket.m_131862_(p_131861_);
        this.f_237620_ = ClientboundCommandsPacket.m_237626_(object2intmap);
        this.f_237619_ = object2intmap.getInt(p_131861_);
    }

    public ClientboundCommandsPacket(FriendlyByteBuf p_178805_) {
        this.f_237620_ = p_178805_.m_236845_(ClientboundCommandsPacket::m_131887_);
        this.f_237619_ = p_178805_.m_130242_();
        ClientboundCommandsPacket.m_237628_(this.f_237620_);
    }

    public void m_5779_(FriendlyByteBuf p_131886_) {
        p_131886_.m_236828_(this.f_237620_, (p_237642_, p_237643_) -> p_237643_.m_237674_((FriendlyByteBuf)((Object)p_237642_)));
        p_131886_.m_130130_(this.f_237619_);
    }

    private static void m_237630_(List<Entry> p_237631_, BiPredicate<Entry, IntSet> p_237632_) {
        IntOpenHashSet intset = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)p_237631_.size()));
        while (!intset.isEmpty()) {
            boolean flag = intset.removeIf(arg_0 -> ClientboundCommandsPacket.m_237633_(p_237632_, p_237631_, (IntSet)intset, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void m_237628_(List<Entry> p_237629_) {
        ClientboundCommandsPacket.m_237630_(p_237629_, Entry::m_237672_);
        ClientboundCommandsPacket.m_237630_(p_237629_, Entry::m_237676_);
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> m_131862_(RootCommandNode<SharedSuggestionProvider> p_131863_) {
        CommandNode commandnode;
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(p_131863_);
        while ((commandnode = (CommandNode)queue.poll()) != null) {
            if (object2intmap.containsKey((Object)commandnode)) continue;
            int i = object2intmap.size();
            object2intmap.put((Object)commandnode, i);
            queue.addAll(commandnode.getChildren());
            if (commandnode.getRedirect() == null) continue;
            queue.add(commandnode.getRedirect());
        }
        return object2intmap;
    }

    private static List<Entry> m_237626_(Object2IntMap<CommandNode<SharedSuggestionProvider>> p_237627_) {
        ObjectArrayList objectarraylist = new ObjectArrayList(p_237627_.size());
        objectarraylist.size(p_237627_.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(p_237627_)) {
            objectarraylist.set(entry.getIntValue(), (Object)ClientboundCommandsPacket.m_237621_((CommandNode<SharedSuggestionProvider>)((CommandNode)entry.getKey()), p_237627_));
        }
        return objectarraylist;
    }

    private static Entry m_131887_(FriendlyByteBuf p_131888_) {
        byte b0 = p_131888_.readByte();
        int[] aint = p_131888_.m_130100_();
        int i = (b0 & 8) != 0 ? p_131888_.m_130242_() : 0;
        NodeStub clientboundcommandspacket$nodestub = ClientboundCommandsPacket.m_237638_(p_131888_, b0);
        return new Entry(clientboundcommandspacket$nodestub, b0, i, aint);
    }

    @Nullable
    private static NodeStub m_237638_(FriendlyByteBuf p_237639_, byte p_237640_) {
        int i = p_237640_ & 3;
        if (i == 2) {
            String s1 = p_237639_.m_130277_();
            int j = p_237639_.m_130242_();
            ArgumentTypeInfo argumenttypeinfo = (ArgumentTypeInfo)BuiltInRegistries.f_256979_.m_7942_(j);
            if (argumenttypeinfo == null) {
                return null;
            }
            ArgumentTypeInfo.Template template = argumenttypeinfo.m_213618_(p_237639_);
            ResourceLocation resourcelocation = (p_237640_ & 0x10) != 0 ? p_237639_.m_130281_() : null;
            return new ArgumentNodeStub(s1, template, resourcelocation);
        }
        if (i == 1) {
            String s = p_237639_.m_130277_();
            return new LiteralNodeStub(s);
        }
        return null;
    }

    private static Entry m_237621_(CommandNode<SharedSuggestionProvider> p_237622_, Object2IntMap<CommandNode<SharedSuggestionProvider>> p_237623_) {
        NodeStub clientboundcommandspacket$nodestub;
        int j;
        int i = 0;
        if (p_237622_.getRedirect() != null) {
            i |= 8;
            j = p_237623_.getInt((Object)p_237622_.getRedirect());
        } else {
            j = 0;
        }
        if (p_237622_.getCommand() != null) {
            i |= 4;
        }
        if (p_237622_ instanceof RootCommandNode) {
            i |= 0;
            clientboundcommandspacket$nodestub = null;
        } else if (p_237622_ instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)p_237622_;
            clientboundcommandspacket$nodestub = new ArgumentNodeStub(argumentcommandnode);
            i |= 2;
            if (argumentcommandnode.getCustomSuggestions() != null) {
                i |= 0x10;
            }
        } else {
            if (!(p_237622_ instanceof LiteralCommandNode)) {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(p_237622_));
            }
            LiteralCommandNode literalcommandnode = (LiteralCommandNode)p_237622_;
            clientboundcommandspacket$nodestub = new LiteralNodeStub(literalcommandnode.getLiteral());
            i |= 1;
        }
        int[] aint = p_237622_.getChildren().stream().mapToInt(arg_0 -> p_237623_.getInt(arg_0)).toArray();
        return new Entry(clientboundcommandspacket$nodestub, i, j, aint);
    }

    public void m_5797_(ClientGamePacketListener p_131878_) {
        p_131878_.m_7443_(this);
    }

    public RootCommandNode<SharedSuggestionProvider> m_237624_(CommandBuildContext p_237625_) {
        return (RootCommandNode)new NodeResolver(p_237625_, this.f_237620_).m_237691_(this.f_237619_);
    }

    private static /* synthetic */ boolean m_237633_(BiPredicate p_237634_, List p_237635_, IntSet p_237636_, int p_237637_) {
        return p_237634_.test((Entry)p_237635_.get(p_237637_), p_237636_);
    }

    static class Entry {
        @Nullable
        final NodeStub f_237666_;
        final int f_131890_;
        final int f_131891_;
        final int[] f_131892_;

        Entry(@Nullable NodeStub p_237668_, int p_237669_, int p_237670_, int[] p_237671_) {
            this.f_237666_ = p_237668_;
            this.f_131890_ = p_237669_;
            this.f_131891_ = p_237670_;
            this.f_131892_ = p_237671_;
        }

        public void m_237674_(FriendlyByteBuf p_237675_) {
            p_237675_.writeByte(this.f_131890_);
            p_237675_.m_130089_(this.f_131892_);
            if ((this.f_131890_ & 8) != 0) {
                p_237675_.m_130130_(this.f_131891_);
            }
            if (this.f_237666_ != null) {
                this.f_237666_.m_214206_(p_237675_);
            }
        }

        public boolean m_237672_(IntSet p_237673_) {
            if ((this.f_131890_ & 8) != 0) {
                return !p_237673_.contains(this.f_131891_);
            }
            return true;
        }

        public boolean m_237676_(IntSet p_237677_) {
            for (int i : this.f_131892_) {
                if (!p_237677_.contains(i)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public ArgumentBuilder<SharedSuggestionProvider, ?> m_213891_(CommandBuildContext var1);

        public void m_214206_(FriendlyByteBuf var1);
    }

    static class ArgumentNodeStub
    implements NodeStub {
        private final String f_237644_;
        private final ArgumentTypeInfo.Template<?> f_237645_;
        @Nullable
        private final ResourceLocation f_237646_;

        @Nullable
        private static ResourceLocation m_237653_(@Nullable SuggestionProvider<SharedSuggestionProvider> p_237654_) {
            return p_237654_ != null ? SuggestionProviders.m_121654_(p_237654_) : null;
        }

        ArgumentNodeStub(String p_237650_, ArgumentTypeInfo.Template<?> p_237651_, @Nullable ResourceLocation p_237652_) {
            this.f_237644_ = p_237650_;
            this.f_237645_ = p_237651_;
            this.f_237646_ = p_237652_;
        }

        public ArgumentNodeStub(ArgumentCommandNode<SharedSuggestionProvider, ?> p_237648_) {
            this(p_237648_.getName(), ArgumentTypeInfos.m_235393_(p_237648_.getType()), ArgumentNodeStub.m_237653_((SuggestionProvider<SharedSuggestionProvider>)p_237648_.getCustomSuggestions()));
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> m_213891_(CommandBuildContext p_237656_) {
            ArgumentType argumenttype = this.f_237645_.m_213879_(p_237656_);
            RequiredArgumentBuilder requiredargumentbuilder = RequiredArgumentBuilder.argument((String)this.f_237644_, (ArgumentType)argumenttype);
            if (this.f_237646_ != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.m_121656_((ResourceLocation)this.f_237646_));
            }
            return requiredargumentbuilder;
        }

        @Override
        public void m_214206_(FriendlyByteBuf p_237658_) {
            p_237658_.m_130070_(this.f_237644_);
            ArgumentNodeStub.m_237659_(p_237658_, this.f_237645_);
            if (this.f_237646_ != null) {
                p_237658_.m_130085_(this.f_237646_);
            }
        }

        private static <A extends ArgumentType<?>> void m_237659_(FriendlyByteBuf p_237660_, ArgumentTypeInfo.Template<A> p_237661_) {
            ArgumentNodeStub.m_237662_(p_237660_, p_237661_.m_213709_(), p_237661_);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void m_237662_(FriendlyByteBuf p_237663_, ArgumentTypeInfo<A, T> p_237664_, ArgumentTypeInfo.Template<A> p_237665_) {
            ResourceLocation key = ForgeRegistries.COMMAND_ARGUMENT_TYPES.getKey(p_237664_);
            if (!MohistConfig.velocity_enabled && !SpigotConfig.bungee || key != null && (key.m_135827_().equals("minecraft") || key.m_135827_().equals("brigadier"))) {
                p_237663_.m_130130_(BuiltInRegistries.f_256979_.m_7447_(p_237664_));
                p_237664_.m_214155_(p_237665_, p_237663_);
                return;
            }
            p_237663_.m_130130_(-256);
            p_237663_.m_130130_(BuiltInRegistries.f_256979_.m_7447_(p_237664_));
            FriendlyByteBuf payload = new FriendlyByteBuf(Unpooled.buffer());
            p_237664_.m_214155_(p_237665_, payload);
            p_237663_.m_130130_(payload.readableBytes());
            p_237663_.writeBytes(payload);
        }
    }

    static class LiteralNodeStub
    implements NodeStub {
        private final String f_237678_;

        LiteralNodeStub(String p_237680_) {
            this.f_237678_ = p_237680_;
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> m_213891_(CommandBuildContext p_237682_) {
            return LiteralArgumentBuilder.literal((String)this.f_237678_);
        }

        @Override
        public void m_214206_(FriendlyByteBuf p_237684_) {
            p_237684_.m_130070_(this.f_237678_);
        }
    }

    static class NodeResolver {
        private final CommandBuildContext f_237685_;
        private final List<Entry> f_237686_;
        private final List<CommandNode<SharedSuggestionProvider>> f_237687_;

        NodeResolver(CommandBuildContext p_237689_, List<Entry> p_237690_) {
            this.f_237685_ = p_237689_;
            this.f_237686_ = p_237690_;
            ObjectArrayList objectarraylist = new ObjectArrayList();
            objectarraylist.size(p_237690_.size());
            this.f_237687_ = objectarraylist;
        }

        public CommandNode<SharedSuggestionProvider> m_237691_(int p_237692_) {
            RootCommandNode commandnode1;
            CommandNode<SharedSuggestionProvider> commandnode = this.f_237687_.get(p_237692_);
            if (commandnode != null) {
                return commandnode;
            }
            Entry clientboundcommandspacket$entry = this.f_237686_.get(p_237692_);
            if (clientboundcommandspacket$entry.f_237666_ == null) {
                commandnode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<SharedSuggestionProvider, ?> argumentbuilder = clientboundcommandspacket$entry.f_237666_.m_213891_(this.f_237685_);
                if ((clientboundcommandspacket$entry.f_131890_ & 8) != 0) {
                    argumentbuilder.redirect(this.m_237691_(clientboundcommandspacket$entry.f_131891_));
                }
                if ((clientboundcommandspacket$entry.f_131890_ & 4) != 0) {
                    argumentbuilder.executes(p_237694_ -> 0);
                }
                commandnode1 = argumentbuilder.build();
            }
            this.f_237687_.set(p_237692_, (CommandNode<SharedSuggestionProvider>)commandnode1);
            for (int i : clientboundcommandspacket$entry.f_131892_) {
                CommandNode<SharedSuggestionProvider> commandnode2 = this.m_237691_(i);
                if (commandnode2 instanceof RootCommandNode) continue;
                commandnode1.addChild(commandnode2);
            }
            return commandnode1;
        }
    }
}

