/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.network.ServerStatusPing;

public final class ServerStatus {
    public static final Codec<ServerStatus> f_271163_ = RecordCodecBuilder.create(p_273270_ -> p_273270_.group((App)ExtraCodecs.f_252442_.optionalFieldOf("description", (Object)CommonComponents.f_237098_).forGetter(ServerStatus::f_134900_), (App)Players.f_271480_.optionalFieldOf("players").forGetter(ServerStatus::f_134901_), (App)Version.f_271272_.optionalFieldOf("version").forGetter(ServerStatus::f_134902_), (App)Favicon.f_271281_.optionalFieldOf("favicon").forGetter(ServerStatus::f_134903_), (App)Codec.BOOL.optionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerStatus::f_242955_), (App)ServerStatusPing.CODEC.optionalFieldOf("forgeData").forGetter(ServerStatus::forgeData)).apply((Applicative)p_273270_, ServerStatus::new));
    private final Component f_134900_;
    private final Optional<Players> f_134901_;
    private final Optional<Version> f_134902_;
    private final Optional<Favicon> f_134903_;
    private final boolean f_242955_;
    private final Optional<ServerStatusPing> forgeData;

    public ServerStatus(Component f_134900_, Optional<Players> f_134901_, Optional<Version> f_134902_, Optional<Favicon> f_134903_, boolean f_242955_) {
        this.f_134900_ = f_134900_;
        this.f_134901_ = f_134901_;
        this.f_134902_ = f_134902_;
        this.f_134903_ = f_134903_;
        this.f_242955_ = f_242955_;
        this.forgeData = Optional.of(new ServerStatusPing());
    }

    public ServerStatus(Component description, Optional<Players> players, Optional<Version> version, Optional<Favicon> favicon, boolean enforcesSecureChat, Optional<ServerStatusPing> forgeData) {
        this.f_134900_ = description;
        this.f_134901_ = players;
        this.f_134902_ = version;
        this.f_134903_ = favicon;
        this.f_242955_ = enforcesSecureChat;
        this.forgeData = forgeData;
    }

    public Component f_134900_() {
        return this.f_134900_;
    }

    public Optional<Players> f_134901_() {
        return this.f_134901_;
    }

    public Optional<Version> f_134902_() {
        return this.f_134902_;
    }

    public Optional<Favicon> f_134903_() {
        return this.f_134903_;
    }

    public boolean f_242955_() {
        return this.f_242955_;
    }

    public Optional<ServerStatusPing> forgeData() {
        return this.forgeData;
    }

    public boolean equals(Object p_273273_) {
        if (p_273273_ == this) {
            return true;
        }
        if (p_273273_ == null || p_273273_.getClass() != this.getClass()) {
            return false;
        }
        ServerStatus that = (ServerStatus)p_273273_;
        return Objects.equals(this.f_134900_, that.f_134900_) && Objects.equals(this.f_134901_, that.f_134901_) && Objects.equals(this.f_134902_, that.f_134902_) && Objects.equals(this.f_134903_, that.f_134903_) && this.f_242955_ == that.f_242955_ && Objects.equals(this.forgeData, that.forgeData);
    }

    public int hashCode() {
        return Objects.hash(this.f_134900_, this.f_134901_, this.f_134902_, this.f_134903_, this.f_242955_, this.forgeData);
    }

    public String toString() {
        return "ServerStatus[description=" + String.valueOf(this.f_134900_) + ", players=" + String.valueOf(this.f_134901_) + ", version=" + String.valueOf(this.f_134902_) + ", favicon=" + String.valueOf(this.f_134903_) + ", enforcesSecureChat=" + this.f_242955_ + ", forgeData=" + String.valueOf(this.forgeData) + "]";
    }

    public record Players(int f_271503_, int f_271178_, List<GameProfile> f_134919_) {
        private static final Codec<GameProfile> f_271466_ = RecordCodecBuilder.create(p_272926_ -> p_272926_.group((App)UUIDUtil.f_260719_.fieldOf("id").forGetter(GameProfile::getId), (App)Codec.STRING.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)p_272926_, GameProfile::new));
        public static final Codec<Players> f_271480_ = RecordCodecBuilder.create(p_273295_ -> p_273295_.group((App)Codec.INT.fieldOf("max").forGetter(Players::f_271503_), (App)Codec.INT.fieldOf("online").forGetter(Players::f_271178_), (App)f_271466_.listOf().optionalFieldOf("sample", List.of()).forGetter(Players::f_134919_)).apply((Applicative)p_273295_, Players::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Players.class, "max;online;sample", "f_271503_", "f_271178_", "f_134919_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Players.class, "max;online;sample", "f_271503_", "f_271178_", "f_134919_"}, this);
        }

        @Override
        public final boolean equals(Object p_273193_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Players.class, "max;online;sample", "f_271503_", "f_271178_", "f_134919_"}, this, p_273193_);
        }
    }

    public record Version(String f_134962_, int f_134963_) {
        public static final Codec<Version> f_271272_ = RecordCodecBuilder.create(p_273157_ -> p_273157_.group((App)Codec.STRING.fieldOf("name").forGetter(Version::f_134962_), (App)Codec.INT.fieldOf("protocol").forGetter(Version::f_134963_)).apply((Applicative)p_273157_, Version::new));

        public static Version m_272202_() {
            WorldVersion worldversion = SharedConstants.m_183709_();
            return new Version(worldversion.m_132493_(), worldversion.m_132495_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Version.class, "name;protocol", "f_134962_", "f_134963_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Version.class, "name;protocol", "f_134962_", "f_134963_"}, this);
        }

        @Override
        public final boolean equals(Object p_273000_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Version.class, "name;protocol", "f_134962_", "f_134963_"}, this, p_273000_);
        }
    }

    public record Favicon(byte[] f_271462_) {
        private static final String f_271186_ = "data:image/png;base64,";
        public static final Codec<Favicon> f_271281_ = Codec.STRING.comapFlatMap(p_274795_ -> {
            if (!p_274795_.startsWith(f_271186_)) {
                return DataResult.error(() -> "Unknown format");
            }
            try {
                String s = p_274795_.substring(f_271186_.length()).replaceAll("\n", "");
                byte[] abyte = Base64.getDecoder().decode(s.getBytes(StandardCharsets.UTF_8));
                return DataResult.success((Object)new Favicon(abyte));
            }
            catch (IllegalArgumentException illegalargumentexception) {
                return DataResult.error(() -> "Malformed base64 server icon");
            }
        }, p_273258_ -> f_271186_ + new String(Base64.getEncoder().encode(p_273258_.f_271462_), StandardCharsets.UTF_8));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Favicon.class, "iconBytes", "f_271462_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Favicon.class, "iconBytes", "f_271462_"}, this);
        }

        @Override
        public final boolean equals(Object p_273505_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Favicon.class, "iconBytes", "f_271462_"}, this, p_273505_);
        }
    }
}

