/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ClientboundRegistryDataPacket;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.config.JoinWorldTask;
import net.minecraft.server.network.config.ServerResourcePackConfigurationTask;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.config.ConfigurationTaskContext;
import net.minecraftforge.network.config.SimpleConfigurationTask;
import org.slf4j.Logger;

public class ServerConfigurationPacketListenerImpl
extends ServerCommonPacketListenerImpl
implements TickablePacketListener,
ServerConfigurationPacketListener {
    private static final Logger f_291519_ = LogUtils.getLogger();
    private static final Component f_291657_ = Component.m_237115_("multiplayer.disconnect.invalid_player_data");
    private static final ConfigurationTask.Type VANILLA_START = new ConfigurationTask.Type("vanilla_start");
    private final GameProfile f_291596_;
    private final Queue<ConfigurationTask> f_290691_ = new ConcurrentLinkedQueue<ConfigurationTask>();
    @Nullable
    private ConfigurationTask f_291862_;
    private ClientInformation f_290851_;
    private final ConfigurationTaskContext taskContext;

    public ServerConfigurationPacketListenerImpl(MinecraftServer p_301415_, Connection p_298106_, CommonListenerCookie p_301309_, ServerPlayer player) {
        super(p_301415_, p_298106_, p_301309_, player);
        this.f_291596_ = p_301309_.f_290628_();
        this.f_290851_ = p_301309_.f_290565_();
        this.taskContext = new ConfigurationTaskContext(p_298106_, this::m_141995_, this::m_293514_);
    }

    @Override
    protected GameProfile m_293343_() {
        return this.f_291596_;
    }

    @Override
    public void m_7026_(Component p_300313_) {
        f_291519_.info("{} lost connection: {}", (Object)this.f_291596_, (Object)p_300313_.getString());
        super.m_7026_(p_300313_);
    }

    public boolean m_6198_() {
        return this.f_291338_.m_129536_();
    }

    private void vanillaStart() {
        this.m_141995_(new ClientboundCustomPayloadPacket((CustomPacketPayload)new BrandPayload(this.f_291389_.getServerModName())));
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = this.f_291389_.m_247573_();
        this.m_141995_((Packet<?>)new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.f_244280_.m_245829_(this.f_291389_.m_129910_().m_247623_())));
        this.m_141995_((Packet<?>)new ClientboundRegistryDataPacket(new RegistryAccess.ImmutableRegistryAccess(RegistrySynchronization.m_257599_(layeredregistryaccess)).m_203557_()));
        this.m_141995_((Packet<?>)new ClientboundUpdateTagsPacket(TagNetworkSerialization.m_245799_(layeredregistryaccess)));
    }

    public void m_294295_() {
        ForgeEventFactory.gatherLoginConfigTasks((Connection)this.f_291338_, this.f_290691_::add);
        this.f_290691_.add((ConfigurationTask)new SimpleConfigurationTask(VANILLA_START, this::vanillaStart));
        this.m_295612_();
        this.f_290691_.add((ConfigurationTask)new JoinWorldTask());
        this.m_295676_();
    }

    public void m_295733_() {
        this.f_290691_.add((ConfigurationTask)new JoinWorldTask());
        this.m_295676_();
    }

    private void m_295612_() {
        this.f_291389_.m_214042_().ifPresent(p_300306_ -> this.f_290691_.add((ConfigurationTask)new ServerResourcePackConfigurationTask(p_300306_)));
    }

    public void m_9844_(ServerboundClientInformationPacket p_297305_) {
        this.f_290851_ = p_297305_.f_291402_();
    }

    @Override
    public void m_293248_(ServerboundResourcePackPacket p_300631_) {
        super.m_293248_(p_300631_);
        if (p_300631_.m_294355_() != ServerboundResourcePackPacket.Action.ACCEPTED) {
            this.m_293514_(ServerResourcePackConfigurationTask.f_290893_);
        }
    }

    public void m_293007_(ServerboundFinishConfigurationPacket p_297811_) {
        this.f_291338_.m_294044_();
        PacketUtils.m_131363_((Packet)p_297811_, (PacketListener)this, (BlockableEventLoop)this.f_291389_);
        this.m_293514_(JoinWorldTask.f_291484_);
        try {
            PlayerList playerlist = this.f_291389_.m_6846_();
            if (playerlist.m_11259_(this.f_291596_.getId()) != null) {
                this.m_294716_(PlayerList.f_291251_);
                return;
            }
            Component component = null;
            if (component != null) {
                this.m_294716_(component);
                return;
            }
            ServerPlayer serverplayer = playerlist.getPlayerForLogin(this.f_291596_, this.f_290851_, this.player);
            playerlist.m_11261_(this.f_291338_, serverplayer, this.m_295477_(this.f_290851_));
            this.f_291338_.m_294304_();
        }
        catch (Exception exception) {
            f_291519_.error("Couldn't place player in world", (Throwable)exception);
            this.f_291338_.m_129512_((Packet<?>)new ClientboundDisconnectPacket(f_291657_));
            this.f_291338_.m_129507_(f_291657_);
        }
    }

    public void m_9933_() {
        this.m_295188_();
    }

    private void m_295676_() {
        ConfigurationTask configurationtask;
        if (this.f_291862_ != null) {
            throw new IllegalStateException("Task " + this.f_291862_.m_293172_().f_290885_() + " has not finished yet");
        }
        if (this.m_6198_() && (configurationtask = this.f_290691_.poll()) != null) {
            this.f_291862_ = configurationtask;
            configurationtask.start(this.taskContext);
        }
    }

    public void m_293514_(ConfigurationTask.Type p_297864_) {
        ConfigurationTask.Type configurationtask$type;
        ConfigurationTask.Type type = configurationtask$type = this.f_291862_ != null ? this.f_291862_.m_293172_() : null;
        if (!p_297864_.equals(configurationtask$type)) {
            throw new IllegalStateException("Unexpected request for task finish, current task: " + String.valueOf(configurationtask$type) + ", requested: " + String.valueOf(p_297864_));
        }
        this.f_291862_ = null;
        this.m_295676_();
    }
}

