/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class ServerHandshakePacketListenerImpl
implements ServerHandshakePacketListener {
    private static final Component f_9964_ = Component.m_237115_("disconnect.ignoring_status_request");
    private final MinecraftServer f_9965_;
    private final Connection f_9966_;
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");

    public ServerHandshakePacketListenerImpl(MinecraftServer p_9969_, Connection p_9970_) {
        this.f_9965_ = p_9969_;
        this.f_9966_ = p_9970_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7322_(ClientIntentionPacket p_9975_) {
        if (!ServerLifecycleHooks.handleServerLogin((ClientIntentionPacket)p_9975_, (Connection)this.f_9966_)) {
            return;
        }
        this.f_9966_.hostname = p_9975_.f_134721_() + ":" + p_9975_.f_134722_();
        switch (p_9975_.f_134723_()) {
            case LOGIN: {
                this.f_9966_.m_294993_(ClientIntent.LOGIN);
                try {
                    long currentTime = System.currentTimeMillis();
                    long connectionThrottle = this.f_9965_.server.getConnectionThrottle();
                    InetAddress address = ((InetSocketAddress)this.f_9966_.m_129523_()).getAddress();
                    HashMap<InetAddress, Long> hashMap = throttleTracker;
                    synchronized (hashMap) {
                        if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                            throttleTracker.put(address, currentTime);
                            MutableComponent chatmessage = Component.m_237113_("Connection throttled! Please wait before reconnecting.");
                            this.f_9966_.m_129512_((Packet<?>)new ClientboundLoginDisconnectPacket((Component)chatmessage));
                            this.f_9966_.m_129507_((Component)chatmessage);
                            return;
                        }
                        throttleTracker.put(address, currentTime);
                        if (++throttleCounter > 200) {
                            throttleCounter = 0;
                            Iterator<Map.Entry<InetAddress, Long>> iter = throttleTracker.entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry<InetAddress, Long> entry = iter.next();
                                if (entry.getValue() <= connectionThrottle) continue;
                                iter.remove();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LogManager.getLogger().debug("Failed to check connection throttle", t);
                }
                if (p_9975_.f_134720_() != SharedConstants.m_183709_().m_132495_()) {
                    MutableComponent component = p_9975_.f_134720_() < 754 ? Component.m_237113_(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.m_183709_().m_132493_())) : Component.m_237113_(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.m_183709_().m_132493_()));
                    this.f_9966_.m_129512_((Packet<?>)new ClientboundLoginDisconnectPacket((Component)component));
                    this.f_9966_.m_129507_((Component)component);
                    break;
                }
                this.f_9966_.m_129505_((PacketListener)new ServerLoginPacketListenerImpl(this.f_9965_, this.f_9966_));
                String[] split = p_9975_.f_134721_().split("\u0000");
                if (SpigotConfig.bungee) {
                    if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) {
                        MutableComponent chatmessage = Component.m_237113_("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                        this.f_9966_.m_129512_((Packet<?>)new ClientboundLoginDisconnectPacket((Component)chatmessage));
                        this.f_9966_.m_129507_((Component)chatmessage);
                        return;
                    }
                    this.f_9966_.hostname = split[0];
                    this.f_9966_.f_129469_ = new InetSocketAddress(split[1], ((InetSocketAddress)this.f_9966_.m_129523_()).getPort());
                    this.f_9966_.spoofedUUID = UndashedUuid.fromStringLenient((String)split[2]);
                    if (split.length != 4) break;
                    this.f_9966_.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                    break;
                }
                if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) break;
                MutableComponent chatmessage = Component.m_237113_("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.f_9966_.m_129512_((Packet<?>)new ClientboundLoginDisconnectPacket((Component)chatmessage));
                this.f_9966_.m_129507_((Component)chatmessage);
                return;
            }
            case STATUS: {
                ServerStatus serverstatus = this.f_9965_.m_129928_();
                if (this.f_9965_.m_6373_() && serverstatus != null) {
                    this.f_9966_.m_294993_(ClientIntent.STATUS);
                    this.f_9966_.m_129505_((PacketListener)new ServerStatusPacketListenerImpl(serverstatus, this.f_9966_, this.f_9965_.getStatusJson()));
                    break;
                }
                this.f_9966_.m_129507_(f_9964_);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf(p_9975_.f_134723_()));
            }
        }
    }

    public void m_7026_(Component p_9973_) {
    }

    public boolean m_6198_() {
        return this.f_9966_.m_129536_();
    }
}

