/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mohistmc.api.event.MohistServerListPingEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerStatusPacketListener;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.ServerStatusPing;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class ServerStatusPacketListenerImpl
implements ServerStatusPacketListener {
    private static final Component f_10081_ = Component.m_237115_("multiplayer.status.request_handled");
    private final ServerStatus f_271204_;
    @Nullable
    private final String statusCache;
    private final Connection f_10083_;
    private boolean f_10084_;

    public ServerStatusPacketListenerImpl(ServerStatus p_272864_, Connection p_273586_) {
        this(p_272864_, p_273586_, null);
    }

    public ServerStatusPacketListenerImpl(ServerStatus p_272864_, Connection p_273586_, @Nullable String statusCache) {
        this.f_271204_ = p_272864_;
        this.f_10083_ = p_273586_;
        this.statusCache = statusCache;
    }

    public void m_7026_(Component p_10091_) {
    }

    public boolean m_6198_() {
        return this.f_10083_.m_129536_();
    }

    public void m_6733_(ServerboundStatusRequestPacket p_10095_) {
        if (this.f_10084_) {
            this.f_10083_.m_129507_(f_10081_);
        } else {
            this.f_10084_ = true;
            MohistServerListPingEvent event = new MohistServerListPingEvent(this.f_10083_, MinecraftServer.getServer());
            Bukkit.getPluginManager().callEvent((Event)event);
            MinecraftServer server = MinecraftServer.getServer();
            Object[] players = event.getPlayers();
            List<Object> profiles = new ArrayList(players.length);
            for (Object player : players) {
                if (player == null) continue;
                ServerPlayer entityPlayer = (ServerPlayer)player;
                if (entityPlayer.m_184128_()) {
                    profiles.add(entityPlayer.m_36316_());
                    continue;
                }
                profiles.add(MinecraftServer.f_195496_);
            }
            if (!server.m_183306_() && !profiles.isEmpty()) {
                Collections.shuffle(profiles);
                profiles = profiles.subList(0, Math.min(profiles.size(), SpigotConfig.playerSample));
            }
            ServerStatus.Players playerSample = new ServerStatus.Players(event.getMaxPlayers(), event.getNumPlayers(), server.m_183306_() ? Collections.emptyList() : profiles);
            ServerStatus ping = new ServerStatus(CraftChatMessage.fromString((String)event.getMotd(), (boolean)true)[0], Optional.of(playerSample), Optional.of(new ServerStatus.Version(server.getServerModName() + " " + server.m_129786_(), SharedConstants.m_183709_().m_132495_())), event.icon.value != null ? Optional.of(new ServerStatus.Favicon(event.icon.value)) : Optional.empty(), server.m_214005_(), Optional.of(new ServerStatusPing()));
            this.f_10083_.m_129512_(new ClientboundStatusResponsePacket(ping));
        }
    }

    public void m_10092_(ServerboundPingRequestPacket p_10093_) {
        this.f_10083_.m_129512_((Packet<?>)new ClientboundPongResponsePacket(p_10093_.m_134998_()));
        this.f_10083_.m_129507_(f_10081_);
    }
}

