/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import org.slf4j.Logger;

public class VanillaPackResourcesBuilder {
    private static final Logger f_244501_ = LogUtils.getLogger();
    public static Consumer<VanillaPackResourcesBuilder> f_244395_ = p_251787_ -> {};
    private static final Map<PackType, Path> f_243987_ = (Map)Util.m_137537_(() -> {
        Class<VanillaPackResources> clazz = VanillaPackResources.class;
        synchronized (VanillaPackResources.class) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (PackType packtype : PackType.values()) {
                String s = "/" + packtype.m_10305_() + "/.mcassetsroot";
                URL url = VanillaPackResources.class.getResource(s);
                if (url == null) {
                    f_244501_.error("File {} does not exist in classpath", (Object)s);
                    continue;
                }
                try {
                    URI uri = url.toURI();
                    String s1 = uri.getScheme();
                    if (!"jar".equals(s1) && !"file".equals(s1)) {
                        f_244501_.debug("Assets URL '{}' uses unexpected schema", (Object)uri);
                    }
                    Path path = VanillaPackResourcesBuilder.m_246045_(uri);
                    builder.put((Object)packtype, (Object)path.getParent());
                }
                catch (Exception exception) {
                    f_244501_.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return builder.build();
        }
    });
    private final Set<Path> f_244434_ = new LinkedHashSet<Path>();
    private final Map<PackType, Set<Path>> f_243956_ = new EnumMap<PackType, Set<Path>>(PackType.class);
    private BuiltInMetadata f_243924_ = BuiltInMetadata.m_246355_();
    private final Set<String> f_244548_ = new HashSet<String>();

    private static Path m_246045_(URI p_248652_) throws IOException {
        try {
            return Paths.get(p_248652_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            f_244501_.warn("Unable to get path for: {}", (Object)p_248652_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_248652_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_248652_);
    }

    private boolean m_247040_(Path p_249112_) {
        if (!Files.exists(p_249112_, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(p_249112_, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + String.valueOf(p_249112_.toAbsolutePath()) + " is not directory");
        }
        return true;
    }

    private void m_245487_(Path p_251084_) {
        if (this.m_247040_(p_251084_)) {
            this.f_244434_.add(p_251084_);
        }
    }

    private void m_246356_(PackType p_250073_, Path p_252259_) {
        if (this.m_247040_(p_252259_)) {
            this.f_243956_.computeIfAbsent(p_250073_, p_250639_ -> new LinkedHashSet()).add(p_252259_);
        }
    }

    public VanillaPackResourcesBuilder m_246373_() {
        f_243987_.forEach((p_251514_, p_251979_) -> {
            this.m_245487_(p_251979_.getParent());
            this.m_246356_((PackType)p_251514_, (Path)p_251979_);
        });
        return this;
    }

    public VanillaPackResourcesBuilder m_246513_(PackType p_251987_, Class<?> p_249062_) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = p_249062_.getClassLoader().getResources(p_251987_.m_10305_() + "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            try {
                URI uri = url.toURI();
                if (!"file".equals(uri.getScheme())) continue;
                Path path = Paths.get(uri);
                this.m_245487_(path.getParent());
                this.m_246356_(p_251987_, path);
            }
            catch (Exception exception) {
                f_244501_.error("Failed to extract path from {}", (Object)url, (Object)exception);
            }
        }
        return this;
    }

    public VanillaPackResourcesBuilder m_246678_() {
        f_244395_.accept(this);
        return this;
    }

    public VanillaPackResourcesBuilder m_245630_(Path p_249464_) {
        this.m_245487_(p_249464_);
        for (PackType packtype : PackType.values()) {
            this.m_246356_(packtype, p_249464_.resolve(packtype.m_10305_()));
        }
        return this;
    }

    public VanillaPackResourcesBuilder m_246275_(PackType p_248623_, Path p_250065_) {
        this.m_245487_(p_250065_);
        this.m_246356_(p_248623_, p_250065_);
        return this;
    }

    public VanillaPackResourcesBuilder m_245913_(BuiltInMetadata p_249597_) {
        this.f_243924_ = p_249597_;
        return this;
    }

    public VanillaPackResourcesBuilder m_245371_(String ... p_250838_) {
        this.f_244548_.addAll(Arrays.asList(p_250838_));
        return this;
    }

    public VanillaPackResources m_245772_() {
        EnumMap<PackType, List<Path>> map = new EnumMap<PackType, List<Path>>(PackType.class);
        for (PackType packtype : PackType.values()) {
            List<Path> list = VanillaPackResourcesBuilder.m_247634_(this.f_243956_.getOrDefault(packtype, Set.of()));
            map.put(packtype, list);
        }
        return new VanillaPackResources(this.f_243924_, Set.copyOf(this.f_244548_), VanillaPackResourcesBuilder.m_247634_(this.f_244434_), map);
    }

    private static List<Path> m_247634_(Collection<Path> p_252072_) {
        ArrayList<Path> list = new ArrayList<Path>(p_252072_);
        Collections.reverse(list);
        return List.copyOf(list);
    }
}

