/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class Player
extends LivingEntity
implements IForgePlayer {
    public static final String PERSISTED_NBT_TAG = "PlayerPersisted";
    private static final Logger f_219722_ = LogUtils.getLogger();
    public static final int f_150082_ = 16;
    public static final HumanoidArm f_291841_ = HumanoidArm.RIGHT;
    public static final int f_290962_ = 0;
    public static final int f_150083_ = 20;
    public static final int f_150084_ = 100;
    public static final int f_150085_ = 10;
    public static final int f_150086_ = 200;
    public static final float f_150087_ = 1.5f;
    public static final float f_150088_ = 0.6f;
    public static final float f_150089_ = 0.6f;
    public static final float f_150090_ = 1.62f;
    public static final EntityDimensions f_36088_ = EntityDimensions.m_20395_((float)0.6f, (float)1.8f);
    private static final Map<Pose, EntityDimensions> f_36074_ = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)f_36088_).put((Object)Pose.SLEEPING, (Object)f_20910_).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntityDimensions.m_20398_((float)0.2f, (float)0.2f)).build();
    private static final int f_150091_ = 25;
    private static final EntityDataAccessor<Float> f_36107_ = SynchedEntityData.m_135353_(Player.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> f_36108_ = SynchedEntityData.m_135353_(Player.class, EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> f_36089_ = SynchedEntityData.m_135353_(Player.class, EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> f_36090_ = SynchedEntityData.m_135353_(Player.class, EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<CompoundTag> f_36091_ = SynchedEntityData.m_135353_(Player.class, EntityDataSerializers.f_135042_);
    protected static final EntityDataAccessor<CompoundTag> f_36092_ = SynchedEntityData.m_135353_(Player.class, EntityDataSerializers.f_135042_);
    private long f_36109_;
    private final Inventory f_36093_ = new Inventory(this);
    protected PlayerEnderChestContainer f_36094_ = new PlayerEnderChestContainer(this);
    public final InventoryMenu f_36095_;
    public AbstractContainerMenu f_36096_;
    protected FoodData f_36097_ = new FoodData(this);
    protected int f_36098_;
    public float f_36099_;
    public float f_36100_;
    public int f_36101_;
    public double f_36102_;
    public double f_36103_;
    public double f_36104_;
    public double f_36105_;
    public double f_36106_;
    public double f_36075_;
    public int f_36110_;
    protected boolean f_36076_;
    private final Abilities f_36077_ = new Abilities();
    public int f_36078_;
    public int f_36079_;
    public float f_36080_;
    public int f_36081_;
    protected final float f_36082_ = 0.02f;
    private int f_36111_;
    private final GameProfile f_36084_;
    private boolean f_36085_;
    private net.minecraft.world.item.ItemStack f_36086_ = net.minecraft.world.item.ItemStack.f_41583_;
    private final ItemCooldowns f_36087_ = this.m_7478_();
    private Optional<GlobalPos> f_238176_ = Optional.empty();
    @Nullable
    public FishingHook f_36083_;
    protected float f_263750_;
    private final Collection<MutableComponent> prefixes = new LinkedList<MutableComponent>();
    private final Collection<MutableComponent> suffixes = new LinkedList<MutableComponent>();
    @Nullable
    private Pose forcedPose;
    public boolean fauxSleeping;
    public int oldLevel = -1;
    public InventoryCloseEvent.Reason inventoryCloseReason = InventoryCloseEvent.Reason.PLAYER;
    public AtomicBoolean callEventA = new AtomicBoolean(true);
    protected AtomicBoolean startSleepInBed_force = new AtomicBoolean(false);
    private AtomicReference<EntityExhaustionEvent.ExhaustionReason> reason = new AtomicReference<EntityExhaustionEvent.ExhaustionReason>(EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    public AtomicBoolean spawnEntityFromShoulder = new AtomicBoolean(true);
    private Component displayname = null;
    private final LazyOptional<IItemHandler> playerMainHandler = LazyOptional.of(() -> new PlayerMainInvWrapper(this.f_36093_));
    private final LazyOptional<IItemHandler> playerEquipmentHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerArmorInvWrapper(this.f_36093_), new PlayerOffhandInvWrapper(this.f_36093_)}));
    private final LazyOptional<IItemHandler> playerJoinedHandler = LazyOptional.of(() -> new PlayerInvWrapper(this.f_36093_));

    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public Player(Level p_250508_, BlockPos p_250289_, float p_251702_, GameProfile p_252153_) {
        super((EntityType<? extends LivingEntity>)EntityType.f_20532_, p_250508_);
        this.m_20084_(p_252153_.getId());
        this.f_36084_ = p_252153_;
        this.f_36095_ = new InventoryMenu(this.f_36093_, !p_250508_.f_46443_, this);
        this.f_36096_ = this.f_36095_;
        this.m_7678_((double)p_250289_.m_123341_() + 0.5, p_250289_.m_123342_() + 1, (double)p_250289_.m_123343_() + 0.5, p_251702_, 0.0f);
        this.f_20896_ = 180.0f;
    }

    public boolean m_36187_(Level p_36188_, BlockPos p_36189_, GameType p_36190_) {
        if (!p_36190_.m_46407_()) {
            return false;
        }
        if (p_36190_ == GameType.SPECTATOR) {
            return true;
        }
        if (this.m_36326_()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.m_21205_();
        return itemstack.m_41619_() || !itemstack.m_204128_((Registry<Block>)p_36188_.m_9598_().m_175515_(Registries.f_256747_), new BlockInWorld((LevelReader)p_36188_, p_36189_, false));
    }

    public static AttributeSupplier.Builder m_36340_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.1f).m_22266_(Attributes.f_22283_).m_22266_(Attributes.f_22286_).m_22266_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22266_(Attributes.f_22282_).m_22266_((Attribute)ForgeMod.ENTITY_REACH.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_36107_, Float.valueOf(0.0f));
        this.f_19804_.m_135372_(f_36108_, 0);
        this.f_19804_.m_135372_(f_36089_, (byte)0);
        this.f_19804_.m_135372_(f_36090_, (byte)f_291841_.m_35965_());
        this.f_19804_.m_135372_(f_36091_, new CompoundTag());
        this.f_19804_.m_135372_(f_36092_, new CompoundTag());
    }

    @Override
    public void m_8119_() {
        ForgeEventFactory.onPlayerPreTick((Player)this);
        this.f_19794_ = this.m_5833_();
        if (this.m_5833_()) {
            this.m_6853_(false);
        }
        if (this.f_36101_ > 0) {
            --this.f_36101_;
        }
        if (this.m_5803_()) {
            ++this.f_36110_;
            if (this.f_36110_ > 100) {
                this.f_36110_ = 100;
            }
            if (!this.m_9236_().f_46443_ && !ForgeEventFactory.onSleepingTimeCheck((Player)this, this.m_21257_())) {
                this.m_6145_(false, true);
            }
        } else if (this.f_36110_ > 0) {
            ++this.f_36110_;
            if (this.f_36110_ >= 110) {
                this.f_36110_ = 0;
            }
        }
        this.m_7602_();
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_36096_ != null && !this.f_36096_.m_6875_(this)) {
            this.inventoryCloseReason = InventoryCloseEvent.Reason.CANT_USE;
            this.m_6915_();
            this.f_36096_ = this.f_36095_;
        }
        this.m_36377_();
        if (!this.m_9236_().f_46443_) {
            this.f_36097_.m_38710_(this);
            this.m_36220_(Stats.f_144255_);
            this.m_36220_(Stats.f_144256_);
            if (this.m_6084_()) {
                this.m_36220_(Stats.f_12991_);
            }
            if (this.m_20163_()) {
                this.m_36220_(Stats.f_12993_);
            }
            if (!this.m_5803_()) {
                this.m_36220_(Stats.f_12992_);
            }
        }
        int i = 29999999;
        double d0 = Mth.m_14008_((double)this.m_20185_(), (double)-2.9999999E7, (double)2.9999999E7);
        double d1 = Mth.m_14008_((double)this.m_20189_(), (double)-2.9999999E7, (double)2.9999999E7);
        if (d0 != this.m_20185_() || d1 != this.m_20189_()) {
            this.m_6034_(d0, this.m_20186_(), d1);
        }
        ++this.f_20922_;
        net.minecraft.world.item.ItemStack itemstack = this.m_21205_();
        if (!net.minecraft.world.item.ItemStack.m_41728_(this.f_36086_, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.m_41656_(this.f_36086_, itemstack)) {
                this.m_36334_();
            }
            this.f_36086_ = itemstack.m_41777_();
        }
        this.m_36372_();
        this.f_36087_.m_41518_();
        this.m_7594_();
        ForgeEventFactory.onPlayerPostTick((Player)this);
    }

    public boolean m_36341_() {
        return this.m_6144_();
    }

    protected boolean m_36342_() {
        return this.m_6144_();
    }

    protected boolean m_36343_() {
        return this.m_6144_();
    }

    protected boolean m_7602_() {
        this.f_36076_ = this.m_204029_(FluidTags.f_13131_);
        return this.f_36076_;
    }

    private void m_36372_() {
        net.minecraft.world.item.ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
        if (itemstack.m_150930_(Items.f_42354_) && !this.m_204029_(FluidTags.f_13131_)) {
            this.addEffect(new MobEffectInstance(MobEffects.f_19608_, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldowns m_7478_() {
        return new ItemCooldowns();
    }

    private void m_36377_() {
        this.f_36102_ = this.f_36105_;
        this.f_36103_ = this.f_36106_;
        this.f_36104_ = this.f_36075_;
        double d0 = this.m_20185_() - this.f_36105_;
        double d1 = this.m_20186_() - this.f_36106_;
        double d2 = this.m_20189_() - this.f_36075_;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.f_36102_ = this.f_36105_ = this.m_20185_();
        }
        if (d2 > 10.0) {
            this.f_36104_ = this.f_36075_ = this.m_20189_();
        }
        if (d1 > 10.0) {
            this.f_36103_ = this.f_36106_ = this.m_20186_();
        }
        if (d0 < -10.0) {
            this.f_36102_ = this.f_36105_ = this.m_20185_();
        }
        if (d2 < -10.0) {
            this.f_36104_ = this.f_36075_ = this.m_20189_();
        }
        if (d1 < -10.0) {
            this.f_36103_ = this.f_36106_ = this.m_20186_();
        }
        this.f_36105_ += d0 * 0.25;
        this.f_36075_ += d2 * 0.25;
        this.f_36106_ += d1 * 0.25;
    }

    protected void m_7594_() {
        if (this.forcedPose != null) {
            this.m_20124_(this.forcedPose);
            return;
        }
        if (this.m_295652_(Pose.SWIMMING)) {
            Pose pose = this.m_21255_() ? Pose.FALL_FLYING : (this.m_5803_() ? Pose.SLEEPING : (this.m_6069_() ? Pose.SWIMMING : (this.m_21209_() ? Pose.SPIN_ATTACK : (this.m_6144_() && !this.f_36077_.f_35935_ ? Pose.CROUCHING : Pose.STANDING))));
            Pose pose1 = !(this.m_5833_() || this.m_20159_() || this.m_295652_(pose)) ? (this.m_295652_(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING) : pose;
            this.m_20124_(pose1);
        }
    }

    protected boolean m_295652_(Pose p_297636_) {
        return this.m_9236_().m_45756_(this, this.m_6972_(p_297636_).m_20393_(this.m_20182_()).m_82406_(1.0E-7));
    }

    @Override
    public int m_6078_() {
        return this.f_36077_.f_35934_ ? 1 : 80;
    }

    @Override
    protected SoundEvent m_5501_() {
        return SoundEvents.f_12279_;
    }

    @Override
    protected SoundEvent m_5509_() {
        return SoundEvents.f_12277_;
    }

    @Override
    protected SoundEvent m_5508_() {
        return SoundEvents.f_12278_;
    }

    @Override
    public int m_6045_() {
        return 10;
    }

    @Override
    public void m_5496_(SoundEvent p_36137_, float p_36138_, float p_36139_) {
        this.m_9236_().m_6263_(this, this.m_20185_(), this.m_20186_(), this.m_20189_(), p_36137_, this.m_5720_(), p_36138_, p_36139_);
    }

    public void m_6330_(SoundEvent p_36140_, SoundSource p_36141_, float p_36142_, float p_36143_) {
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }

    @Override
    public int m_6101_() {
        return 20;
    }

    @Override
    public void m_7822_(byte p_36120_) {
        if (p_36120_ == 9) {
            this.m_8095_();
        } else if (p_36120_ == 23) {
            this.f_36085_ = false;
        } else if (p_36120_ == 22) {
            this.f_36085_ = true;
        } else if (p_36120_ == 43) {
            this.m_36208_((ParticleOptions)ParticleTypes.f_123796_);
        } else {
            super.m_7822_(p_36120_);
        }
    }

    private void m_36208_(ParticleOptions p_36209_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(p_36209_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_6915_() {
        this.f_36096_ = this.f_36095_;
    }

    protected void m_9230_() {
    }

    @Override
    public void m_6083_() {
        if (!this.m_9236_().f_46443_ && this.m_36342_() && this.m_20159_()) {
            this.m_8127_();
            if (!this.m_20159_()) {
                this.m_20260_(false);
                return;
            }
        }
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6083_();
        this.f_36099_ = this.f_36100_;
        this.f_36100_ = 0.0f;
        this.m_36387_(this.m_20185_() - d0, this.m_20186_() - d1, this.m_20189_() - d2);
    }

    @Override
    protected void m_6140_() {
        super.m_6140_();
        this.m_21203_();
        this.f_20885_ = this.m_146908_();
    }

    @Override
    public void m_8107_() {
        if (this.f_36098_ > 0) {
            --this.f_36098_;
        }
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_9236_().m_46469_().m_46207_(GameRules.f_46139_)) {
            if (this.m_21223_() < this.m_21233_() && this.f_19797_ % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.f_36097_.m_38721_() && this.f_19797_ % 10 == 0) {
                this.f_36097_.m_38705_(this.f_36097_.m_38702_() + 1);
            }
        }
        this.f_36093_.m_36068_();
        this.f_36099_ = this.f_36100_;
        super.m_8107_();
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
        float f = this.m_20096_() && !this.m_21224_() && !this.m_6069_() ? Math.min(0.1f, (float)this.m_20184_().m_165924_()) : 0.0f;
        this.f_36100_ += (f - this.f_36100_) * 0.4f;
        if (this.m_21223_() > 0.0f && !this.m_5833_()) {
            AABB aabb = this.m_20159_() && !this.m_20202_().m_213877_() ? this.m_20191_().m_82367_(this.m_20202_().m_20191_()).m_82377_(1.0, 0.0, 1.0) : this.m_20191_().m_82377_(1.0, 0.5, 1.0);
            List list = this.m_9236_().m_45933_(this, aabb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.m_6095_() == EntityType.f_20570_) {
                    list1.add(entity);
                    continue;
                }
                if (entity.m_213877_()) continue;
                this.m_36277_(entity);
            }
            if (!list1.isEmpty()) {
                this.m_36277_((Entity)Util.m_214621_(list1, this.f_19796_));
            }
        }
        this.m_36367_(this.m_36331_());
        this.m_36367_(this.m_36332_());
        if (!this.m_9236_().f_46443_ && (this.f_19789_ > 0.5f || this.m_20069_()) || this.f_36077_.f_35935_ || this.m_5803_() || this.f_146808_) {
            this.m_36328_();
        }
    }

    private void m_36367_(@Nullable CompoundTag p_36368_) {
        if (!(p_36368_ == null || p_36368_.m_128441_("Silent") && p_36368_.m_128471_("Silent") || this.m_9236_().f_46441_.m_188503_(200) != 0)) {
            String s = p_36368_.m_128461_("id");
            EntityType.m_20632_(s).filter(p_36280_ -> p_36280_ == EntityType.f_20508_).ifPresent(p_296855_ -> {
                if (!Parrot.m_29382_(this.m_9236_(), this)) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), Parrot.m_218238_(this.m_9236_(), this.m_9236_().f_46441_), this.m_5720_(), 1.0f, Parrot.m_218236_(this.m_9236_().f_46441_));
                }
            });
        }
    }

    private void m_36277_(Entity p_36278_) {
        p_36278_.m_6123_(this);
    }

    public int m_36344_() {
        return this.f_19804_.m_135370_(f_36108_);
    }

    public void m_36397_(int p_36398_) {
        this.f_19804_.m_135381_(f_36108_, p_36398_);
    }

    public void m_36401_(int p_36402_) {
        int i = this.m_36344_();
        this.f_19804_.m_135381_(f_36108_, i + p_36402_);
    }

    public void m_204079_(int p_204080_) {
        this.f_20938_ = p_204080_;
        if (!this.m_9236_().f_46443_) {
            this.m_36328_();
            this.m_21155_(4, true);
        }
    }

    @Override
    public void m_6667_(DamageSource p_36152_) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)p_36152_)) {
            return;
        }
        super.m_6667_(p_36152_);
        this.m_20090_();
        if (!this.m_5833_()) {
            this.m_6668_(p_36152_);
        }
        if (p_36152_ != null) {
            this.m_20334_(-Mth.m_14089_((float)((this.m_264297_() + this.m_146908_()) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -Mth.m_14031_((float)((this.m_264297_() + this.m_146908_()) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.m_20334_(0.0, 0.1, 0.0);
        }
        this.m_36220_(Stats.f_12935_);
        this.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
        this.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
        this.m_20095_();
        this.m_146868_(false);
        this.m_219749_(Optional.of(GlobalPos.m_122643_(this.m_9236_().m_46472_(), (BlockPos)this.m_20183_())));
    }

    @Override
    protected void m_5907_() {
        super.m_5907_();
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            this.m_36345_();
            this.f_36093_.m_36071_();
        }
    }

    protected void m_36345_() {
        for (int i = 0; i < this.f_36093_.m_6643_(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.f_36093_.m_8020_(i);
            if (itemstack.m_41619_() || !EnchantmentHelper.m_44924_(itemstack)) continue;
            this.f_36093_.m_8016_(i);
        }
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_36310_) {
        return p_36310_.m_269415_().f_268686_().m_269402_();
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    @Nullable
    public ItemEntity m_36176_(net.minecraft.world.item.ItemStack p_36177_, boolean p_36178_) {
        return ForgeHooks.onPlayerTossEvent((Player)this, (net.minecraft.world.item.ItemStack)p_36177_, (boolean)p_36178_);
    }

    @Nullable
    public ItemEntity drop(net.minecraft.world.item.ItemStack pDroppedItem, boolean pDropAround, boolean pIncludeThrowerName, boolean callEven) {
        this.callEventA.set(callEven);
        return this.m_7197_(pDroppedItem, pDropAround, pIncludeThrowerName);
    }

    @Nullable
    public ItemEntity m_7197_(net.minecraft.world.item.ItemStack p_36179_, boolean p_36180_, boolean p_36181_) {
        if (p_36179_.m_41619_()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
        double d0 = this.m_20188_() - (double)0.3f;
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), d0, this.m_20189_(), p_36179_);
        itementity.m_32010_(40);
        if (p_36181_) {
            itementity.m_32052_(this.m_20148_());
        }
        if (p_36180_) {
            float f = this.f_19796_.m_188501_() * 0.5f;
            float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            itementity.m_20334_(-Mth.m_14031_((float)f1) * f, 0.2f, Mth.m_14089_((float)f1) * f);
        } else {
            float f7 = 0.3f;
            float f8 = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f4 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f5 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.f_19796_.m_188501_();
            itementity.m_20334_((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f8 * 0.3f + 0.1f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (this.callEventA.getAndSet(true)) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)this.getBukkitEntity();
            Item drop = (Item)itementity.getBukkitEntity();
            PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
            this.f_19853_.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                MapItemSavedData worldmap;
                if (p_36179_.m_41720_() == Items.f_42573_ && (worldmap = MapItem.m_42853_(p_36179_, this.m_9236_())) != null) {
                    worldmap.m_77918_(this, p_36179_);
                }
                return itementity;
            }
            ItemStack cur = player.getInventory().getItemInHand();
            if (p_36181_ && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (p_36181_ && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        return itementity;
    }

    @Deprecated
    public float m_36281_(BlockState p_36282_) {
        return this.getDigSpeed(p_36282_, null);
    }

    public float getDigSpeed(BlockState p_36282_, @Nullable BlockPos pos) {
        float f = this.f_36093_.m_36020_(p_36282_);
        if (f > 1.0f) {
            int i = EnchantmentHelper.m_44926_(this);
            net.minecraft.world.item.ItemStack itemstack = this.m_21205_();
            if (i > 0 && !itemstack.m_41619_()) {
                f += (float)(i * i + 1);
            }
        }
        if (MobEffectUtil.m_19584_(this)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_(this) + 1) * 0.2f;
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            f *= (switch (this.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (this.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_(this)) {
            f /= 5.0f;
        }
        if (!this.m_20096_()) {
            f /= 5.0f;
        }
        f = ForgeEventFactory.getBreakSpeed((Player)this, (BlockState)p_36282_, (float)f, (BlockPos)pos);
        return f;
    }

    public boolean m_36298_(BlockState p_36299_) {
        return ForgeEventFactory.doPlayerHarvestCheck((Player)this, (BlockState)p_36299_, (!p_36299_.m_60834_() || this.f_36093_.m_36056_().m_41735_(p_36299_) ? 1 : 0) != 0);
    }

    @Override
    public void m_7378_(CompoundTag p_36215_) {
        super.m_7378_(p_36215_);
        this.m_20084_(this.f_36084_.getId());
        ListTag listtag = p_36215_.m_128437_("Inventory", 10);
        this.f_36093_.m_36035_(listtag);
        this.f_36093_.f_35977_ = p_36215_.m_128451_("SelectedItemSlot");
        this.f_36110_ = p_36215_.m_128448_("SleepTimer");
        this.f_36080_ = p_36215_.m_128457_("XpP");
        this.f_36078_ = p_36215_.m_128451_("XpLevel");
        this.f_36079_ = p_36215_.m_128451_("XpTotal");
        this.f_36081_ = p_36215_.m_128451_("XpSeed");
        if (this.f_36081_ == 0) {
            this.f_36081_ = this.f_19796_.m_188502_();
        }
        this.m_36397_(p_36215_.m_128451_("Score"));
        this.f_36097_.m_38715_(p_36215_);
        this.f_36077_.m_35950_(p_36215_);
        this.m_21051_(Attributes.f_22279_).m_22100_(this.f_36077_.m_35947_());
        if (p_36215_.m_128425_("EnderItems", 9)) {
            this.f_36094_.m_7797_(p_36215_.m_128437_("EnderItems", 10));
        }
        if (p_36215_.m_128425_("ShoulderEntityLeft", 10)) {
            this.m_36362_(p_36215_.m_128469_("ShoulderEntityLeft"));
        }
        if (p_36215_.m_128425_("ShoulderEntityRight", 10)) {
            this.m_36364_(p_36215_.m_128469_("ShoulderEntityRight"));
        }
        if (p_36215_.m_128425_("LastDeathLocation", 10)) {
            this.m_219749_(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_36215_.m_128423_("LastDeathLocation")).resultOrPartial(arg_0 -> ((Logger)f_219722_).error(arg_0)));
        }
    }

    @Override
    public void m_7380_(CompoundTag p_36265_) {
        super.m_7380_(p_36265_);
        NbtUtils.m_264171_((CompoundTag)p_36265_);
        p_36265_.m_128365_("Inventory", (Tag)this.f_36093_.m_36026_(new ListTag()));
        p_36265_.m_128405_("SelectedItemSlot", this.f_36093_.f_35977_);
        p_36265_.m_128376_("SleepTimer", (short)this.f_36110_);
        p_36265_.m_128350_("XpP", this.f_36080_);
        p_36265_.m_128405_("XpLevel", this.f_36078_);
        p_36265_.m_128405_("XpTotal", this.f_36079_);
        p_36265_.m_128405_("XpSeed", this.f_36081_);
        p_36265_.m_128405_("Score", this.m_36344_());
        this.f_36097_.m_38719_(p_36265_);
        this.f_36077_.m_35945_(p_36265_);
        p_36265_.m_128365_("EnderItems", (Tag)this.f_36094_.m_7927_());
        if (!this.m_36331_().m_128456_()) {
            p_36265_.m_128365_("ShoulderEntityLeft", this.m_36331_());
        }
        if (!this.m_36332_().m_128456_()) {
            p_36265_.m_128365_("ShoulderEntityRight", this.m_36332_());
        }
        this.m_219759_().flatMap(p_219745_ -> GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, p_219745_).resultOrPartial(arg_0 -> ((Logger)f_219722_).error(arg_0))).ifPresent(p_219756_ -> p_36265_.m_128365_("LastDeathLocation", (Tag)p_219756_));
    }

    @Override
    public boolean m_6673_(DamageSource p_36249_) {
        if (super.m_6673_(p_36249_)) {
            return true;
        }
        if (p_36249_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268581_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_46121_);
        }
        if (p_36249_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268549_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_46122_);
        }
        if (p_36249_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268745_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_46123_);
        }
        if (p_36249_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268419_)) {
            return !this.m_9236_().m_46469_().m_46207_(GameRules.f_151485_);
        }
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource p_36154_, float p_36155_) {
        boolean damaged;
        if (!ForgeHooks.onPlayerAttack((LivingEntity)this, (DamageSource)p_36154_, (float)p_36155_)) {
            return false;
        }
        if (this.m_6673_(p_36154_)) {
            return false;
        }
        if (this.f_36077_.f_35934_ && !p_36154_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268738_)) {
            return false;
        }
        this.f_20891_ = 0;
        if (this.m_21224_()) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
        if (p_36154_.m_7986_()) {
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            if (this.f_19853_.m_46791_() == Difficulty.EASY) {
                p_36155_ = Math.min(p_36155_ / 2.0f + 1.0f, p_36155_);
            }
            if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                p_36155_ = p_36155_ * 3.0f / 2.0f;
            }
        }
        if (damaged = super.m_6469_(p_36154_, p_36155_)) {
            this.m_36328_();
        }
        return damaged;
    }

    @Override
    protected void m_6728_(LivingEntity p_36295_) {
        super.m_6728_(p_36295_);
        if (p_36295_.m_21205_().canDisableShield(this.f_20935_, this, p_36295_)) {
            this.m_36384_(true);
        }
    }

    @Override
    public boolean m_142066_() {
        return !this.m_150110_().f_35934_ && super.m_142066_();
    }

    public boolean m_7099_(Player p_36169_) {
        Team team;
        if (p_36169_ instanceof ServerPlayer) {
            ServerPlayer thatPlayer = (ServerPlayer)p_36169_;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = p_36169_.f_19853_.getCraftServer().getOfflinePlayer(p_36169_.m_6302_());
            team = p_36169_.f_19853_.getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof ServerPlayer) {
            return !team.hasPlayer((OfflinePlayer)((ServerPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.f_19853_.getCraftServer().getOfflinePlayer(this.m_6302_()));
    }

    @Override
    protected void m_6472_(DamageSource p_36251_, float p_36252_) {
        this.f_36093_.m_150072_(p_36251_, p_36252_, Inventory.f_150068_);
    }

    @Override
    protected void m_142642_(DamageSource p_150103_, float p_150104_) {
        this.f_36093_.m_150072_(p_150103_, p_150104_, Inventory.f_150069_);
    }

    @Override
    protected void m_7909_(float p_36383_) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            if (!this.m_9236_().f_46443_) {
                this.m_36246_(Stats.f_12982_.m_12902_((Object)this.f_20935_.m_41720_()));
            }
            if (p_36383_ >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)p_36383_);
                InteractionHand interactionhand = this.m_7655_();
                this.f_20935_.m_41622_(i, this, p_219739_ -> {
                    p_219739_.m_21190_(interactionhand);
                    ForgeEventFactory.onPlayerDestroyItem((Player)this, (net.minecraft.world.item.ItemStack)this.f_20935_, (InteractionHand)interactionhand);
                    this.m_5810_();
                });
                if (this.f_20935_.m_41619_()) {
                    if (interactionhand == InteractionHand.MAIN_HAND) {
                        this.m_8061_(EquipmentSlot.MAINHAND, net.minecraft.world.item.ItemStack.f_41583_);
                    } else {
                        this.m_8061_(EquipmentSlot.OFFHAND, net.minecraft.world.item.ItemStack.f_41583_);
                    }
                    this.f_20935_ = net.minecraft.world.item.ItemStack.f_41583_;
                    this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean damageEntity0(DamageSource damagesource, float f) {
        return super.damageEntity0(damagesource, f);
    }

    @Override
    protected void m_6475_(DamageSource p_36312_, float p_36313_) {
        if (!this.m_6673_(p_36312_)) {
            ServerPlayer serverPlayer;
            Entity entity;
            float f3;
            Function blocking;
            boolean human = this instanceof Player;
            if ((p_36313_ = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)p_36312_, (float)p_36313_)) < 0.0f) {
                this.canDamage.set(true);
                return;
            }
            float originalDamage = p_36313_;
            Function hardHat = f -> {
                if (p_36312_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268627_) && !this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                    return -(f - f * 0.75);
                }
                return -0.0;
            };
            float hardHatModifier = ((Double)hardHat.apply((Object)p_36313_)).floatValue();
            p_36313_ += hardHatModifier;
            boolean shieldTakesDamage = false;
            if (this.m_21275_(p_36312_)) {
                ShieldBlockEvent shieldEvent = ForgeEventFactory.onShieldBlock((LivingEntity)this, (DamageSource)p_36312_, (float)p_36313_);
                if (!shieldEvent.isCanceled()) {
                    float blocked = shieldEvent.getBlockedDamage();
                    shieldTakesDamage = shieldEvent.shieldTakesDamage();
                    blocking = f13 -> -((double)blocked);
                } else {
                    blocking = f13 -> 0.0;
                }
            } else {
                blocking = f13 -> 0.0;
            }
            float blockingModifier = ((Double)blocking.apply((Object)p_36313_)).floatValue();
            Function armor = f -> -(f - (double)this.m_21161_(p_36312_, f.floatValue()));
            float armorModifier = ((Double)armor.apply((Object)(p_36313_ += blockingModifier))).floatValue();
            Function resistance = f -> {
                if (!p_36312_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268437_) && this.m_21023_(MobEffects.f_19606_) && !p_36312_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268630_)) {
                    int i = (this.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5;
                    int j = 25 - i;
                    float f1 = f.floatValue() * (float)j;
                    return -(f - (double)(f1 / 25.0f));
                }
                return -0.0;
            };
            float resistanceModifier = ((Double)resistance.apply((Object)(p_36313_ += armorModifier))).floatValue();
            float mohist = this.m_6515_(p_36312_, p_36313_ += resistanceModifier);
            float magicModifier = -(p_36313_ - mohist);
            Function magic = f -> magicModifier;
            Function absorption = f -> -Math.max(f - Math.max(f - (double)this.m_6103_(), 0.0), 0.0);
            float absorptionModifier = ((Double)absorption.apply((Object)(p_36313_ += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent((Entity)this, (DamageSource)p_36312_, (double)originalDamage, (double)hardHatModifier, (double)blockingModifier, (double)armorModifier, (double)resistanceModifier, (double)magicModifier, (double)absorptionModifier, (Function)hardHat, (Function)blocking, (Function)armor, (Function)resistance, (Function)magic, (Function)absorption);
            if (p_36312_.m_7639_() instanceof Player) {
                ((Player)p_36312_.m_7639_()).m_36334_();
            }
            if (event.isCancelled()) {
                this.canDamage.set(false);
                return;
            }
            p_36313_ = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof ServerPlayer) {
                    ((ServerPlayer)this).m_36222_(Stats.f_12934_, Math.round(f3 * 10.0f));
                } else {
                    entity = p_36312_.m_7639_();
                    if (entity instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)entity;
                        serverPlayer.m_36222_(Stats.f_12930_, Math.round(f3 * 10.0f));
                    }
                }
            }
            if (p_36312_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268627_) && !this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                this.m_142642_(p_36312_, p_36313_);
            }
            if (!p_36312_.m_269533_((TagKey<DamageType>)DamageTypeTags.f_268490_)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.m_6472_(p_36312_, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                Entity entity2;
                this.m_9236_().m_7605_(this, (byte)29);
                if (shieldTakesDamage) {
                    this.m_7909_((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                }
                if ((entity2 = p_36312_.m_7640_()) instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity2;
                    this.m_6728_(living);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.m_7911_(Math.max(this.m_6103_() - absorptionModifier, 0.0f));
            float f2 = absorptionModifier;
            if (f2 > 0.0f && f2 < 3.4028235E37f && this instanceof Player) {
                this.m_36222_(Stats.f_12933_, Math.round(f2 * 10.0f));
            }
            if (f2 > 0.0f && f2 < 3.4028235E37f && p_36312_.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)p_36312_.m_7639_()).m_36222_(Stats.f_12929_, Math.round(f2 * 10.0f));
            }
            if ((p_36313_ = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)p_36312_, (float)p_36313_)) > 0.0f || !human) {
                if (human) {
                    this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    this.m_36399_(p_36312_.m_19377_());
                    if (p_36313_ < 3.4028235E37f) {
                        this.m_36222_(Stats.f_12931_, Math.round(p_36313_ * 10.0f));
                    }
                }
                float f1 = this.m_21223_();
                this.m_21231_().m_289194_(p_36312_, p_36313_);
                this.m_21153_(f1 - p_36313_);
                if (!human) {
                    this.m_7911_(this.m_6103_() - p_36313_);
                }
                this.m_146852_(GameEvent.f_223706_, p_36312_.m_7639_());
                this.canDamage.set(true);
                return;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                entity = this;
                if (entity instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity;
                    CriteriaTriggers.f_10574_.m_35174_(serverPlayer, p_36312_, p_36313_, originalDamage, true);
                    f2 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f2 > 0.0f && f2 < 3.4028235E37f) {
                        serverPlayer.m_36222_(Stats.f_12932_, Math.round(originalDamage * 10.0f));
                    }
                }
                if ((entity = p_36312_.m_7639_()) instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity;
                    CriteriaTriggers.f_10573_.m_60112_(serverPlayer, (Entity)this, p_36312_, p_36313_, originalDamage, true);
                }
                this.canDamage.set(false);
                return;
            }
            boolean flag = originalDamage > 0.0f;
            this.canDamage.set(flag);
            return;
        }
        this.canDamage.set(false);
    }

    @Override
    protected boolean m_6046_() {
        return !this.f_36077_.f_35935_ && super.m_6046_();
    }

    public boolean m_143387_() {
        return false;
    }

    public void m_7739_(SignBlockEntity p_36193_, boolean p_277837_) {
    }

    public void m_7907_(BaseCommandBlock p_36182_) {
    }

    public void m_7698_(CommandBlockEntity p_36191_) {
    }

    public void m_5966_(StructureBlockEntity p_36194_) {
    }

    public void m_7569_(JigsawBlockEntity p_36192_) {
    }

    public void m_6658_(AbstractHorse p_36167_, Container p_36168_) {
    }

    public OptionalInt m_5893_(@Nullable MenuProvider p_36150_) {
        return OptionalInt.empty();
    }

    public void m_7662_(int p_36121_, MerchantOffers p_36122_, int p_36123_, int p_36124_, boolean p_36125_, boolean p_36126_) {
    }

    public void m_6986_(net.minecraft.world.item.ItemStack p_36174_, InteractionHand p_36175_) {
    }

    public InteractionResult m_36157_(Entity p_36158_, InteractionHand p_36159_) {
        if (this.m_5833_()) {
            if (p_36158_ instanceof MenuProvider) {
                this.m_5893_((MenuProvider)p_36158_);
            }
            return InteractionResult.PASS;
        }
        InteractionResult cancelResult = ForgeHooks.onInteractEntity((Player)this, (Entity)p_36158_, (InteractionHand)p_36159_);
        if (cancelResult != null) {
            return cancelResult;
        }
        net.minecraft.world.item.ItemStack itemstack = this.m_21120_(p_36159_);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.m_41777_();
        InteractionResult interactionresult = p_36158_.m_6096_(this, p_36159_);
        if (interactionresult.m_19077_()) {
            if (this.f_36077_.f_35937_ && itemstack == this.m_21120_(p_36159_) && itemstack.m_41613_() < itemstack1.m_41613_()) {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
            if (!this.f_36077_.f_35937_ && itemstack.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)this, (net.minecraft.world.item.ItemStack)itemstack1, (InteractionHand)p_36159_);
            }
            return interactionresult;
        }
        if (!itemstack.m_41619_() && p_36158_ instanceof LivingEntity) {
            InteractionResult interactionresult1;
            if (this.f_36077_.f_35937_) {
                itemstack = itemstack1;
            }
            if ((interactionresult1 = itemstack.m_41647_(this, (LivingEntity)p_36158_, p_36159_)).m_19077_()) {
                this.m_9236_().m_214171_(GameEvent.f_223708_, p_36158_.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
                if (itemstack.m_41619_() && !this.f_36077_.f_35937_) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)this, (net.minecraft.world.item.ItemStack)itemstack1, (InteractionHand)p_36159_);
                    this.m_21008_(p_36159_, net.minecraft.world.item.ItemStack.f_41583_);
                }
                return interactionresult1;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected float m_292595_(Entity p_297381_) {
        return -0.6f;
    }

    @Override
    public void m_6038_() {
        super.m_6038_();
        this.f_19851_ = 0;
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.m_5803_();
    }

    @Override
    public boolean m_6129_() {
        return !this.f_36077_.f_35935_;
    }

    @Override
    protected Vec3 m_5763_(Vec3 p_36201_, MoverType p_36202_) {
        if (!this.f_36077_.f_35935_ && p_36201_.f_82480_ <= 0.0 && (p_36202_ == MoverType.SELF || p_36202_ == MoverType.PLAYER) && this.m_36343_() && this.m_36386_()) {
            double d0 = p_36201_.f_82479_;
            double d1 = p_36201_.f_82481_;
            double d2 = 0.05;
            while (d0 != 0.0 && this.m_9236_().m_45756_(this, this.m_20191_().m_82386_(d0, (double)(-this.m_274421_()), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.m_9236_().m_45756_(this, this.m_20191_().m_82386_(0.0, (double)(-this.m_274421_()), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.m_9236_().m_45756_(this, this.m_20191_().m_82386_(d0, (double)(-this.m_274421_()), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            p_36201_ = new Vec3(d0, p_36201_.f_82480_, d1);
        }
        return p_36201_;
    }

    private boolean m_36386_() {
        return this.m_20096_() || this.f_19789_ < this.m_274421_() && !this.m_9236_().m_45756_(this, this.m_20191_().m_82386_(0.0, (double)(this.f_19789_ - this.m_274421_()), 0.0));
    }

    public void m_5706_(Entity p_36347_) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)this, (Entity)p_36347_)) {
            return;
        }
        if (p_36347_.m_6097_() && !p_36347_.m_7313_(this)) {
            float f = (float)this.m_21133_(Attributes.f_22281_);
            float f1 = p_36347_ instanceof LivingEntity ? EnchantmentHelper.m_44833_(this.m_21205_(), ((LivingEntity)p_36347_).m_6336_()) : EnchantmentHelper.m_44833_(this.m_21205_(), MobType.f_21640_);
            float f2 = this.m_36403_(0.5f);
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                float i = (float)this.m_21133_(Attributes.f_22282_);
                i += (float)EnchantmentHelper.m_44894_(this);
                if (this.m_20142_() && flag) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12314_, this.m_5720_(), 1.0f, 1.0f);
                    i += 1.0f;
                    flag1 = true;
                }
                boolean flag2 = flag && this.f_19789_ > 0.0f && !this.m_20096_() && !this.m_6147_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19610_) && !this.m_20159_() && p_36347_ instanceof LivingEntity;
                flag2 = flag2 && !this.m_20142_();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)this, (Entity)p_36347_, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                boolean bl = flag2 = hitResult != null;
                if (flag2) {
                    f *= hitResult.getDamageModifier();
                }
                f += f1;
                boolean flag3 = false;
                double d0 = this.f_19787_ - this.f_19867_;
                if (flag && !flag2 && !flag1 && this.m_20096_() && d0 < (double)this.m_6113_()) {
                    net.minecraft.world.item.ItemStack itemstack = this.m_21120_(InteractionHand.MAIN_HAND);
                    flag3 = itemstack.canPerformAction(ToolActions.SWORD_SWEEP);
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.m_44914_(this);
                if (p_36347_ instanceof LivingEntity) {
                    f4 = ((LivingEntity)p_36347_).m_21223_();
                    if (j > 0 && !p_36347_.m_6060_()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)p_36347_.getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent((Event)combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag4 = true;
                            p_36347_.setSecondsOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vec3 vec3 = p_36347_.m_20184_();
                boolean flag5 = p_36347_.m_6469_(this.m_269291_().m_269075_(this), f);
                if (flag5) {
                    if (i > 0.0f) {
                        if (p_36347_ instanceof LivingEntity) {
                            ((LivingEntity)p_36347_).m_147240_(i * 0.5f, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))));
                        } else {
                            p_36347_.m_5997_(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f, 0.1, Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f);
                        }
                        this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        this.m_6858_(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.m_44821_(this) * f;
                        for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(this, p_36347_))) {
                            double entityReachSq = Mth.m_144952_((double)this.getEntityReach());
                            if (livingentity == this || livingentity == p_36347_ || this.m_7307_(livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(this.m_20280_(livingentity) < entityReachSq) || !livingentity.m_6469_(this.m_269291_().m_269075_(this).sweep(), f3)) continue;
                            livingentity.m_147240_(0.4f, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))));
                        }
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, 1.0f);
                        this.m_36346_();
                    }
                    if (p_36347_ instanceof ServerPlayer && p_36347_.f_19864_) {
                        boolean cancelled = false;
                        org.bukkit.entity.Player player = (org.bukkit.entity.Player)p_36347_.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit((Vec3)vec3);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((ServerPlayer)p_36347_).f_8906_.m_141995_((Packet<?>)new ClientboundSetEntityMotionPacket(p_36347_));
                            p_36347_.f_19864_ = false;
                            p_36347_.m_20256_(vec3);
                        }
                    }
                    if (flag2) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, this.m_5720_(), 1.0f, 1.0f);
                        this.m_5704_(p_36347_);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12316_, this.m_5720_(), 1.0f, 1.0f);
                        } else {
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12318_, this.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.m_5700_(p_36347_);
                    }
                    this.m_21335_(p_36347_);
                    if (p_36347_ instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)p_36347_, this);
                    }
                    EnchantmentHelper.m_44896_(this, p_36347_);
                    net.minecraft.world.item.ItemStack itemstack1 = this.m_21205_();
                    Entity entity = p_36347_;
                    if (p_36347_ instanceof PartEntity) {
                        entity = ((PartEntity)p_36347_).getParent();
                    }
                    if (!this.m_9236_().f_46443_ && !itemstack1.m_41619_() && entity instanceof LivingEntity) {
                        net.minecraft.world.item.ItemStack copy = itemstack1.m_41777_();
                        itemstack1.m_41640_((LivingEntity)entity, this);
                        if (itemstack1.m_41619_()) {
                            ForgeEventFactory.onPlayerDestroyItem((Player)this, (net.minecraft.world.item.ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                            this.m_21008_(InteractionHand.MAIN_HAND, net.minecraft.world.item.ItemStack.f_41583_);
                        }
                    }
                    if (p_36347_ instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)p_36347_).m_21223_();
                        this.m_36222_(Stats.f_12928_, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), j * 4);
                            Bukkit.getPluginManager().callEvent((Event)combustEvent);
                            if (!combustEvent.isCancelled()) {
                                entity.setSecondsOnFire(combustEvent.getDuration(), false);
                            }
                        }
                        if (this.m_9236_() instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)this.m_9236_()).m_8767_(ParticleTypes.f_123798_, p_36347_.m_20185_(), p_36347_.m_20227_(0.5), p_36347_.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.ATTACK);
                    this.m_36399_(this.m_9236_().spigotConfig.combatExhaustion);
                } else {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12315_, this.m_5720_(), 1.0f, 1.0f);
                    if (flag4) {
                        p_36347_.m_20095_();
                    }
                    if (this instanceof ServerPlayer) {
                        ((ServerPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    @Override
    protected void m_6727_(LivingEntity p_36355_) {
        this.m_5706_(p_36355_);
    }

    public void m_36384_(boolean p_36385_) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_(this) * 0.05f;
        if (p_36385_) {
            f += 0.75f;
        }
        if (this.f_19796_.m_188501_() < f) {
            this.m_36335_().m_41524_(this.m_21211_().m_41720_(), 100);
            this.m_5810_();
            this.m_9236_().m_7605_(this, (byte)30);
        }
    }

    public void m_5704_(Entity p_36156_) {
    }

    public void m_5700_(Entity p_36253_) {
    }

    public void m_36346_() {
        double d0 = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        double d1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_(ParticleTypes.f_123766_, this.m_20185_() + d0, this.m_20227_(0.5), this.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void m_7583_() {
    }

    @Override
    public void m_142687_(Entity.RemovalReason p_150097_) {
        super.m_142687_(p_150097_);
        this.f_36095_.m_6877_(this);
        if (this.f_36096_ != null && this.m_242612_()) {
            this.m_9230_();
        }
    }

    public boolean m_7578_() {
        return false;
    }

    public GameProfile m_36316_() {
        return this.f_36084_;
    }

    public Inventory m_150109_() {
        return this.f_36093_;
    }

    public Abilities m_150110_() {
        return this.f_36077_;
    }

    public void m_141945_(net.minecraft.world.item.ItemStack p_150098_, net.minecraft.world.item.ItemStack p_150099_, ClickAction p_150100_) {
    }

    public boolean m_242612_() {
        return this.f_36096_ != this.f_36095_;
    }

    public Player forceSleepInBed(boolean force) {
        this.startSleepInBed_force.set(force);
        return this;
    }

    public Either<BedSleepingProblem, Unit> m_7720_(BlockPos p_36203_) {
        this.m_5802_(p_36203_);
        this.f_36110_ = 0;
        return Either.right((Object)Unit.INSTANCE);
    }

    public void m_6145_(boolean p_36226_, boolean p_36227_) {
        ForgeEventFactory.onPlayerWakeup((Player)this, (boolean)p_36226_, (boolean)p_36227_);
        super.m_5796_();
        if (this.m_9236_() instanceof ServerLevel && p_36227_) {
            ((ServerLevel)this.m_9236_()).m_8878_();
        }
        this.f_36110_ = p_36226_ ? 0 : 100;
    }

    @Override
    public void m_5796_() {
        this.m_6145_(true, true);
    }

    public static Optional<Vec3> m_36130_(ServerLevel p_36131_, BlockPos p_36132_, float p_36133_, boolean p_36134_, boolean p_36135_) {
        BlockState blockstate = p_36131_.m_8055_(p_36132_);
        Block block = blockstate.m_60734_();
        if (block instanceof RespawnAnchorBlock && (p_36134_ || (Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0) && RespawnAnchorBlock.m_55850_(p_36131_)) {
            Optional<Vec3> optional = RespawnAnchorBlock.m_55839_(EntityType.f_20532_, p_36131_, p_36132_);
            if (!p_36134_ && !p_36135_ && optional.isPresent()) {
                p_36131_.m_7731_(p_36132_, (BlockState)((Object)blockstate.m_61124_((Property)RespawnAnchorBlock.f_55833_, Integer.valueOf((Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) - 1))), 3);
            }
            return optional;
        }
        if (block instanceof BedBlock && BedBlock.m_49488_(p_36131_)) {
            return BedBlock.m_260958_(EntityType.f_20532_, p_36131_, p_36132_, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), p_36133_);
        }
        if (!p_36134_) {
            return blockstate.getRespawnPosition(EntityType.f_20532_, p_36131_, p_36132_, p_36133_, null);
        }
        boolean flag = block.m_48673_(blockstate);
        BlockState blockstate1 = p_36131_.m_8055_(p_36132_.m_7494_());
        boolean flag1 = blockstate1.m_60734_().m_48673_(blockstate1);
        return flag && flag1 ? Optional.of(new Vec3((double)p_36132_.m_123341_() + 0.5, (double)p_36132_.m_123342_() + 0.1, (double)p_36132_.m_123343_() + 0.5)) : Optional.empty();
    }

    public boolean m_36317_() {
        return this.m_5803_() && this.f_36110_ >= 100;
    }

    public int m_36318_() {
        return this.f_36110_;
    }

    public void m_5661_(Component p_36216_, boolean p_36217_) {
    }

    public void m_36220_(ResourceLocation p_36221_) {
        this.m_36246_(Stats.f_12988_.m_12902_((Object)p_36221_));
    }

    public void m_36222_(ResourceLocation p_36223_, int p_36224_) {
        this.m_6278_(Stats.f_12988_.m_12902_((Object)p_36223_), p_36224_);
    }

    public void m_36246_(Stat<?> p_36247_) {
        this.m_6278_(p_36247_, 1);
    }

    public void m_6278_(Stat<?> p_36145_, int p_36146_) {
    }

    public void m_7166_(Stat<?> p_36144_) {
    }

    public int m_7281_(Collection<RecipeHolder<?>> p_36213_) {
        return 0;
    }

    public void m_280300_(RecipeHolder<?> p_298309_, List<net.minecraft.world.item.ItemStack> p_283609_) {
    }

    public void m_7902_(ResourceLocation[] p_36228_) {
    }

    public int m_7279_(Collection<RecipeHolder<?>> p_36263_) {
        return 0;
    }

    @Override
    public void m_6135_() {
        super.m_6135_();
        this.m_36220_(Stats.f_12926_);
        if (this.m_20142_()) {
            this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
            this.m_36399_(0.2f);
        } else {
            this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.JUMP);
            this.m_36399_(0.05f);
        }
    }

    @Override
    public void m_7023_(Vec3 p_36359_) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        if (this.m_6069_() && !this.m_20159_()) {
            double d4;
            double d3 = this.m_20154_().f_82480_;
            double d = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.f_20899_ || !this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 1.0 - 0.1), (double)this.m_20189_())).m_60819_().m_76178_()) {
                Vec3 vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_(0.0, (d3 - vec3.f_82480_) * d4, 0.0));
            }
        }
        if (this.f_36077_.f_35935_ && !this.m_20159_()) {
            double d5 = this.m_20184_().f_82480_;
            super.m_7023_(p_36359_);
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, d5 * 0.6, vec31.f_82481_);
            this.m_183634_();
            if (this.m_20291_(7) && !CraftEventFactory.callToggleGlideEvent((LivingEntity)this, (boolean)false).isCancelled()) {
                this.m_20115_(7, false);
            }
        } else {
            super.m_7023_(p_36359_);
        }
        this.m_36378_(this.m_20185_() - d0, this.m_20186_() - d1, this.m_20189_() - d2);
    }

    @Override
    public void m_5844_() {
        if (this.f_36077_.f_35935_) {
            this.m_20282_(false);
        } else {
            super.m_5844_();
        }
    }

    protected boolean m_36350_(BlockPos p_36351_) {
        return !this.m_9236_().m_8055_(p_36351_).m_60828_(this.m_9236_(), p_36351_);
    }

    @Override
    public float m_6113_() {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public void m_36378_(double p_36379_, double p_36380_, double p_36381_) {
        if (!this.m_20159_()) {
            if (this.m_6069_()) {
                int i = Math.round((float)Math.sqrt(p_36379_ * p_36379_ + p_36380_ * p_36380_ + p_36381_ * p_36381_) * 100.0f);
                if (i > 0) {
                    this.m_36222_(Stats.f_12924_, i);
                    this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.SWIM);
                    this.m_36399_(0.01f * (float)i * 0.01f);
                }
            } else if (this.m_204029_(FluidTags.f_13131_)) {
                int j = Math.round((float)Math.sqrt(p_36379_ * p_36379_ + p_36380_ * p_36380_ + p_36381_ * p_36381_) * 100.0f);
                if (j > 0) {
                    this.m_36222_(Stats.f_13001_, j);
                    this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                    this.m_36399_(0.01f * (float)j * 0.01f);
                }
            } else if (this.m_20069_()) {
                int k = Math.round((float)Math.sqrt(p_36379_ * p_36379_ + p_36381_ * p_36381_) * 100.0f);
                if (k > 0) {
                    this.m_36222_(Stats.f_12997_, k);
                    this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                    this.m_36399_(0.01f * (float)k * 0.01f);
                }
            } else if (this.m_6147_()) {
                if (p_36380_ > 0.0) {
                    this.m_36222_(Stats.f_12999_, (int)Math.round(p_36380_ * 100.0));
                }
            } else if (this.m_20096_()) {
                int l = Math.round((float)Math.sqrt(p_36379_ * p_36379_ + p_36381_ * p_36381_) * 100.0f);
                if (l > 0) {
                    if (this.m_20142_()) {
                        this.m_36222_(Stats.f_12996_, l);
                        this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.SPRINT);
                        this.m_36399_(0.1f * (float)l * 0.01f);
                    } else if (this.m_6047_()) {
                        this.m_36222_(Stats.f_12995_, l);
                        this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.CROUCH);
                        this.m_36399_(0.0f * (float)l * 0.01f);
                    } else {
                        this.m_36222_(Stats.f_12994_, l);
                        this.exhaustionReason(EntityExhaustionEvent.ExhaustionReason.WALK);
                        this.m_36399_(0.0f * (float)l * 0.01f);
                    }
                }
            } else if (this.m_21255_()) {
                int i1 = Math.round((float)Math.sqrt(p_36379_ * p_36379_ + p_36380_ * p_36380_ + p_36381_ * p_36381_) * 100.0f);
                this.m_36222_(Stats.f_12923_, i1);
            } else {
                int j1 = Math.round((float)Math.sqrt(p_36379_ * p_36379_ + p_36381_ * p_36381_) * 100.0f);
                if (j1 > 25) {
                    this.m_36222_(Stats.f_13000_, j1);
                }
            }
        }
    }

    private void m_36387_(double p_36388_, double p_36389_, double p_36390_) {
        int i;
        if (this.m_20159_() && (i = Math.round((float)Math.sqrt(p_36388_ * p_36388_ + p_36389_ * p_36389_ + p_36390_ * p_36390_) * 100.0f)) > 0) {
            Entity entity = this.m_20202_();
            if (entity instanceof AbstractMinecart) {
                this.m_36222_(Stats.f_13002_, i);
            } else if (entity instanceof Boat) {
                this.m_36222_(Stats.f_13003_, i);
            } else if (entity instanceof Pig) {
                this.m_36222_(Stats.f_13004_, i);
            } else if (entity instanceof AbstractHorse) {
                this.m_36222_(Stats.f_13005_, i);
            } else if (entity instanceof Strider) {
                this.m_36222_(Stats.f_12925_, i);
            }
        }
    }

    @Override
    public boolean m_142535_(float p_150093_, float p_150094_, DamageSource p_150095_) {
        if (this.f_36077_.f_35936_) {
            ForgeEventFactory.onPlayerFall((Player)this, (float)p_150093_, (float)p_150093_);
            return false;
        }
        if (p_150093_ >= 2.0f) {
            this.m_36222_(Stats.f_12998_, (int)Math.round((double)p_150093_ * 100.0));
        }
        return super.m_142535_(p_150093_, p_150094_, p_150095_);
    }

    public boolean m_36319_() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!(this.m_20096_() || this.m_21255_() || this.m_20069_() || this.m_21023_(MobEffects.f_19620_) || !(itemstack = this.m_6844_(EquipmentSlot.CHEST)).canElytraFly(this))) {
            this.m_36320_();
            return true;
        }
        return false;
    }

    public void m_36320_() {
        if (!CraftEventFactory.callToggleGlideEvent((LivingEntity)this, (boolean)true).isCancelled()) {
            this.m_20115_(7, true);
        } else {
            this.m_20115_(7, true);
            this.m_20115_(7, false);
        }
    }

    public void m_36321_() {
        if (!CraftEventFactory.callToggleGlideEvent((LivingEntity)this, (boolean)false).isCancelled()) {
            this.m_20115_(7, true);
            this.m_20115_(7, false);
        }
    }

    @Override
    protected void m_5841_() {
        if (!this.m_5833_()) {
            super.m_5841_();
        }
    }

    @Override
    protected void m_7355_(BlockPos p_282121_, BlockState p_282194_) {
        if (this.m_20069_()) {
            this.m_280447_();
            this.playMuffledStepSound(p_282194_, p_282121_);
        } else {
            BlockPos blockpos = this.m_276951_(p_282121_);
            if (!p_282121_.equals((Object)blockpos)) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_276549_)) {
                    this.playCombinationStepSounds(blockstate, p_282194_, blockpos, p_282121_);
                } else {
                    super.m_7355_(blockpos, blockstate);
                }
            } else {
                super.m_7355_(p_282121_, p_282194_);
            }
        }
    }

    @Override
    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_12276_, SoundEvents.f_12319_);
    }

    @Override
    public boolean m_214076_(ServerLevel p_219735_, LivingEntity p_219736_) {
        this.m_36246_(Stats.f_12986_.m_12902_(p_219736_.m_6095_()));
        return true;
    }

    @Override
    public void m_7601_(BlockState p_36196_, Vec3 p_36197_) {
        if (!this.f_36077_.f_35935_) {
            super.m_7601_(p_36196_, p_36197_);
        }
    }

    public void m_6756_(int p_36291_) {
        PlayerXpEvent.XpChange event = new PlayerXpEvent.XpChange(this, p_36291_);
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)event)) {
            return;
        }
        p_36291_ = event.getAmount();
        this.m_36401_(p_36291_);
        this.f_36080_ += (float)p_36291_ / (float)this.m_36323_();
        this.f_36079_ = Mth.m_14045_((int)(this.f_36079_ + p_36291_), (int)0, (int)Integer.MAX_VALUE);
        while (this.f_36080_ < 0.0f) {
            float f = this.f_36080_ * (float)this.m_36323_();
            if (this.f_36078_ > 0) {
                this.m_6749_(-1);
                this.f_36080_ = 1.0f + f / (float)this.m_36323_();
                continue;
            }
            this.m_6749_(-1);
            this.f_36080_ = 0.0f;
        }
        while (this.f_36080_ >= 1.0f) {
            this.f_36080_ = (this.f_36080_ - 1.0f) * (float)this.m_36323_();
            this.m_6749_(1);
            this.f_36080_ /= (float)this.m_36323_();
        }
    }

    public int m_36322_() {
        return this.f_36081_;
    }

    public void m_7408_(net.minecraft.world.item.ItemStack p_36172_, int p_36173_) {
        this.m_6749_(-p_36173_);
        if (this.f_36078_ < 0) {
            this.f_36078_ = 0;
            this.f_36080_ = 0.0f;
            this.f_36079_ = 0;
        }
        this.f_36081_ = this.f_19796_.m_188502_();
    }

    public void m_6749_(int p_36276_) {
        PlayerXpEvent.LevelChange event = new PlayerXpEvent.LevelChange(this, p_36276_);
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)event)) {
            return;
        }
        p_36276_ = event.getLevels();
        this.f_36078_ += p_36276_;
        if (this.f_36078_ < 0) {
            this.f_36078_ = 0;
            this.f_36080_ = 0.0f;
            this.f_36079_ = 0;
        }
        if (p_36276_ > 0 && this.f_36078_ % 5 == 0 && (float)this.f_36111_ < (float)this.f_19797_ - 100.0f) {
            float f = this.f_36078_ > 30 ? 1.0f : (float)this.f_36078_ / 30.0f;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12275_, this.m_5720_(), f * 0.75f, 1.0f);
            this.f_36111_ = this.f_19797_;
        }
    }

    public int m_36323_() {
        if (this.f_36078_ >= 30) {
            return 112 + (this.f_36078_ - 30) * 9;
        }
        return this.f_36078_ >= 15 ? 37 + (this.f_36078_ - 15) * 5 : 7 + this.f_36078_ * 2;
    }

    public void m_36399_(float p_36400_) {
        EntityExhaustionEvent event;
        if (!(this.f_36077_.f_35934_ || this.f_19853_.f_46443_ || (event = CraftEventFactory.callPlayerExhaustionEvent((Player)this, (EntityExhaustionEvent.ExhaustionReason)this.reason.getAndSet(EntityExhaustionEvent.ExhaustionReason.UNKNOWN), (float)p_36400_)).isCancelled())) {
            this.f_36097_.m_38703_(event.getExhaustion());
        }
    }

    public void exhaustionReason(EntityExhaustionEvent.ExhaustionReason exhaustionReason) {
        this.reason.set(exhaustionReason);
    }

    public void causeFoodExhaustion(float f, EntityExhaustionEvent.ExhaustionReason reason) {
        this.exhaustionReason(reason);
        this.m_36399_(f);
    }

    public Optional<WardenSpawnTracker> m_245217_() {
        return Optional.empty();
    }

    public FoodData m_36324_() {
        return this.f_36097_;
    }

    public boolean m_36391_(boolean p_36392_) {
        return this.f_36077_.f_35934_ || p_36392_ || this.f_36097_.m_38721_();
    }

    public boolean m_36325_() {
        return this.m_21223_() > 0.0f && this.m_21223_() < this.m_21233_();
    }

    public boolean m_36326_() {
        return this.f_36077_.f_35938_;
    }

    public boolean m_36204_(BlockPos p_36205_, Direction p_36206_, net.minecraft.world.item.ItemStack p_36207_) {
        if (this.f_36077_.f_35938_) {
            return true;
        }
        BlockPos blockpos = p_36205_.m_121945_(p_36206_.m_122424_());
        BlockInWorld blockinworld = new BlockInWorld((LevelReader)this.m_9236_(), blockpos, false);
        return p_36207_.m_204121_((Registry<Block>)this.m_9236_().m_9598_().m_175515_(Registries.f_256747_), blockinworld);
    }

    @Override
    public int m_213860_() {
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && !this.m_5833_()) {
            int i = this.f_36078_ * 7;
            return i > 100 ? 100 : i;
        }
        return 0;
    }

    @Override
    protected boolean m_6124_() {
        return true;
    }

    @Override
    public boolean m_6052_() {
        return true;
    }

    @Override
    protected Entity.MovementEmission m_142319_() {
        return this.f_36077_.f_35935_ || this.m_20096_() && this.m_20163_() ? Entity.MovementEmission.NONE : Entity.MovementEmission.ALL;
    }

    public void m_6885_() {
    }

    @Override
    public Component m_7755_() {
        return Component.m_237113_(this.f_36084_.getName());
    }

    public PlayerEnderChestContainer m_36327_() {
        return this.f_36094_;
    }

    @Override
    public net.minecraft.world.item.ItemStack m_6844_(EquipmentSlot p_36257_) {
        if (p_36257_ == EquipmentSlot.MAINHAND) {
            return this.f_36093_.m_36056_();
        }
        if (p_36257_ == EquipmentSlot.OFFHAND) {
            return (net.minecraft.world.item.ItemStack)((Object)this.f_36093_.f_35976_.get(0));
        }
        return p_36257_.m_20743_() == EquipmentSlot.Type.ARMOR ? (net.minecraft.world.item.ItemStack)((Object)this.f_36093_.f_35975_.get(p_36257_.m_20749_())) : net.minecraft.world.item.ItemStack.f_41583_;
    }

    @Override
    protected boolean m_213772_(EquipmentSlot p_219741_) {
        return p_219741_.m_20743_() == EquipmentSlot.Type.ARMOR;
    }

    @Override
    public void m_8061_(EquipmentSlot p_36161_, net.minecraft.world.item.ItemStack p_36162_) {
        this.m_181122_(p_36162_);
        if (p_36161_ == EquipmentSlot.MAINHAND) {
            this.m_238392_(p_36161_, (net.minecraft.world.item.ItemStack)((Object)this.f_36093_.f_35974_.set(this.f_36093_.f_35977_, (Object)p_36162_)), p_36162_);
        } else if (p_36161_ == EquipmentSlot.OFFHAND) {
            this.m_238392_(p_36161_, (net.minecraft.world.item.ItemStack)((Object)this.f_36093_.f_35976_.set(0, (Object)p_36162_)), p_36162_);
        } else if (p_36161_.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.m_238392_(p_36161_, (net.minecraft.world.item.ItemStack)((Object)this.f_36093_.f_35975_.set(p_36161_.m_20749_(), (Object)p_36162_)), p_36162_);
        }
    }

    @Override
    public void setItemSlot(EquipmentSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.silent0.set(silent);
        this.m_8061_(enumitemslot, itemstack);
    }

    public boolean m_36356_(net.minecraft.world.item.ItemStack p_36357_) {
        return this.f_36093_.m_36054_(p_36357_);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> m_6167_() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.m_21205_(), this.m_21206_()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> m_6168_() {
        return this.f_36093_.f_35975_;
    }

    public boolean m_36360_(CompoundTag p_36361_) {
        if (!this.m_20159_() && this.m_20096_() && !this.m_20069_() && !this.f_146808_) {
            if (this.m_36331_().m_128456_()) {
                this.m_36362_(p_36361_);
                this.f_36109_ = this.m_9236_().m_46467_();
                return true;
            }
            if (this.m_36332_().m_128456_()) {
                this.m_36364_(p_36361_);
                this.f_36109_ = this.m_9236_().m_46467_();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void m_36328_() {
        if (this.f_36109_ + 20L < this.m_9236_().m_46467_()) {
            if (this.spawnEntityFromShoulder(this.m_36331_())) {
                this.m_36362_(new CompoundTag());
            }
            if (this.spawnEntityFromShoulder(this.m_36332_())) {
                this.m_36364_(new CompoundTag());
            }
        }
    }

    private void m_36370_(CompoundTag p_36371_) {
        if (!this.f_19853_.f_46443_ && !p_36371_.m_128456_()) {
            EntityType.m_20642_(p_36371_, this.f_19853_).ifPresent(p_276001_ -> {
                if (p_276001_ instanceof TamableAnimal) {
                    ((TamableAnimal)p_276001_).m_21816_(this.f_19820_);
                }
                p_276001_.m_6034_(this.m_20185_(), this.m_20186_() + (double)0.7f, this.m_20189_());
                boolean canAdd = ((ServerLevel)this.f_19853_).m_8847_((Entity)p_276001_);
                this.spawnEntityFromShoulder.set(canAdd);
            });
        }
    }

    private boolean spawnEntityFromShoulder(CompoundTag pEntityCompound) {
        this.m_36370_(pEntityCompound);
        return this.spawnEntityFromShoulder.getAndSet(true);
    }

    @Override
    public abstract boolean m_5833_();

    @Override
    public boolean m_271807_() {
        return !this.m_5833_() && super.m_271807_();
    }

    @Override
    public boolean m_6069_() {
        return !this.f_36077_.f_35935_ && !this.m_5833_() && super.m_6069_();
    }

    public abstract boolean m_7500_();

    @Override
    public boolean m_6063_() {
        return !this.f_36077_.f_35935_;
    }

    public Scoreboard m_36329_() {
        return this.m_9236_().m_6188_();
    }

    @Override
    public Component m_5446_() {
        if (this.displayname == null) {
            this.displayname = ForgeEventFactory.getPlayerDisplayName((Player)this, (Component)this.m_7755_());
        }
        MutableComponent mutablecomponent = Component.m_237113_("");
        mutablecomponent = this.prefixes.stream().reduce(mutablecomponent, MutableComponent::m_7220_);
        mutablecomponent = mutablecomponent.m_7220_((Component)PlayerTeam.m_83348_((net.minecraft.world.scores.Team)this.m_5647_(), (Component)this.displayname));
        mutablecomponent = this.suffixes.stream().reduce(mutablecomponent, MutableComponent::m_7220_);
        return this.m_36218_(mutablecomponent);
    }

    private MutableComponent m_36218_(MutableComponent p_36219_) {
        String s = this.m_36316_().getName();
        return p_36219_.m_130938_(p_296857_ -> p_296857_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + s + " ")).m_131144_(this.m_20190_()).m_131138_(s));
    }

    @Override
    public String m_6302_() {
        return this.m_36316_().getName();
    }

    @Override
    public float m_6431_(Pose p_36259_, EntityDimensions p_36260_) {
        switch (p_36259_) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    protected void m_292637_(float p_301235_) {
        this.m_20088_().m_135381_(f_36107_, Float.valueOf(p_301235_));
    }

    @Override
    public float m_6103_() {
        return this.m_20088_().m_135370_(f_36107_).floatValue();
    }

    public boolean m_36170_(PlayerModelPart p_36171_) {
        return (this.m_20088_().m_135370_(f_36089_) & p_36171_.m_36445_()) == p_36171_.m_36445_();
    }

    @Override
    public SlotAccess m_141942_(int p_150112_) {
        if (p_150112_ >= 0 && p_150112_ < this.f_36093_.f_35974_.size()) {
            return SlotAccess.m_147292_((Container)this.f_36093_, (int)p_150112_);
        }
        int i = p_150112_ - 200;
        return i >= 0 && i < this.f_36094_.m_6643_() ? SlotAccess.m_147292_((Container)this.f_36094_, (int)i) : super.m_141942_(p_150112_);
    }

    public boolean m_36330_() {
        return this.f_36085_;
    }

    public void m_36393_(boolean p_36394_) {
        this.f_36085_ = p_36394_;
    }

    @Override
    public void m_7311_(int p_36353_) {
        super.m_7311_(this.f_36077_.f_35934_ ? Math.min(p_36353_, 1) : p_36353_);
    }

    @Override
    public HumanoidArm m_5737_() {
        return this.f_19804_.m_135370_(f_36090_) == 0 ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public void m_36163_(HumanoidArm p_36164_) {
        this.f_19804_.m_135381_(f_36090_, (byte)(p_36164_ != HumanoidArm.LEFT ? 1 : 0));
    }

    public CompoundTag m_36331_() {
        return this.f_19804_.m_135370_(f_36091_);
    }

    public void m_36362_(CompoundTag p_36363_) {
        this.f_19804_.m_135381_(f_36091_, p_36363_);
    }

    public CompoundTag m_36332_() {
        return this.f_19804_.m_135370_(f_36092_);
    }

    public void m_36364_(CompoundTag p_36365_) {
        this.f_19804_.m_135381_(f_36092_, p_36365_);
    }

    public float m_36333_() {
        return (float)(1.0 / this.m_21133_(Attributes.f_22283_) * 20.0);
    }

    public float m_36403_(float p_36404_) {
        return Mth.m_14036_((float)(((float)this.f_20922_ + p_36404_) / this.m_36333_()), (float)0.0f, (float)1.0f);
    }

    public void m_36334_() {
        this.f_20922_ = 0;
    }

    public ItemCooldowns m_36335_() {
        return this.f_36087_;
    }

    @Override
    protected float m_6041_() {
        return !this.f_36077_.f_35935_ && !this.m_21255_() ? super.m_6041_() : 1.0f;
    }

    public float m_36336_() {
        return (float)this.m_21133_(Attributes.f_22286_);
    }

    public boolean m_36337_() {
        return this.f_36077_.f_35937_ && this.m_8088_() >= 2;
    }

    @Override
    public boolean m_7066_(net.minecraft.world.item.ItemStack p_36315_) {
        EquipmentSlot equipmentslot = Mob.m_147233_(p_36315_);
        return this.m_6844_(equipmentslot).m_41619_();
    }

    @Override
    public EntityDimensions m_6972_(Pose p_36166_) {
        return f_36074_.getOrDefault(p_36166_, f_36088_);
    }

    @Override
    public ImmutableList<Pose> m_7431_() {
        return ImmutableList.of((Object)Pose.STANDING, (Object)Pose.CROUCHING, (Object)Pose.SWIMMING);
    }

    @Override
    public net.minecraft.world.item.ItemStack m_6298_(net.minecraft.world.item.ItemStack p_36349_) {
        if (!(p_36349_.m_41720_() instanceof ProjectileWeaponItem)) {
            return net.minecraft.world.item.ItemStack.f_41583_;
        }
        Predicate predicate = ((ProjectileWeaponItem)p_36349_.m_41720_()).m_6442_();
        net.minecraft.world.item.ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
        if (!itemstack.m_41619_()) {
            return ForgeHooks.getProjectile((LivingEntity)this, (net.minecraft.world.item.ItemStack)p_36349_, (net.minecraft.world.item.ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)p_36349_.m_41720_()).m_6437_();
        for (int i = 0; i < this.f_36093_.m_6643_(); ++i) {
            net.minecraft.world.item.ItemStack itemstack1 = this.f_36093_.m_8020_(i);
            if (!predicate.test(itemstack1)) continue;
            return ForgeHooks.getProjectile((LivingEntity)this, (net.minecraft.world.item.ItemStack)p_36349_, (net.minecraft.world.item.ItemStack)itemstack1);
        }
        return ForgeHooks.getProjectile((LivingEntity)this, (net.minecraft.world.item.ItemStack)p_36349_, (net.minecraft.world.item.ItemStack)(this.f_36077_.f_35937_ ? new net.minecraft.world.item.ItemStack(Items.f_42412_) : net.minecraft.world.item.ItemStack.f_41583_));
    }

    @Override
    public net.minecraft.world.item.ItemStack m_5584_(Level p_36185_, net.minecraft.world.item.ItemStack p_36186_) {
        this.m_36324_().eat(p_36186_.m_41720_(), p_36186_, this);
        this.m_36246_(Stats.f_12982_.m_12902_((Object)p_36186_.m_41720_()));
        p_36185_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, p_36185_.f_46441_.m_188501_() * 0.1f + 0.9f);
        if (this instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)this, p_36186_);
        }
        return super.m_5584_(p_36185_, p_36186_);
    }

    @Override
    protected boolean m_6757_(BlockState p_36262_) {
        return this.f_36077_.f_35935_ || super.m_6757_(p_36262_);
    }

    @Override
    public Vec3 m_7398_(float p_36374_) {
        float f2;
        double d0 = 0.22 * (this.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float f = Mth.m_14179_((float)(p_36374_ * 0.5f), (float)this.m_146909_(), (float)this.f_19860_) * ((float)Math.PI / 180);
        float f1 = Mth.m_14179_((float)p_36374_, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        if (!this.m_21255_() && !this.m_21209_()) {
            if (this.m_6067_()) {
                return this.m_20318_(p_36374_).m_82549_(new Vec3(d0, 0.2, -0.15).m_82496_(-f).m_82524_(-f1));
            }
            double d5 = this.m_20191_().m_82376_() - 1.0;
            double d6 = this.m_6047_() ? -0.2 : 0.07;
            return this.m_20318_(p_36374_).m_82549_(new Vec3(d0, d5, d6).m_82524_(-f1));
        }
        Vec3 vec3 = this.m_20252_(p_36374_);
        Vec3 vec31 = this.m_20184_();
        double d1 = vec31.m_165925_();
        double d2 = vec3.m_165925_();
        if (d1 > 0.0 && d2 > 0.0) {
            double d3 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d1 * d2);
            double d4 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
            f2 = (float)(Math.signum(d4) * Math.acos(d3));
        } else {
            f2 = 0.0f;
        }
        return this.m_20318_(p_36374_).m_82549_(new Vec3(d0, -0.11, 0.85).m_82535_(-f2).m_82496_(-f).m_82524_(-f1));
    }

    @Override
    public boolean m_142389_() {
        return true;
    }

    public boolean m_150108_() {
        return this.m_6117_() && this.m_21211_().m_150930_(Items.f_151059_);
    }

    @Override
    public boolean m_142391_() {
        return false;
    }

    public Optional<GlobalPos> m_219759_() {
        return this.f_238176_;
    }

    public void m_219749_(Optional<GlobalPos> p_219750_) {
        this.f_238176_ = p_219750_;
    }

    @Override
    public float m_264297_() {
        return this.f_263750_;
    }

    @Override
    public void m_6053_(float p_265280_) {
        super.m_6053_(p_265280_);
        this.f_263750_ = p_265280_;
    }

    @Override
    public boolean m_264410_() {
        return true;
    }

    @Override
    protected float m_274460_() {
        if (this.f_36077_.f_35935_ && !this.m_20159_()) {
            return this.m_20142_() ? this.f_36077_.m_35942_() * 2.0f : this.f_36077_.m_35942_();
        }
        return this.m_20142_() ? 0.025999999f : 0.02f;
    }

    public Collection<MutableComponent> getPrefixes() {
        return this.prefixes;
    }

    public Collection<MutableComponent> getSuffixes() {
        return this.suffixes;
    }

    public void refreshDisplayName() {
        this.displayname = ForgeEventFactory.getPlayerDisplayName((Player)this, (Component)this.m_7755_());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == null) {
                return this.playerJoinedHandler.cast();
            }
            if (facing.m_122434_().m_122478_()) {
                return this.playerMainHandler.cast();
            }
            if (facing.m_122434_().m_122479_()) {
                return this.playerEquipmentHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void setForcedPose(@Nullable Pose pose) {
        this.forcedPose = pose;
    }

    @Nullable
    public Pose getForcedPose() {
        return this.forcedPose;
    }

    public static final class BedSleepingProblem
    extends Enum<BedSleepingProblem> {
        public static final /* enum */ BedSleepingProblem NOT_POSSIBLE_HERE = new BedSleepingProblem();
        public static final /* enum */ BedSleepingProblem NOT_POSSIBLE_NOW = new BedSleepingProblem((Component)Component.m_237115_("block.minecraft.bed.no_sleep"));
        public static final /* enum */ BedSleepingProblem TOO_FAR_AWAY = new BedSleepingProblem((Component)Component.m_237115_("block.minecraft.bed.too_far_away"));
        public static final /* enum */ BedSleepingProblem OBSTRUCTED = new BedSleepingProblem((Component)Component.m_237115_("block.minecraft.bed.obstructed"));
        public static final /* enum */ BedSleepingProblem OTHER_PROBLEM = new BedSleepingProblem();
        public static final /* enum */ BedSleepingProblem NOT_SAFE = new BedSleepingProblem((Component)Component.m_237115_("block.minecraft.bed.not_safe"));
        @Nullable
        private final Component f_36413_;
        private static final /* synthetic */ BedSleepingProblem[] $VALUES;

        public static BedSleepingProblem[] values() {
            return (BedSleepingProblem[])$VALUES.clone();
        }

        public static BedSleepingProblem valueOf(String p_36425_) {
            return Enum.valueOf(BedSleepingProblem.class, p_36425_);
        }

        private BedSleepingProblem() {
            this.f_36413_ = null;
        }

        private BedSleepingProblem(Component p_36422_) {
            this.f_36413_ = p_36422_;
        }

        @Nullable
        public Component m_36423_() {
            return this.f_36413_;
        }

        private static /* synthetic */ BedSleepingProblem[] m_150113_() {
            return new BedSleepingProblem[]{NOT_POSSIBLE_HERE, NOT_POSSIBLE_NOW, TOO_FAR_AWAY, OBSTRUCTED, OTHER_PROBLEM, NOT_SAFE};
        }

        static {
            $VALUES = BedSleepingProblem.m_150113_();
        }
    }
}

