/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BrushItem
extends Item {
    public static final int f_278125_ = 10;
    private static final int f_271380_ = 200;
    private static final double f_279643_ = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    public BrushItem(Item.Properties p_272907_) {
        super(p_272907_);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_272607_) {
        Player player = p_272607_.m_43723_();
        if (player != null && this.m_280200_(player).m_6662_() == HitResult.Type.BLOCK) {
            player.m_6672_(p_272607_.m_43724_());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public UseAnim m_6164_(ItemStack p_273490_) {
        return UseAnim.BRUSH;
    }

    @Override
    public int m_8105_(ItemStack p_272765_) {
        return 200;
    }

    @Override
    public void m_5929_(Level p_273467_, LivingEntity p_273619_, ItemStack p_273316_, int p_273101_) {
        if (p_273101_ >= 0 && p_273619_ instanceof Player) {
            Player player = (Player)p_273619_;
            HitResult hitresult = this.m_280200_(p_273619_);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.m_8105_(p_273316_) - p_273101_ + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        BrushableBlockEntity brushableblockentity;
                        boolean flag1;
                        BlockEntity blockentity;
                        SoundEvent soundevent;
                        Block $$18;
                        HumanoidArm humanoidarm;
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = p_273467_.m_8055_(blockpos);
                        HumanoidArm humanoidArm = humanoidarm = p_273619_.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                        if (blockstate.m_295777_() && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                            this.m_278154_(p_273467_, blockhitresult, blockstate, p_273619_.m_20252_(0.0f), humanoidarm);
                        }
                        if (($$18 = blockstate.m_60734_()) instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)$$18;
                            soundevent = brushableblock.m_276856_();
                        } else {
                            soundevent = SoundEvents.f_276624_;
                        }
                        p_273467_.m_247517_(player, blockpos, soundevent, SoundSource.BLOCKS);
                        if (!p_273467_.m_5776_() && (blockentity = p_273467_.m_7702_(blockpos)) instanceof BrushableBlockEntity && (flag1 = (brushableblockentity = (BrushableBlockEntity)blockentity).m_276923_(p_273467_.m_46467_(), player, blockhitresult.m_82434_()))) {
                            EquipmentSlot equipmentslot = ((Object)((Object)p_273316_)).equals((Object)player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                            p_273316_.m_41622_(1, p_273619_, p_279044_ -> p_279044_.m_21166_(equipmentslot));
                        }
                    }
                    return;
                }
            }
            p_273619_.m_21253_();
        } else {
            p_273619_.m_21253_();
        }
    }

    private HitResult m_280200_(LivingEntity p_281264_) {
        return ProjectileUtil.m_278180_(p_281264_, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), f_279643_);
    }

    public void m_278154_(Level p_278327_, BlockHitResult p_278272_, BlockState p_278235_, Vec3 p_278337_, HumanoidArm p_285071_) {
        double d0 = 3.0;
        int i = p_285071_ == HumanoidArm.RIGHT ? 1 : -1;
        int j = p_278327_.m_213780_().m_216339_(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption((ParticleType<BlockParticleOption>)ParticleTypes.f_123794_, p_278235_);
        Direction direction = p_278272_.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.m_271695_(p_278337_, direction);
        Vec3 vec3 = p_278272_.m_82450_();
        for (int k = 0; k < j; ++k) {
            p_278327_.m_7106_(blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.f_271456_() * (double)i * 3.0 * p_278327_.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.f_271522_() * (double)i * 3.0 * p_278327_.m_213780_().m_188500_());
        }
    }

    record DustParticlesDelta(double f_271456_, double f_271284_, double f_271522_) {
        private static final double f_271382_ = 1.0;
        private static final double f_271440_ = 0.1;

        public static DustParticlesDelta m_271695_(Vec3 p_273421_, Direction p_272987_) {
            double d0 = 0.0;
            return switch (p_272987_) {
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(p_273421_.m_7094_(), 0.0, -p_273421_.m_7096_());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DustParticlesDelta.class, "xd;yd;zd", "f_271456_", "f_271284_", "f_271522_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DustParticlesDelta.class, "xd;yd;zd", "f_271456_", "f_271284_", "f_271522_"}, this);
        }

        @Override
        public final boolean equals(Object p_273751_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DustParticlesDelta.class, "xd;yd;zd", "f_271456_", "f_271284_", "f_271522_"}, this, p_273751_);
        }
    }
}

