/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mohistmc.bukkit.inventory.MohistSpecialRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.apache.commons.lang3.NotImplementedException;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;

public class ShapedRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final int f_44146_;
    final int f_44147_;
    final NonNullList<Ingredient> f_44148_;
    final ItemStack f_44149_;
    final String f_44151_;
    final CraftingBookCategory f_244483_;
    final boolean f_271538_;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ShapedRecipe(String p_272759_, CraftingBookCategory p_273506_, int p_272952_, int p_272920_, NonNullList<Ingredient> p_273650_, ItemStack p_272852_, boolean p_273122_) {
        this.f_44151_ = p_272759_;
        this.f_244483_ = p_273506_;
        this.f_44146_ = p_272952_;
        this.f_44147_ = p_272920_;
        this.f_44148_ = p_273650_;
        this.f_44149_ = p_272852_;
        this.f_271538_ = p_273122_;
    }

    public ShapedRecipe(String p_250221_, CraftingBookCategory p_250716_, int p_251480_, int p_251980_, NonNullList<Ingredient> p_252150_, ItemStack p_248581_) {
        this(p_250221_, p_250716_, p_251480_, p_251980_, p_252150_, p_248581_, true);
    }

    public org.bukkit.inventory.Recipe toBukkitRecipe(NamespacedKey id) {
        if (this.m_44220_() < 1 || this.m_44220_() > 3 || this.m_44221_() < 1 || this.m_44221_() > 3 || this.f_44149_.m_41619_()) {
            return new MohistSpecialRecipe(id, (Recipe)((Object)this));
        }
        CraftItemStack result = CraftItemStack.asCraftMirror((ItemStack)this.f_44149_);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, (org.bukkit.inventory.ItemStack)result, this);
        recipe.setGroup(this.f_44151_);
        recipe.setCategory(CraftRecipe.getCategory((CraftingBookCategory)this.m_245232_()));
        block0 : switch (this.f_44147_) {
            case 1: {
                switch (this.f_44146_) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.f_44146_) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.f_44146_) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c = 'a';
        for (Ingredient list : this.f_44148_) {
            RecipeChoice choice = CraftRecipe.toBukkit((Ingredient)list);
            if (choice != null) {
                recipe.setIngredient(c, choice);
            }
            c = (char)(c + 1);
        }
        return recipe;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44076_;
    }

    public String m_6076_() {
        return this.f_44151_;
    }

    public CraftingBookCategory m_245232_() {
        return this.f_244483_;
    }

    public ItemStack m_8043_(RegistryAccess p_266881_) {
        return this.f_44149_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.f_44148_;
    }

    public boolean m_271738_() {
        return this.f_271538_;
    }

    public boolean m_8004_(int p_44161_, int p_44162_) {
        return p_44161_ >= this.f_44146_ && p_44162_ >= this.f_44147_;
    }

    public boolean m_5818_(CraftingContainer p_44176_, Level p_44177_) {
        for (int i = 0; i <= p_44176_.m_39347_() - this.f_44146_; ++i) {
            for (int j = 0; j <= p_44176_.m_39346_() - this.f_44147_; ++j) {
                if (this.m_44170_(p_44176_, i, j, true)) {
                    return true;
                }
                if (!this.m_44170_(p_44176_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean m_44170_(CraftingContainer p_44171_, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < p_44171_.m_39347_(); ++i) {
            for (int j = 0; j < p_44171_.m_39346_(); ++j) {
                int k = i - p_44172_;
                int l = j - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.f_44146_ && l < this.f_44147_) {
                    ingredient = p_44174_ ? (Ingredient)this.f_44148_.get(this.f_44146_ - k - 1 + l * this.f_44146_) : (Ingredient)this.f_44148_.get(k + l * this.f_44146_);
                }
                if (ingredient.test(p_44171_.m_8020_(i + j * p_44171_.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer p_266686_, RegistryAccess p_266725_) {
        return this.m_8043_(p_266725_).m_41777_();
    }

    public int m_44220_() {
        return this.f_44146_;
    }

    public int getRecipeWidth() {
        return this.m_44220_();
    }

    public int m_44221_() {
        return this.f_44147_;
    }

    public int getRecipeHeight() {
        return this.m_44221_();
    }

    @VisibleForTesting
    static String[] m_44186_(List<String> p_299210_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_299210_.size(); ++i1) {
            String s = p_299210_.get(i1);
            i = Math.min(i, ShapedRecipe.m_44184_(s));
            int j1 = ShapedRecipe.m_44200_(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_299210_.size() == l) {
            return new String[0];
        }
        String[] astring = new String[p_299210_.size() - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_299210_.get(k1 + k).substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int m_44184_(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int m_44200_(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipe> {
        static final Codec<List<String>> f_291059_ = Codec.STRING.listOf().flatXmap(p_297814_ -> {
            if (p_297814_.size() > MAX_HEIGHT) {
                return DataResult.error(() -> "Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
            }
            if (p_297814_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_297814_.get(0)).length();
            for (String s : p_297814_) {
                if (s.length() > MAX_WIDTH) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_297814_);
        }, DataResult::success);
        static final Codec<String> f_291502_ = Codec.STRING.flatXmap(p_301277_ -> {
            if (p_301277_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_301277_ + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(p_301277_) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)p_301277_);
        }, DataResult::success);
        private static final Codec<ShapedRecipe> f_291611_ = RawShapedRecipe.f_290916_.flatXmap(p_300056_ -> {
            String[] astring = ShapedRecipe.m_44186_(p_300056_.f_291411_);
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            HashSet set = Sets.newHashSet(p_300056_.f_291499_.keySet());
            for (int k = 0; k < astring.length; ++k) {
                String s = astring[k];
                for (int l = 0; l < s.length(); ++l) {
                    Ingredient ingredient;
                    String s1 = s.substring(l, l + 1);
                    Ingredient ingredient2 = ingredient = s1.equals(" ") ? Ingredient.f_43901_ : p_300056_.f_291499_.get(s1);
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + s1 + "' but it's not defined in the key");
                    }
                    set.remove(s1);
                    nonnulllist.set(l + i * k, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + String.valueOf(set));
            }
            ShapedRecipe shapedrecipe = new ShapedRecipe(p_300056_.f_291237_, p_300056_.f_291394_, i, j, (NonNullList<Ingredient>)nonnulllist, p_300056_.f_291431_, p_300056_.f_291143_);
            return DataResult.success((Object)shapedrecipe);
        }, p_299463_ -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        @Override
        public Codec<ShapedRecipe> m_292673_() {
            return f_291611_;
        }

        @Override
        public ShapedRecipe m_8005_(FriendlyByteBuf p_44234_) {
            int i = p_44234_.m_130242_();
            int j = p_44234_.m_130242_();
            String s = p_44234_.m_130277_();
            CraftingBookCategory craftingbookcategory = p_44234_.m_130066_(CraftingBookCategory.class);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_(p_44234_));
            }
            ItemStack itemstack = p_44234_.m_130267_();
            boolean flag = p_44234_.readBoolean();
            return new ShapedRecipe(s, craftingbookcategory, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, flag);
        }

        @Override
        public void m_6178_(FriendlyByteBuf p_44227_, ShapedRecipe p_44228_) {
            p_44227_.m_130130_(p_44228_.f_44146_);
            p_44227_.m_130130_(p_44228_.f_44147_);
            p_44227_.m_130070_(p_44228_.f_44151_);
            p_44227_.m_130068_((Enum<?>)p_44228_.f_244483_);
            for (Ingredient ingredient : p_44228_.f_44148_) {
                ingredient.m_43923_(p_44227_);
            }
            p_44227_.m_130055_(p_44228_.f_44149_);
            p_44227_.writeBoolean(p_44228_.f_271538_);
        }

        record RawShapedRecipe(String f_291237_, CraftingBookCategory f_291394_, Map<String, Ingredient> f_291499_, List<String> f_291411_, ItemStack f_291431_, boolean f_291143_) {
            public static final Codec<RawShapedRecipe> f_290916_ = RecordCodecBuilder.create(p_298430_ -> p_298430_.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_300105_ -> p_300105_.f_291237_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301213_ -> p_301213_.f_291394_), (App)ExtraCodecs.m_295464_(f_291502_, Ingredient.f_290991_).fieldOf("key").forGetter(p_297983_ -> p_297983_.f_291499_), (App)f_291059_.fieldOf("pattern").forGetter(p_300956_ -> p_300956_.f_291411_), (App)CraftingRecipeCodecs.f_290789_.fieldOf("result").forGetter(p_299535_ -> p_299535_.f_291431_), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(p_297368_ -> p_297368_.f_291143_)).apply((Applicative)p_298430_, RawShapedRecipe::new));

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "f_291237_", "f_291394_", "f_291499_", "f_291411_", "f_291431_", "f_291143_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "f_291237_", "f_291394_", "f_291499_", "f_291411_", "f_291431_", "f_291143_"}, this);
            }

            @Override
            public final boolean equals(Object p_300575_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "f_291237_", "f_291394_", "f_291499_", "f_291411_", "f_291431_", "f_291143_"}, this, p_300575_);
            }
        }
    }
}

