/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EndPortalBlock
extends BaseEntityBlock {
    protected static final VoxelShape f_53014_ = Block.m_49796_(0.0, 6.0, 0.0, 16.0, 12.0, 16.0);

    public EndPortalBlock(BlockBehaviour.Properties p_53017_) {
        super(p_53017_);
    }

    public BlockEntity m_142194_(BlockPos p_153196_, BlockState p_153197_) {
        return new TheEndPortalBlockEntity(p_153196_, p_153197_);
    }

    public VoxelShape m_5940_(BlockState p_53038_, BlockGetter p_53039_, BlockPos p_53040_, CollisionContext p_53041_) {
        return f_53014_;
    }

    public void m_7892_(BlockState p_53025_, Level p_53026_, BlockPos p_53027_, net.minecraft.world.entity.Entity p_53028_) {
        if (p_53026_ instanceof ServerLevel && p_53028_.m_6072_() && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)p_53028_.m_20191_().m_82386_((double)(-p_53027_.m_123341_()), (double)(-p_53027_.m_123342_()), (double)(-p_53027_.m_123343_()))), (VoxelShape)p_53025_.m_60808_(p_53026_, p_53027_), (BooleanOp)BooleanOp.f_82689_)) {
            ResourceKey<Level> resourcekey = p_53026_.m_46472_() == Level.f_46430_ ? Level.f_46428_ : Level.f_46430_;
            ServerLevel serverlevel = ((ServerLevel)p_53026_).m_7654_().m_129880_(resourcekey);
            if (serverlevel == null) {
                // empty if block
            }
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)p_53028_.getBukkitEntity(), new Location((World)p_53026_.getWorld(), (double)p_53027_.m_123341_(), (double)p_53027_.m_123342_(), (double)p_53027_.m_123343_()));
            p_53026_.getCraftServer().getPluginManager().callEvent((Event)event);
            if (p_53028_ instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)p_53028_;
                if (p_53026_.getCraftServer().getAllowEnd()) {
                    player.changeDimension(serverlevel, PlayerTeleportEvent.TeleportCause.END_PORTAL);
                } else {
                    player.m_5661_((Component)Component.m_237113_("End dimension is not allow at this server"), true);
                }
                return;
            }
            if (p_53026_.getCraftServer().getAllowEnd()) {
                p_53028_.m_5489_(serverlevel);
            }
        }
    }

    public void m_214162_(BlockState p_221102_, Level p_221103_, BlockPos p_221104_, RandomSource p_221105_) {
        double d0 = (double)p_221104_.m_123341_() + p_221105_.m_188500_();
        double d1 = (double)p_221104_.m_123342_() + 0.8;
        double d2 = (double)p_221104_.m_123343_() + p_221105_.m_188500_();
        p_221103_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack m_7397_(BlockGetter p_53021_, BlockPos p_53022_, BlockState p_53023_) {
        return ItemStack.f_41583_;
    }

    public boolean m_5946_(BlockState p_53035_, Fluid p_53036_) {
        return false;
    }
}

