/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.TreeType;

public abstract class AbstractTreeGrower {
    @Nullable
    protected abstract ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource var1, boolean var2);

    public boolean m_213817_(ServerLevel p_222905_, ChunkGenerator p_222906_, BlockPos p_222907_, BlockState p_222908_, RandomSource p_222909_) {
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey = this.m_213888_(p_222909_, this.m_60011_(p_222905_, p_222907_));
        if (resourcekey == null) {
            return false;
        }
        Holder holder = p_222905_.m_9598_().m_175515_(Registries.f_256911_).m_203636_(resourcekey).orElse(null);
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)p_222905_, (RandomSource)p_222909_, (BlockPos)p_222907_, (Holder)holder);
        holder = event.getFeature();
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        this.setTreeType(holder);
        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
        BlockState blockstate = p_222905_.m_6425_(p_222907_).m_76188_();
        p_222905_.m_7731_(p_222907_, blockstate, 4);
        if (configuredfeature.m_224953_((WorldGenLevel)p_222905_, p_222906_, p_222909_, p_222907_)) {
            if (p_222905_.m_8055_(p_222907_) == blockstate) {
                p_222905_.m_7260_(p_222907_, p_222908_, blockstate, 2);
            }
            return true;
        }
        p_222905_.m_7731_(p_222907_, p_222908_, 4);
        return false;
    }

    private boolean m_60011_(LevelAccessor p_60012_, BlockPos p_60013_) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_((BlockPos)p_60013_.m_7495_().m_122013_(2).m_122025_(2), (BlockPos)p_60013_.m_7494_().m_122020_(2).m_122030_(2))) {
            if (!p_60012_.m_8055_(blockpos).m_204336_(BlockTags.f_13041_)) continue;
            return true;
        }
        return false;
    }

    protected void setTreeType(Holder<ConfiguredFeature<?, ?>> holder) {
        ResourceKey<ConfiguredFeature<?, ?>> worldgentreeabstract = holder.m_203543_().get();
        SaplingBlock.treeType = worldgentreeabstract == TreeFeatures.f_195123_ || worldgentreeabstract == TreeFeatures.f_195142_ ? TreeType.TREE : (worldgentreeabstract == TreeFeatures.f_195122_ ? TreeType.RED_MUSHROOM : (worldgentreeabstract == TreeFeatures.f_195121_ ? TreeType.BROWN_MUSHROOM : (worldgentreeabstract == TreeFeatures.f_195129_ ? TreeType.COCOA_TREE : (worldgentreeabstract == TreeFeatures.f_195131_ ? TreeType.SMALL_JUNGLE : (worldgentreeabstract == TreeFeatures.f_195128_ ? TreeType.TALL_REDWOOD : (worldgentreeabstract == TreeFeatures.f_195127_ ? TreeType.REDWOOD : (worldgentreeabstract == TreeFeatures.f_195126_ ? TreeType.ACACIA : (worldgentreeabstract == TreeFeatures.f_195125_ || worldgentreeabstract == TreeFeatures.f_195108_ ? TreeType.BIRCH : (worldgentreeabstract == TreeFeatures.f_195135_ ? TreeType.TALL_BIRCH : (worldgentreeabstract == TreeFeatures.f_195137_ ? TreeType.SWAMP : (worldgentreeabstract == TreeFeatures.f_195130_ || worldgentreeabstract == TreeFeatures.f_195111_ ? TreeType.BIG_TREE : (worldgentreeabstract == TreeFeatures.f_195138_ ? TreeType.JUNGLE_BUSH : (worldgentreeabstract == TreeFeatures.f_195124_ ? TreeType.DARK_OAK : (worldgentreeabstract == TreeFeatures.f_195133_ ? TreeType.MEGA_REDWOOD : (worldgentreeabstract == TreeFeatures.f_195134_ ? TreeType.MEGA_REDWOOD : (worldgentreeabstract == TreeFeatures.f_195132_ ? TreeType.JUNGLE : (worldgentreeabstract == TreeFeatures.f_195139_ ? TreeType.AZALEA : (worldgentreeabstract == TreeFeatures.f_236762_ ? TreeType.MANGROVE : (worldgentreeabstract == TreeFeatures.f_236763_ ? TreeType.TALL_MANGROVE : (worldgentreeabstract == TreeFeatures.f_271469_ || worldgentreeabstract == TreeFeatures.f_271485_ ? TreeType.CHERRY : TreeType.CUSTOM))))))))))))))))))));
    }
}

