/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.bukkit.Bukkit;

public class ChunkStorage
implements AutoCloseable {
    public static final int f_196910_ = 1493;
    private final IOWorker f_63495_;
    protected final DataFixer f_63496_;
    @Nullable
    private volatile LegacyStructureDataHandler f_63497_;
    public ChunkPos pos;
    @Nullable
    LevelAccessor generatoraccess;

    public ChunkStorage(Path p_196912_, DataFixer p_196913_, boolean p_196914_) {
        this.f_63496_ = p_196913_;
        this.f_63495_ = new IOWorker(p_196912_, p_196914_, "chunk");
    }

    public boolean m_223451_(ChunkPos p_223452_, int p_223453_) {
        return this.f_63495_.m_223471_(p_223452_, p_223453_);
    }

    private boolean check(ServerChunkCache cps, int x, int z) {
        CompoundTag nbt;
        ChunkPos pos = new ChunkPos(x, z);
        if (cps != null) {
            Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"primary thread");
            if (cps.m_5563_(x, z)) {
                return true;
            }
        }
        try {
            nbt = this.m_223454_(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            CompoundTag level = nbt.m_128469_("Level");
            if (level.m_128471_("TerrainPopulated")) {
                return true;
            }
            ChunkStatus status = ChunkStatus.m_62397_((String)level.m_128461_("Status"));
            if (status != null && status.m_62427_(ChunkStatus.f_62322_)) {
                return true;
            }
        }
        return false;
    }

    public CompoundTag upgradeChunkTag(ResourceKey<Level> p_188289_, Supplier<DimensionDataStorage> p_188290_, CompoundTag p_188291_, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> p_188292_, ChunkPos pos, @Nullable LevelAccessor generatoraccess) {
        this.pos = pos;
        this.generatoraccess = generatoraccess;
        return this.m_188288_(p_188289_, p_188290_, p_188291_, p_188292_);
    }

    public CompoundTag m_188288_(ResourceKey<Level> p_188289_, Supplier<DimensionDataStorage> p_188290_, CompoundTag p_188291_, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> p_188292_) {
        CompoundTag level;
        int i = ChunkStorage.m_63505_(p_188291_);
        if (this.pos != null && i < 1466 && (level = p_188291_.m_128469_("Level")).m_128471_("TerrainPopulated") && !level.m_128471_("LightPopulated")) {
            ServerChunkCache cps;
            ServerChunkCache serverChunkCache = cps = this.generatoraccess == null ? null : ((ServerLevel)this.generatoraccess).m_7726_();
            if (this.check(cps, this.pos.f_45578_ - 1, this.pos.f_45579_) && this.check(cps, this.pos.f_45578_ - 1, this.pos.f_45579_ - 1) && this.check(cps, this.pos.f_45578_, this.pos.f_45579_ - 1)) {
                level.m_128379_("LightPopulated", true);
            }
        }
        if (i < 1493 && (p_188291_ = DataFixTypes.CHUNK.m_264226_(this.f_63496_, p_188291_, i, 1493)).m_128469_("Level").m_128471_("hasLegacyStructureData")) {
            LegacyStructureDataHandler legacystructuredatahandler = this.m_223448_(p_188289_, p_188290_);
            p_188291_ = legacystructuredatahandler.m_71326_(p_188291_);
        }
        ChunkStorage.m_196918_(p_188291_, p_188289_, p_188292_);
        p_188291_ = DataFixTypes.CHUNK.m_264218_(this.f_63496_, p_188291_, Math.max(1493, i));
        if (i < SharedConstants.m_183709_().m_183476_().m_193006_()) {
            NbtUtils.m_264171_((CompoundTag)p_188291_);
        }
        p_188291_.m_128473_("__context");
        return p_188291_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LegacyStructureDataHandler m_223448_(ResourceKey<Level> p_223449_, Supplier<DimensionDataStorage> p_223450_) {
        LegacyStructureDataHandler legacystructuredatahandler = this.f_63497_;
        if (legacystructuredatahandler == null) {
            ChunkStorage chunkStorage = this;
            synchronized (chunkStorage) {
                legacystructuredatahandler = this.f_63497_;
                if (legacystructuredatahandler == null) {
                    this.f_63497_ = legacystructuredatahandler = LegacyStructureDataHandler.m_71331_(p_223449_, (DimensionDataStorage)p_223450_.get());
                }
            }
        }
        return legacystructuredatahandler;
    }

    public static void m_196918_(CompoundTag p_196919_, ResourceKey<Level> p_196920_, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> p_196921_) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("dimension", p_196920_.m_135782_().toString());
        p_196921_.ifPresent(p_196917_ -> compoundtag.m_128359_("generator", p_196917_.m_135782_().toString()));
        p_196919_.m_128365_("__context", compoundtag);
    }

    public static int m_63505_(CompoundTag p_63506_) {
        return NbtUtils.m_264487_((CompoundTag)p_63506_, (int)-1);
    }

    public CompletableFuture<Optional<CompoundTag>> m_223454_(ChunkPos p_223455_) {
        return this.f_63495_.m_156587_(p_223455_);
    }

    public void m_63502_(ChunkPos p_63503_, CompoundTag p_63504_) {
        this.f_63495_.m_63538_(p_63503_, p_63504_);
        if (this.f_63497_ != null) {
            this.f_63497_.m_71318_(p_63503_.m_45588_());
        }
    }

    public void m_63514_() {
        this.f_63495_.m_182498_(true).join();
    }

    @Override
    public void close() throws IOException {
        this.f_63495_.close();
    }

    public ChunkScanAccess m_196922_() {
        return this.f_63495_;
    }
}

