/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionBitmap;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger f_63619_ = LogUtils.getLogger();
    private static final int f_156605_ = 4096;
    @VisibleForTesting
    protected static final int f_156604_ = 1024;
    private static final int f_156606_ = 5;
    private static final int f_156607_ = 0;
    private static final ByteBuffer f_63620_ = ByteBuffer.allocateDirect(1);
    private static final String f_156608_ = ".mcc";
    private static final int f_156609_ = 128;
    private static final int f_156610_ = 256;
    private static final int f_156611_ = 0;
    private final FileChannel f_63621_;
    private final Path f_63622_;
    final RegionFileVersion f_63623_;
    private final ByteBuffer f_63624_ = ByteBuffer.allocateDirect(8192);
    private final IntBuffer f_63625_;
    private final IntBuffer f_63626_;
    @VisibleForTesting
    protected final RegionBitmap f_63618_ = new RegionBitmap();

    public RegionFile(Path p_196950_, Path p_196951_, boolean p_196952_) throws IOException {
        this(p_196950_, p_196951_, RegionFileVersion.f_63744_, p_196952_);
    }

    public RegionFile(Path p_63633_, Path p_63634_, RegionFileVersion p_63635_, boolean p_63636_) throws IOException {
        this.f_63623_ = p_63635_;
        if (!Files.isDirectory(p_63634_, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + String.valueOf(p_63634_.toAbsolutePath()));
        }
        this.f_63622_ = p_63634_;
        this.f_63625_ = this.f_63624_.asIntBuffer();
        this.f_63625_.limit(1024);
        this.f_63624_.position(4096);
        this.f_63626_ = this.f_63624_.asIntBuffer();
        this.f_63621_ = p_63636_ ? FileChannel.open(p_63633_, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(p_63633_, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.f_63618_.m_63612_(0, 2);
        this.f_63624_.position(0);
        int i = this.f_63621_.read(this.f_63624_, 0L);
        if (i != -1) {
            if (i != 8192) {
                f_63619_.warn("Region file {} has truncated header: {}", (Object)p_63633_, (Object)i);
            }
            long j = Files.size(p_63633_);
            for (int k = 0; k < 1024; ++k) {
                int l = this.f_63625_.get(k);
                if (l == 0) continue;
                int i1 = RegionFile.m_63671_(l);
                int j1 = RegionFile.m_63640_(l);
                if (j1 == 255) {
                    ByteBuffer realLen = ByteBuffer.allocate(4);
                    this.f_63621_.read(realLen, i1 * 4096);
                    j1 = (realLen.getInt(0) + 4) / 4096 + 1;
                }
                if (i1 < 2) {
                    f_63619_.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{p_63633_, k, i1});
                    this.f_63625_.put(k, 0);
                    continue;
                }
                if (j1 == 0) {
                    f_63619_.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)p_63633_, (Object)k);
                    this.f_63625_.put(k, 0);
                    continue;
                }
                if ((long)i1 * 4096L > j) {
                    f_63619_.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{p_63633_, k, i1});
                    this.f_63625_.put(k, 0);
                    continue;
                }
                this.f_63618_.m_63612_(i1, j1);
            }
        }
    }

    private Path m_63684_(ChunkPos p_63685_) {
        String s = "c." + p_63685_.f_45578_ + "." + p_63685_.f_45579_ + f_156608_;
        return this.f_63622_.resolve(s);
    }

    @Nullable
    public synchronized DataInputStream m_63645_(ChunkPos p_63646_) throws IOException {
        int i = this.m_63686_(p_63646_);
        if (i == 0) {
            return null;
        }
        int j = RegionFile.m_63671_(i);
        int k = RegionFile.m_63640_(i);
        if (k == 255) {
            ByteBuffer realLen = ByteBuffer.allocate(4);
            this.f_63621_.read(realLen, j * 4096);
            k = (realLen.getInt(0) + 4) / 4096 + 1;
        }
        int l = k * 4096;
        ByteBuffer bytebuffer = ByteBuffer.allocate(l);
        this.f_63621_.read(bytebuffer, j * 4096);
        bytebuffer.flip();
        if (bytebuffer.remaining() < 5) {
            f_63619_.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{p_63646_, l, bytebuffer.remaining()});
            return null;
        }
        int i1 = bytebuffer.getInt();
        byte b0 = bytebuffer.get();
        if (i1 == 0) {
            f_63619_.warn("Chunk {} is allocated, but stream is missing", (Object)p_63646_);
            return null;
        }
        int j1 = i1 - 1;
        if (RegionFile.m_63638_(b0)) {
            if (j1 != 0) {
                f_63619_.warn("Chunk has both internal and external streams");
            }
            return this.m_63647_(p_63646_, RegionFile.m_63669_(b0));
        }
        if (j1 > bytebuffer.remaining()) {
            f_63619_.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{p_63646_, j1, bytebuffer.remaining()});
            return null;
        }
        if (j1 < 0) {
            f_63619_.error("Declared size {} of chunk {} is negative", (Object)i1, (Object)p_63646_);
            return null;
        }
        return this.m_63650_(p_63646_, b0, RegionFile.m_63659_(bytebuffer, j1));
    }

    private static int m_156612_() {
        return (int)(Util.m_137574_() / 1000L);
    }

    private static boolean m_63638_(byte p_63639_) {
        return (p_63639_ & 0x80) != 0;
    }

    private static byte m_63669_(byte p_63670_) {
        return (byte)(p_63670_ & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream m_63650_(ChunkPos p_63651_, byte p_63652_, InputStream p_63653_) throws IOException {
        RegionFileVersion regionfileversion = RegionFileVersion.m_63756_((int)p_63652_);
        if (regionfileversion == null) {
            f_63619_.error("Chunk {} has invalid chunk stream version {}", (Object)p_63651_, (Object)p_63652_);
            return null;
        }
        return new DataInputStream(regionfileversion.m_63760_(p_63653_));
    }

    @Nullable
    private DataInputStream m_63647_(ChunkPos p_63648_, byte p_63649_) throws IOException {
        Path path = this.m_63684_(p_63648_);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            f_63619_.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.m_63650_(p_63648_, p_63649_, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream m_63659_(ByteBuffer p_63660_, int p_63661_) {
        return new ByteArrayInputStream(p_63660_.array(), p_63660_.position(), p_63661_);
    }

    private int m_63642_(int p_63643_, int p_63644_) {
        return p_63643_ << 8 | p_63644_;
    }

    private static int m_63640_(int p_63641_) {
        return p_63641_ & 0xFF;
    }

    private static int m_63671_(int p_63672_) {
        return p_63672_ >> 8 & 0xFFFFFF;
    }

    private static int m_63676_(int p_63677_) {
        return (p_63677_ + 4096 - 1) / 4096;
    }

    public boolean m_63673_(ChunkPos p_63674_) {
        int i = this.m_63686_(p_63674_);
        if (i == 0) {
            return false;
        }
        int j = RegionFile.m_63671_(i);
        int k = RegionFile.m_63640_(i);
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        try {
            this.f_63621_.read(bytebuffer, j * 4096);
            bytebuffer.flip();
            if (bytebuffer.remaining() != 5) {
                return false;
            }
            int l = bytebuffer.getInt();
            byte b0 = bytebuffer.get();
            if (RegionFile.m_63638_(b0)) {
                if (!RegionFileVersion.m_63764_((int)RegionFile.m_63669_(b0))) {
                    return false;
                }
                if (!Files.isRegularFile(this.m_63684_(p_63674_), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileVersion.m_63764_((int)b0)) {
                    return false;
                }
                if (l == 0) {
                    return false;
                }
                int i1 = l - 1;
                if (i1 < 0 || i1 > 4096 * k) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public DataOutputStream m_63678_(ChunkPos p_63679_) throws IOException {
        return new DataOutputStream(this.f_63623_.m_63762_((OutputStream)new ChunkBuffer(p_63679_)));
    }

    public void m_63637_() throws IOException {
        this.f_63621_.force(true);
    }

    public void m_156613_(ChunkPos p_156614_) throws IOException {
        int i = RegionFile.m_63688_(p_156614_);
        int j = this.f_63625_.get(i);
        if (j != 0) {
            this.f_63625_.put(i, 0);
            this.f_63626_.put(i, RegionFile.m_156612_());
            this.m_63675_();
            Files.deleteIfExists(this.m_63684_(p_156614_));
            this.f_63618_.m_63615_(RegionFile.m_63671_(j), RegionFile.m_63640_(j));
        }
    }

    protected synchronized void m_63654_(ChunkPos p_63655_, ByteBuffer p_63656_) throws IOException {
        CommitOp regionfile$commitop;
        int k1;
        int i = RegionFile.m_63688_(p_63655_);
        int j = this.f_63625_.get(i);
        int k = RegionFile.m_63671_(j);
        int l = RegionFile.m_63640_(j);
        int i1 = p_63656_.remaining();
        int j1 = RegionFile.m_63676_(i1);
        if (j1 >= 256) {
            Path path = this.m_63684_(p_63655_);
            f_63619_.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{p_63655_, i1, path});
            j1 = 1;
            k1 = this.f_63618_.m_63610_(j1);
            regionfile$commitop = this.m_63662_(path, p_63656_);
            ByteBuffer bytebuffer = this.m_63668_();
            this.f_63621_.write(bytebuffer, k1 * 4096);
        } else {
            k1 = this.f_63618_.m_63610_(j1);
            regionfile$commitop = () -> Files.deleteIfExists(this.m_63684_(p_63655_));
            this.f_63621_.write(p_63656_, k1 * 4096);
        }
        this.f_63625_.put(i, this.m_63642_(k1, j1));
        this.f_63626_.put(i, RegionFile.m_156612_());
        this.m_63675_();
        regionfile$commitop.m_63698_();
        if (k != 0) {
            this.f_63618_.m_63615_(k, l);
        }
    }

    private ByteBuffer m_63668_() {
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        bytebuffer.putInt(1);
        bytebuffer.put((byte)(this.f_63623_.m_63755_() | 0x80));
        bytebuffer.flip();
        return bytebuffer;
    }

    private CommitOp m_63662_(Path p_63663_, ByteBuffer p_63664_) throws IOException {
        Path path = Files.createTempFile(this.f_63622_, "tmp", (String)null, new FileAttribute[0]);
        try (FileChannel filechannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            p_63664_.position(5);
            filechannel.write(p_63664_);
        }
        return () -> Files.move(path, p_63663_, StandardCopyOption.REPLACE_EXISTING);
    }

    private void m_63675_() throws IOException {
        this.f_63624_.position(0);
        this.f_63621_.write(this.f_63624_, 0L);
    }

    private int m_63686_(ChunkPos p_63687_) {
        return this.f_63625_.get(RegionFile.m_63688_(p_63687_));
    }

    public boolean m_63682_(ChunkPos p_63683_) {
        return this.m_63686_(p_63683_) != 0;
    }

    private static int m_63688_(ChunkPos p_63689_) {
        return p_63689_.m_45613_() + p_63689_.m_45614_() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.m_63681_();
        }
        finally {
            try {
                this.f_63621_.force(true);
            }
            finally {
                this.f_63621_.close();
            }
        }
    }

    private void m_63681_() throws IOException {
        int j;
        int i = (int)this.f_63621_.size();
        if (i != (j = RegionFile.m_63676_(i) * 4096)) {
            ByteBuffer bytebuffer = f_63620_.duplicate();
            bytebuffer.position(0);
            this.f_63621_.write(bytebuffer, j - 1);
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos f_63693_;

        public ChunkBuffer(ChunkPos p_63696_) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.f_63623_.m_63755_());
            this.f_63693_ = p_63696_;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            bytebuffer.putInt(0, this.count - 5 + 1);
            RegionFile.this.m_63654_(this.f_63693_, bytebuffer);
        }
    }

    static interface CommitOp {
        public void m_63698_() throws IOException;
    }
}

