/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_20_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_20_R2.map.RenderData;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.slf4j.Logger;

public class MapItemSavedData
extends SavedData {
    private static final Logger f_77895_ = LogUtils.getLogger();
    private static final int f_164765_ = 128;
    private static final int f_164766_ = 64;
    public static final int f_164764_ = 4;
    public static final int f_181307_ = 256;
    public int f_256718_;
    public int f_256789_;
    public ResourceKey<Level> f_77887_;
    public boolean f_77888_;
    public boolean f_77889_;
    public byte f_77890_;
    public byte[] f_77891_ = new byte[16384];
    public boolean f_77892_;
    public final List<HoldingPlayer> f_77893_ = Lists.newArrayList();
    public final Map<Player, HoldingPlayer> f_77896_ = Maps.newHashMap();
    private final Map<String, MapBanner> f_77897_ = Maps.newHashMap();
    public final Map<String, MapDecoration> f_77894_ = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> f_77898_ = Maps.newHashMap();
    private int f_181308_;
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public String id;
    private RenderData vanillaRender = new RenderData();

    public static SavedData.Factory<MapItemSavedData> m_295558_() {
        return new SavedData.Factory(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, MapItemSavedData::m_164807_, DataFixTypes.SAVED_DATA_MAP_DATA);
    }

    private MapItemSavedData(int p_164768_, int p_164769_, byte p_164770_, boolean p_164771_, boolean p_164772_, boolean p_164773_, ResourceKey<Level> p_164774_) {
        this.f_77890_ = p_164770_;
        this.f_256718_ = p_164768_;
        this.f_256789_ = p_164769_;
        this.f_77887_ = p_164774_;
        this.f_77888_ = p_164771_;
        this.f_77889_ = p_164772_;
        this.f_77892_ = p_164773_;
        this.m_77762_();
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
        this.vanillaRender.buffer = this.f_77891_;
    }

    public static MapItemSavedData m_164780_(double p_164781_, double p_164782_, byte p_164783_, boolean p_164784_, boolean p_164785_, ResourceKey<Level> p_164786_) {
        int i = 128 * (1 << p_164783_);
        int j = Mth.m_14107_((double)((p_164781_ + 64.0) / (double)i));
        int k = Mth.m_14107_((double)((p_164782_ + 64.0) / (double)i));
        int l = j * i + i / 2 - 64;
        int i1 = k * i + i / 2 - 64;
        return new MapItemSavedData(l, i1, p_164783_, p_164784_, p_164785_, false, p_164786_);
    }

    public static MapItemSavedData m_164776_(byte p_164777_, boolean p_164778_, ResourceKey<Level> p_164779_) {
        return new MapItemSavedData(0, 0, p_164777_, false, false, p_164778_, p_164779_);
    }

    public static MapItemSavedData m_164807_(CompoundTag p_164808_) {
        ResourceKey resourcekey = DimensionType.m_63911_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_164808_.m_128423_("dimension"))).resultOrPartial(arg_0 -> ((Logger)f_77895_).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = p_164808_.m_128454_("UUIDLeast");
            long most = p_164808_.m_128454_("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().m_46472_();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(p_164808_.m_128423_("dimension")));
        });
        int i = p_164808_.m_128451_("xCenter");
        int j = p_164808_.m_128451_("zCenter");
        byte b0 = (byte)Mth.m_14045_((int)p_164808_.m_128445_("scale"), (int)0, (int)4);
        boolean flag = !p_164808_.m_128425_("trackingPosition", 1) || p_164808_.m_128471_("trackingPosition");
        boolean flag1 = p_164808_.m_128471_("unlimitedTracking");
        boolean flag2 = p_164808_.m_128471_("locked");
        MapItemSavedData mapitemsaveddata = new MapItemSavedData(i, j, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = p_164808_.m_128463_("colors");
        if (abyte.length == 16384) {
            mapitemsaveddata.f_77891_ = abyte;
        }
        mapitemsaveddata.vanillaRender.buffer = abyte;
        ListTag listtag = p_164808_.m_128437_("banners", 10);
        for (int k = 0; k < listtag.size(); ++k) {
            MapBanner mapbanner = MapBanner.m_77777_((CompoundTag)listtag.m_128728_(k));
            mapitemsaveddata.f_77897_.put(mapbanner.m_77787_(), mapbanner);
            mapitemsaveddata.m_77937_(mapbanner.m_77782_(), null, mapbanner.m_77787_(), mapbanner.m_77773_().m_123341_(), mapbanner.m_77773_().m_123343_(), 180.0, mapbanner.m_77783_());
        }
        ListTag listtag1 = p_164808_.m_128437_("frames", 10);
        for (int l = 0; l < listtag1.size(); ++l) {
            MapFrame mapframe = MapFrame.m_77872_((CompoundTag)listtag1.m_128728_(l));
            mapitemsaveddata.f_77898_.put(mapframe.m_77877_(), mapframe);
            mapitemsaveddata.m_77937_(MapDecoration.Type.FRAME, null, "frame-" + mapframe.m_77876_(), mapframe.m_77874_().m_123341_(), mapframe.m_77874_().m_123343_(), mapframe.m_77875_(), null);
        }
        return mapitemsaveddata;
    }

    public CompoundTag m_7176_(CompoundTag p_77956_) {
        ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.f_77887_.m_135782_()).resultOrPartial(arg_0 -> ((Logger)f_77895_).error(arg_0)).ifPresent(p_77954_ -> p_77956_.m_128365_("dimension", (Tag)p_77954_));
        if (this.uniqueId == null) {
            for (Object world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().m_46472_() != this.f_77887_) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            p_77956_.m_128356_("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            p_77956_.m_128356_("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        p_77956_.m_128405_("xCenter", this.f_256718_);
        p_77956_.m_128405_("zCenter", this.f_256789_);
        p_77956_.m_128344_("scale", this.f_77890_);
        p_77956_.m_128382_("colors", this.f_77891_);
        p_77956_.m_128379_("trackingPosition", this.f_77888_);
        p_77956_.m_128379_("unlimitedTracking", this.f_77889_);
        p_77956_.m_128379_("locked", this.f_77892_);
        ListTag listtag = new ListTag();
        for (MapBanner mapbanner : this.f_77897_.values()) {
            listtag.add((Object)mapbanner.m_77784_());
        }
        p_77956_.m_128365_("banners", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (MapFrame mapframe : this.f_77898_.values()) {
            listtag1.add((Object)mapframe.m_77869_());
        }
        p_77956_.m_128365_("frames", (Tag)listtag1);
        return p_77956_;
    }

    public MapItemSavedData m_164775_() {
        MapItemSavedData mapitemsaveddata = new MapItemSavedData(this.f_256718_, this.f_256789_, this.f_77890_, this.f_77888_, this.f_77889_, true, this.f_77887_);
        mapitemsaveddata.f_77897_.putAll(this.f_77897_);
        mapitemsaveddata.f_77894_.putAll(this.f_77894_);
        mapitemsaveddata.f_181308_ = this.f_181308_;
        System.arraycopy(this.f_77891_, 0, mapitemsaveddata.f_77891_, 0, this.f_77891_.length);
        mapitemsaveddata.m_77762_();
        return mapitemsaveddata;
    }

    public MapItemSavedData m_164787_(int p_164788_) {
        return MapItemSavedData.m_164780_(this.f_256718_, this.f_256789_, (byte)Mth.m_14045_((int)(this.f_77890_ + p_164788_), (int)0, (int)4), this.f_77888_, this.f_77889_, this.f_77887_);
    }

    public void m_77918_(Player p_77919_, ItemStack p_77920_) {
        CompoundTag compoundtag;
        if (!this.f_77896_.containsKey(p_77919_)) {
            HoldingPlayer mapitemsaveddata$holdingplayer = new HoldingPlayer(p_77919_);
            this.f_77896_.put(p_77919_, mapitemsaveddata$holdingplayer);
            this.f_77893_.add(mapitemsaveddata$holdingplayer);
        }
        if (!p_77919_.m_150109_().m_36063_(p_77920_)) {
            this.m_164799_(p_77919_.m_7755_().getString());
        }
        for (int i = 0; i < this.f_77893_.size(); ++i) {
            HoldingPlayer mapitemsaveddata$holdingplayer1 = this.f_77893_.get(i);
            String s = mapitemsaveddata$holdingplayer1.f_77959_.m_7755_().getString();
            if (!mapitemsaveddata$holdingplayer1.f_77959_.m_213877_() && (mapitemsaveddata$holdingplayer1.f_77959_.m_150109_().m_36063_(p_77920_) || p_77920_.m_41794_())) {
                if (p_77920_.m_41794_() || mapitemsaveddata$holdingplayer1.f_77959_.m_9236_().m_46472_() != this.f_77887_ || !this.f_77888_) continue;
                this.m_77937_(MapDecoration.Type.PLAYER, mapitemsaveddata$holdingplayer1.f_77959_.m_9236_(), s, mapitemsaveddata$holdingplayer1.f_77959_.m_20185_(), mapitemsaveddata$holdingplayer1.f_77959_.m_20189_(), mapitemsaveddata$holdingplayer1.f_77959_.m_146908_(), null);
                continue;
            }
            this.f_77896_.remove(mapitemsaveddata$holdingplayer1.f_77959_);
            this.f_77893_.remove(mapitemsaveddata$holdingplayer1);
            this.m_164799_(s);
        }
        if (p_77920_.m_41794_() && this.f_77888_) {
            ItemFrame itemframe = p_77920_.m_41795_();
            BlockPos blockpos = itemframe.m_31748_();
            MapFrame mapframe1 = this.f_77898_.get(MapFrame.m_77870_((BlockPos)blockpos));
            if (mapframe1 != null && itemframe.m_19879_() != mapframe1.m_77876_() && this.f_77898_.containsKey(mapframe1.m_77877_())) {
                this.m_164799_("frame-" + mapframe1.m_77876_());
            }
            MapFrame mapframe = new MapFrame(blockpos, itemframe.m_6350_().m_122416_() * 90, itemframe.m_19879_());
            this.m_77937_(MapDecoration.Type.FRAME, p_77919_.m_9236_(), "frame-" + itemframe.m_19879_(), blockpos.m_123341_(), blockpos.m_123343_(), itemframe.m_6350_().m_122416_() * 90, null);
            this.f_77898_.put(mapframe.m_77877_(), mapframe);
        }
        if ((compoundtag = p_77920_.m_41783_()) != null && compoundtag.m_128425_("Decorations", 9)) {
            ListTag listtag = compoundtag.m_128437_("Decorations", 10);
            for (int j = 0; j < listtag.size(); ++j) {
                CompoundTag compoundtag1 = listtag.m_128728_(j);
                if (this.f_77894_.containsKey(compoundtag1.m_128461_("id"))) continue;
                this.m_77937_(MapDecoration.Type.m_77854_((byte)compoundtag1.m_128445_("type")), p_77919_.m_9236_(), compoundtag1.m_128461_("id"), compoundtag1.m_128459_("x"), compoundtag1.m_128459_("z"), compoundtag1.m_128459_("rot"), null);
            }
        }
    }

    private void m_164799_(String p_164800_) {
        MapDecoration mapdecoration = this.f_77894_.remove(p_164800_);
        if (mapdecoration != null && mapdecoration.f_77791_().m_181306_()) {
            --this.f_181308_;
        }
        this.m_164812_();
    }

    public static void m_77925_(ItemStack p_77926_, BlockPos p_77927_, String p_77928_, MapDecoration.Type p_77929_) {
        ListTag listtag;
        if (p_77926_.m_41782_() && p_77926_.m_41783_().m_128425_("Decorations", 9)) {
            listtag = p_77926_.m_41783_().m_128437_("Decorations", 10);
        } else {
            listtag = new ListTag();
            p_77926_.m_41700_("Decorations", (Tag)listtag);
        }
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128344_("type", p_77929_.m_77853_());
        compoundtag.m_128359_("id", p_77928_);
        compoundtag.m_128347_("x", p_77927_.m_123341_());
        compoundtag.m_128347_("z", p_77927_.m_123343_());
        compoundtag.m_128347_("rot", 180.0);
        listtag.add((Object)compoundtag);
        if (p_77929_.m_77857_()) {
            CompoundTag compoundtag1 = p_77926_.m_41698_("display");
            compoundtag1.m_128405_("MapColor", p_77929_.m_77858_());
        }
    }

    private void m_77937_(MapDecoration.Type p_77938_, @Nullable LevelAccessor p_77939_, String p_77940_, double p_77941_, double p_77942_, double p_77943_, @Nullable Component p_77944_) {
        MapDecoration mapdecoration;
        MapDecoration mapdecoration1;
        byte b2;
        int i = 1 << this.f_77890_;
        float f = (float)(p_77941_ - (double)this.f_256718_) / (float)i;
        float f1 = (float)(p_77942_ - (double)this.f_256789_) / (float)i;
        byte b0 = (byte)((double)(f * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        int j = 63;
        if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((p_77943_ += p_77943_ < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.f_77887_ == Level.f_46429_ && p_77939_ != null) {
                int l = (int)(p_77939_.m_6106_().m_6792_() / 10L);
                b2 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
        } else {
            if (p_77938_ != MapDecoration.Type.PLAYER) {
                this.m_164799_(p_77940_);
                return;
            }
            int k = 320;
            if (Math.abs(f) < 320.0f && Math.abs(f1) < 320.0f) {
                p_77938_ = MapDecoration.Type.PLAYER_OFF_MAP;
            } else {
                if (!this.f_77889_) {
                    this.m_164799_(p_77940_);
                    return;
                }
                p_77938_ = MapDecoration.Type.PLAYER_OFF_LIMITS;
            }
            b2 = 0;
            if (f <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        if (!(mapdecoration1 = new MapDecoration(p_77938_, b0, b1, b2, p_77944_)).equals((Object)(mapdecoration = this.f_77894_.put(p_77940_, mapdecoration1)))) {
            if (mapdecoration != null && mapdecoration.f_77791_().m_181306_()) {
                --this.f_181308_;
            }
            if (p_77938_.m_181306_()) {
                ++this.f_181308_;
            }
            this.m_164812_();
        }
    }

    @Nullable
    public Packet<?> m_164796_(int p_164797_, Player p_164798_) {
        HoldingPlayer mapitemsaveddata$holdingplayer = this.f_77896_.get(p_164798_);
        return mapitemsaveddata$holdingplayer == null ? null : mapitemsaveddata$holdingplayer.m_164815_(p_164797_);
    }

    public void m_164789_(int p_164790_, int p_164791_) {
        this.m_77762_();
        for (HoldingPlayer mapitemsaveddata$holdingplayer : this.f_77893_) {
            mapitemsaveddata$holdingplayer.m_164817_(p_164790_, p_164791_);
        }
    }

    public void m_164812_() {
        this.m_77762_();
        this.f_77893_.forEach(HoldingPlayer::m_164820_);
    }

    public HoldingPlayer m_77916_(Player p_77917_) {
        HoldingPlayer mapitemsaveddata$holdingplayer = this.f_77896_.get(p_77917_);
        if (mapitemsaveddata$holdingplayer == null) {
            mapitemsaveddata$holdingplayer = new HoldingPlayer(p_77917_);
            this.f_77896_.put(p_77917_, mapitemsaveddata$holdingplayer);
            this.f_77893_.add(mapitemsaveddata$holdingplayer);
        }
        return mapitemsaveddata$holdingplayer;
    }

    public boolean m_77934_(LevelAccessor p_77935_, BlockPos p_77936_) {
        double d0 = (double)p_77936_.m_123341_() + 0.5;
        double d1 = (double)p_77936_.m_123343_() + 0.5;
        int i = 1 << this.f_77890_;
        double d2 = (d0 - (double)this.f_256718_) / (double)i;
        double d3 = (d1 - (double)this.f_256789_) / (double)i;
        int j = 63;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapBanner mapbanner = MapBanner.m_77774_((BlockGetter)p_77935_, (BlockPos)p_77936_);
            if (mapbanner == null) {
                return false;
            }
            if (this.f_77897_.remove(mapbanner.m_77787_(), mapbanner)) {
                this.m_164799_(mapbanner.m_77787_());
                return true;
            }
            if (!this.m_181312_(256)) {
                this.f_77897_.put(mapbanner.m_77787_(), mapbanner);
                this.m_77937_(mapbanner.m_77782_(), p_77935_, mapbanner.m_77787_(), d0, d1, 180.0, mapbanner.m_77783_());
                return true;
            }
        }
        return false;
    }

    public void m_77930_(BlockGetter p_77931_, int p_77932_, int p_77933_) {
        Iterator<MapBanner> iterator = this.f_77897_.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapbanner1;
            MapBanner mapbanner = iterator.next();
            if (mapbanner.m_77773_().m_123341_() != p_77932_ || mapbanner.m_77773_().m_123343_() != p_77933_ || mapbanner.equals((Object)(mapbanner1 = MapBanner.m_77774_((BlockGetter)p_77931_, (BlockPos)mapbanner.m_77773_())))) continue;
            iterator.remove();
            this.m_164799_(mapbanner.m_77787_());
        }
    }

    public Collection<MapBanner> m_164809_() {
        return this.f_77897_.values();
    }

    public void m_77947_(BlockPos p_77948_, int p_77949_) {
        this.m_164799_("frame-" + p_77949_);
        this.f_77898_.remove(MapFrame.m_77870_((BlockPos)p_77948_));
    }

    public boolean m_164792_(int p_164793_, int p_164794_, byte p_164795_) {
        byte b0 = this.f_77891_[p_164793_ + p_164794_ * 128];
        if (b0 != p_164795_) {
            this.m_164803_(p_164793_, p_164794_, p_164795_);
            return true;
        }
        return false;
    }

    public void m_164803_(int p_164804_, int p_164805_, byte p_164806_) {
        this.f_77891_[p_164804_ + p_164805_ * 128] = p_164806_;
        this.m_164789_(p_164804_, p_164805_);
    }

    public boolean m_164810_() {
        for (MapDecoration mapdecoration : this.f_77894_.values()) {
            if (!mapdecoration.f_77791_().m_294654_()) continue;
            return true;
        }
        return false;
    }

    public void m_164801_(List<MapDecoration> p_164802_) {
        this.f_77894_.clear();
        this.f_181308_ = 0;
        for (int i = 0; i < p_164802_.size(); ++i) {
            MapDecoration mapdecoration = p_164802_.get(i);
            this.f_77894_.put("icon-" + i, mapdecoration);
            if (!mapdecoration.f_77791_().m_181306_()) continue;
            ++this.f_181308_;
        }
    }

    public Iterable<MapDecoration> m_164811_() {
        return this.f_77894_.values();
    }

    public boolean m_181312_(int p_181313_) {
        return this.f_181308_ >= p_181313_;
    }

    public class HoldingPlayer {
        public final Player f_77959_;
        private boolean f_77962_ = true;
        private int f_77963_;
        private int f_77964_;
        private int f_77965_ = 127;
        private int f_77966_ = 127;
        private boolean f_164813_ = true;
        private int f_77967_;
        public int f_77960_;

        HoldingPlayer(Player p_77970_) {
            this.f_77959_ = p_77970_;
        }

        private MapPatch m_164814_() {
            int i = this.f_77963_;
            int j = this.f_77964_;
            int k = this.f_77965_ + 1 - this.f_77963_;
            int l = this.f_77966_ + 1 - this.f_77964_;
            byte[] abyte = new byte[k * l];
            for (int i1 = 0; i1 < k; ++i1) {
                for (int j1 = 0; j1 < l; ++j1) {
                    abyte[i1 + j1 * k] = MapItemSavedData.this.f_77891_[i + i1 + (j + j1) * 128];
                }
            }
            return new MapPatch(i, j, k, l, abyte);
        }

        private void addSeenPlayers(Collection<MapDecoration> icons) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)this.f_77959_.getBukkitEntity();
            MapItemSavedData.this.f_77894_.forEach((name, mapIcon) -> {
                org.bukkit.entity.Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapDecoration)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return MapItemSavedData.this.mapView.getRenderers().size() == 1 && ((MapRenderer)MapItemSavedData.this.mapView.getRenderers().get(0)).getClass() == CraftMapRenderer.class;
        }

        @Nullable
        Packet<?> m_164815_(int p_164816_) {
            ArrayList<MapDecoration> collection;
            MapPatch mapitemsaveddata$mappatch;
            RenderData render;
            boolean vanillaMaps = this.shouldUseVanillaMap();
            RenderData renderData = render = !vanillaMaps ? MapItemSavedData.this.mapView.render((CraftPlayer)this.f_77959_.getBukkitEntity()) : MapItemSavedData.this.vanillaRender;
            if (this.f_77962_) {
                this.f_77962_ = false;
                byte[] colors = MapItemSavedData.this.f_77891_;
                MapItemSavedData.this.f_77891_ = render.buffer;
                mapitemsaveddata$mappatch = this.m_164814_();
                MapItemSavedData.this.f_77891_ = colors;
            } else {
                mapitemsaveddata$mappatch = null;
            }
            if (this.f_77967_++ % 5 == 0) {
                this.f_164813_ = false;
                ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
                if (vanillaMaps) {
                    this.addSeenPlayers(icons);
                }
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapDecoration(MapDecoration.Type.m_77854_((byte)cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull((String)cursor.getCaption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && mapitemsaveddata$mappatch == null ? null : new ClientboundMapItemDataPacket(p_164816_, MapItemSavedData.this.f_77890_, MapItemSavedData.this.f_77892_, collection, mapitemsaveddata$mappatch);
        }

        void m_164817_(int p_164818_, int p_164819_) {
            if (this.f_77962_) {
                this.f_77963_ = Math.min(this.f_77963_, p_164818_);
                this.f_77964_ = Math.min(this.f_77964_, p_164819_);
                this.f_77965_ = Math.max(this.f_77965_, p_164818_);
                this.f_77966_ = Math.max(this.f_77966_, p_164819_);
            } else {
                this.f_77962_ = true;
                this.f_77963_ = p_164818_;
                this.f_77964_ = p_164819_;
                this.f_77965_ = p_164818_;
                this.f_77966_ = p_164819_;
            }
        }

        private void m_164820_() {
            this.f_164813_ = true;
        }
    }

    public static class MapPatch {
        public final int f_164821_;
        public final int f_164822_;
        public final int f_164823_;
        public final int f_164824_;
        public final byte[] f_164825_;

        public MapPatch(int p_164827_, int p_164828_, int p_164829_, int p_164830_, byte[] p_164831_) {
            this.f_164821_ = p_164827_;
            this.f_164822_ = p_164828_;
            this.f_164823_ = p_164829_;
            this.f_164824_ = p_164830_;
            this.f_164825_ = p_164831_;
        }

        public void m_164832_(MapItemSavedData p_164833_) {
            for (int i = 0; i < this.f_164823_; ++i) {
                for (int j = 0; j < this.f_164824_; ++j) {
                    p_164833_.m_164803_(this.f_164821_ + i, this.f_164822_ + j, this.f_164825_[i + j * this.f_164823_]);
                }
            }
        }
    }
}

