/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class LootDataType<T> {
    private static final Logger f_278425_ = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> f_278407_ = new LootDataType(LootItemConditions.f_290534_, "predicates", LootDataType.m_278693_());
    public static final LootDataType<LootItemFunction> f_278496_ = new LootDataType(LootItemFunctions.f_291699_, "item_modifiers", LootDataType.m_278693_());
    public static final LootDataType<LootTable> f_278413_ = new LootDataType<LootTable>(LootTable.f_290440_, "loot_tables", LootDataType.m_278846_());
    private final Codec<T> f_290795_;
    private final String f_278462_;
    private final Validator<T> f_278443_;

    private LootDataType(Codec<T> p_298670_, String p_279433_, Validator<T> p_279363_) {
        this.f_290795_ = p_298670_;
        this.f_278462_ = p_279433_;
        this.f_278443_ = p_279363_;
    }

    public String m_278624_() {
        return this.f_278462_;
    }

    public void m_278701_(ValidationContext p_279366_, LootDataId<T> p_279106_, T p_279124_) {
        this.f_278443_.m_278714_(p_279366_, p_279106_, p_279124_);
    }

    public Optional<T> m_278763_(ResourceLocation p_279253_, JsonElement p_279330_) {
        DataResult dataresult = this.f_290795_.parse((DynamicOps)JsonOps.INSTANCE, (Object)p_279330_);
        dataresult.error().ifPresent(p_297003_ -> f_278425_.error("Couldn't parse element {}:{} - {}", new Object[]{this.f_278462_, p_279253_, p_297003_.message()}));
        Optional<LootTable> ret = dataresult.result();
        if (this == f_278413_ && ret.isPresent()) {
            ret = Optional.ofNullable(ForgeEventFactory.onLoadLootTable((ResourceLocation)p_279253_, (LootTable)((LootTable)ret.get())));
        }
        return ret;
    }

    public static Stream<LootDataType<?>> m_278779_() {
        return Stream.of(f_278407_, f_278496_, f_278413_);
    }

    private static <T extends LootContextUser> Validator<T> m_278693_() {
        return (p_279353_, p_279374_, p_279097_) -> p_279097_.m_6169_(p_279353_.m_278632_("{" + p_279374_.f_278383_().f_278462_ + ":" + String.valueOf(p_279374_.f_278500_()) + "}", p_279374_));
    }

    private static Validator<LootTable> m_278846_() {
        return (p_279333_, p_279227_, p_279406_) -> p_279406_.m_79136_(p_279333_.m_79355_(p_279406_.m_79122_()).m_278632_("{" + p_279227_.f_278383_().f_278462_ + ":" + String.valueOf(p_279227_.f_278500_()) + "}", p_279227_));
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public void m_278714_(ValidationContext var1, LootDataId<T> var2, T var3);
    }
}

