/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ForgeHooks;
import org.bukkit.craftbukkit.v1_20_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger f_79107_ = LogUtils.getLogger();
    public static final LootTable f_79105_ = new LootTable(LootContextParamSets.f_81410_, Optional.empty(), List.of(), List.of());
    public static final LootContextParamSet f_79106_ = LootContextParamSets.f_81420_;
    public static final Codec<LootTable> f_290440_ = RecordCodecBuilder.create(p_297011_ -> p_297011_.group((App)LootContextParamSets.f_290720_.optionalFieldOf("type", (Object)f_79106_).forGetter(p_297013_ -> p_297013_.f_79108_), (App)ExtraCodecs.m_294263_(ResourceLocation.f_135803_, (String)"random_sequence").forGetter(p_297014_ -> p_297014_.f_286958_), (App)ExtraCodecs.m_295827_((Codec)LootPool.CONDITIONAL_CODEC.listOf(), (String)"pools", List.of()).forGetter(p_297012_ -> p_297012_.f_79109_), (App)ExtraCodecs.m_295827_((Codec)LootItemFunctions.f_291699_.listOf(), (String)"functions", List.of()).forGetter(p_297010_ -> p_297010_.f_79110_)).apply((Applicative)p_297011_, LootTable::new));
    private final LootContextParamSet f_79108_;
    private final Optional<ResourceLocation> f_286958_;
    private final List<LootPool> f_79109_;
    private final List<LootItemFunction> f_79110_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79111_;
    public CraftLootTable craftLootTable;
    public AtomicBoolean isPlugin = new AtomicBoolean(false);
    private ResourceLocation lootTableId;
    private boolean isFrozen = false;

    LootTable(LootContextParamSet p_287716_, Optional<ResourceLocation> p_298628_, List<LootPool> p_298771_, List<LootItemFunction> p_301234_) {
        this.f_79108_ = p_287716_;
        this.f_286958_ = p_298628_;
        this.f_79109_ = Lists.newArrayList(p_298771_);
        this.f_79110_ = p_301234_;
        this.f_79111_ = LootItemFunctions.m_80770_(p_301234_);
    }

    public static Consumer<ItemStack> m_246283_(ServerLevel p_287765_, Consumer<ItemStack> p_251308_) {
        return p_287570_ -> {
            if (p_287570_.m_246617_(p_287765_.m_246046_())) {
                if (p_287570_.m_41613_() < p_287570_.m_41741_()) {
                    p_251308_.accept((ItemStack)((Object)p_287570_));
                } else {
                    ItemStack itemstack;
                    for (int i = p_287570_.m_41613_(); i > 0; i -= itemstack.m_41613_()) {
                        itemstack = p_287570_.m_255036_(Math.min(p_287570_.m_41741_(), i));
                        p_251308_.accept(itemstack);
                    }
                }
            }
        };
    }

    @Deprecated
    public void m_287190_(LootParams p_287669_, Consumer<ItemStack> p_287781_) {
        this.m_79131_(new LootContext.Builder(p_287669_).m_287259_(this.f_286958_), p_287781_);
    }

    @Deprecated
    public void m_79131_(LootContext p_79132_, Consumer<ItemStack> p_79133_) {
        LootContext.VisitedEntry<LootTable> visitedentry = LootContext.m_278811_(this);
        if (p_79132_.m_278759_(visitedentry)) {
            Consumer consumer = LootItemFunction.m_80724_(this.f_79111_, p_79133_, (LootContext)p_79132_);
            for (LootPool lootpool : this.f_79109_) {
                lootpool.m_79053_(consumer, p_79132_);
            }
            p_79132_.m_278639_(visitedentry);
        } else {
            f_79107_.warn("Detected infinite loop in loot tables");
        }
    }

    public void m_287276_(LootParams p_287748_, long p_287729_, Consumer<ItemStack> p_287583_) {
        this.m_230922_(new LootContext.Builder(p_287748_).m_78965_(p_287729_).m_287259_(this.f_286958_)).forEach(p_287583_);
    }

    public void m_287228_(LootParams p_287704_, Consumer<ItemStack> p_287617_) {
        this.m_287195_(p_287704_).forEach(p_287617_);
    }

    public void m_79148_(LootContext p_79149_, Consumer<ItemStack> p_79150_) {
        this.m_230922_(p_79149_).forEach(p_79150_);
    }

    public ObjectArrayList<ItemStack> m_287214_(LootParams p_287574_, long p_287773_) {
        return this.m_230922_(new LootContext.Builder(p_287574_).m_78965_(p_287773_).m_287259_(this.f_286958_));
    }

    public ObjectArrayList<ItemStack> m_287195_(LootParams p_287616_) {
        return this.m_230922_(new LootContext.Builder(p_287616_).m_287259_(this.f_286958_));
    }

    public ObjectArrayList<ItemStack> m_230922_(LootContext p_230923_) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        this.m_79131_(p_230923_, LootTable.m_246283_(p_230923_.m_78952_(), arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0)));
        objectarraylist = ForgeHooks.modifyLoot((ResourceLocation)this.getLootTableId(), (ObjectArrayList)objectarraylist, (LootContext)p_230923_);
        return objectarraylist;
    }

    public LootContextParamSet m_79122_() {
        return this.f_79108_;
    }

    public void m_79136_(ValidationContext p_79137_) {
        for (int i = 0; i < this.f_79109_.size(); ++i) {
            this.f_79109_.get(i).m_79051_(p_79137_.m_79365_(".pools[" + i + "]"));
        }
        for (int j = 0; j < this.f_79110_.size(); ++j) {
            this.f_79110_.get(j).m_6169_(p_79137_.m_79365_(".functions[" + j + "]"));
        }
    }

    public void fillInventory(Container pContainer, LootParams pParams, long pSeed, boolean plugin) {
        this.isPlugin.set(plugin);
        this.m_287188_(pContainer, pParams, pSeed);
    }

    public void m_287188_(Container p_287662_, LootParams p_287743_, long p_287585_) {
        LootContext lootcontext = new LootContext.Builder(p_287743_).m_78965_(p_287585_).m_287259_(this.f_286958_);
        ObjectArrayList objectarraylist = this.m_230922_(lootcontext);
        RandomSource randomsource = lootcontext.m_230907_();
        if (lootcontext.m_78936_(LootContextParams.f_81460_) && lootcontext.m_78936_(LootContextParams.f_81455_)) {
            LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent((Container)p_287662_, (LootTable)this, (LootContext)lootcontext, objectarraylist, (boolean)this.isPlugin.getAndSet(false));
            if (event.isCancelled()) {
                return;
            }
            objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        }
        List<Integer> list = this.m_230919_(p_287662_, randomsource);
        this.m_230924_(objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                f_79107_.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.m_41619_()) {
                p_287662_.m_6836_(list.remove(list.size() - 1), ItemStack.f_41583_);
                continue;
            }
            p_287662_.m_6836_(list.remove(list.size() - 1), itemstack);
        }
    }

    private void m_230924_(ObjectArrayList<ItemStack> p_230925_, int p_230926_, RandomSource p_230927_) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = p_230925_.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)((Object)iterator.next());
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_230926_ - p_230925_.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)((Object)list.remove(Mth.m_216271_((RandomSource)p_230927_, (int)0, (int)(list.size() - 1))));
            int i = Mth.m_216271_((RandomSource)p_230927_, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && p_230927_.m_188499_()) {
                list.add(itemstack2);
            } else {
                p_230925_.add((Object)itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && p_230927_.m_188499_()) {
                list.add(itemstack1);
                continue;
            }
            p_230925_.add((Object)itemstack1);
        }
        p_230925_.addAll((Collection)list);
        Util.m_214673_(p_230925_, p_230927_);
    }

    private List<Integer> m_230919_(Container p_230920_, RandomSource p_230921_) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i = 0; i < p_230920_.m_6643_(); ++i) {
            if (!p_230920_.m_8020_(i).m_41619_()) continue;
            objectarraylist.add((Object)i);
        }
        Util.m_214673_(objectarraylist, p_230921_);
        return objectarraylist;
    }

    public static Builder m_79147_() {
        return new Builder();
    }

    public void setLootTableId(ResourceLocation id) {
        if (this.lootTableId != null) {
            throw new IllegalStateException("Attempted to rename loot table from '" + String.valueOf(this.lootTableId) + "' to '" + String.valueOf(id) + "': this is not supported");
        }
        this.lootTableId = Objects.requireNonNull(id);
    }

    public ResourceLocation getLootTableId() {
        return this.lootTableId;
    }

    @Nullable
    public LootPool removePool(String name) {
        this.checkFrozen();
        for (LootPool pool : this.f_79109_) {
            if (!name.equals(pool.getName())) continue;
            this.f_79109_.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool pool) {
        this.checkFrozen();
        if (this.f_79109_.stream().anyMatch(e -> e == pool)) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + String.valueOf(pool));
        }
        this.f_79109_.add(pool);
    }

    public void freeze() {
        this.isFrozen = true;
        this.f_79109_.forEach(LootPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPool> f_79156_ = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> f_79157_ = ImmutableList.builder();
        private LootContextParamSet f_79158_ = f_79106_;
        private Optional<ResourceLocation> f_287003_ = Optional.empty();

        public Builder m_79161_(LootPool.Builder p_79162_) {
            this.f_79156_.add((Object)p_79162_.m_79082_());
            return this;
        }

        public Builder m_79165_(LootContextParamSet p_79166_) {
            this.f_79158_ = p_79166_;
            return this;
        }

        public Builder m_287223_(ResourceLocation p_287667_) {
            this.f_287003_ = Optional.of(p_287667_);
            return this;
        }

        public Builder m_79078_(LootItemFunction.Builder p_79164_) {
            this.f_79157_.add((Object)p_79164_.m_7453_());
            return this;
        }

        public Builder m_79073_() {
            return this;
        }

        public LootTable m_79167_() {
            return new LootTable(this.f_79158_, this.f_287003_, (List<LootPool>)this.f_79156_.build(), (List<LootItemFunction>)this.f_79157_.build());
        }
    }
}

